/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.pixels;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.Deflater;
import org.jetbrains.letsPlot.util.pngj.IdatChunkWriter;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;
import org.jetbrains.letsPlot.util.pngj.Zip;
import org.jetbrains.letsPlot.util.pngj.pixels.CompressorStream;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B1\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB-\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0016J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/CompressorStreamDeflater;", "Lorg/jetbrains/letsPlot/util/pngj/pixels/CompressorStream;", "idatCw", "Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;", "maxBlockLen", "", "totalLen", "", "deflaterCompLevel", "deflaterStrategy", "(Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;IJII)V", "def", "Lorg/jetbrains/letsPlot/util/pngj/Deflater;", "(Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;IJLorg/jetbrains/letsPlot/util/pngj/Deflater;)V", "buf1", "", "deflater", "deflaterIsOwn", "", "close", "", "deflate", "done", "mywrite", "data", "off", "len", "reset", "plot-api"})
public final class CompressorStreamDeflater
extends CompressorStream {
    @NotNull
    private final Deflater deflater;
    @Nullable
    private byte[] buf1;
    private boolean deflaterIsOwn;

    @JvmOverloads
    public CompressorStreamDeflater(@Nullable IdatChunkWriter idatCw, int maxBlockLen, long totalLen, @Nullable Deflater def) {
        super(idatCw, maxBlockLen, totalLen);
        this.deflaterIsOwn = true;
        Deflater deflater = def;
        if (deflater == null) {
            deflater = Zip.newDeflater$default(Zip.INSTANCE, 0, 1, null);
        }
        this.deflater = deflater;
        this.deflaterIsOwn = def == null;
    }

    public /* synthetic */ CompressorStreamDeflater(IdatChunkWriter idatChunkWriter, int n, long l, Deflater deflater, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            deflater = null;
        }
        this(idatChunkWriter, n, l, deflater);
    }

    public CompressorStreamDeflater(@Nullable IdatChunkWriter idatCw, int maxBlockLen, long totalLen, int deflaterCompLevel, int deflaterStrategy) {
        this(idatCw, maxBlockLen, totalLen, Zip.INSTANCE.newDeflater(deflaterCompLevel));
        this.deflaterIsOwn = true;
        this.deflater.setStrategy(deflaterStrategy);
    }

    @Override
    public void mywrite(@NotNull byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.deflater.finished() || this.isDone() || this.isClosed()) {
            throw new PngjOutputException("write beyond end of stream");
        }
        this.deflater.setInput(data, off, len);
        this.setBytesIn(this.getBytesIn() + (long)len);
        while (!this.deflater.needsInput()) {
            this.deflate();
        }
    }

    private final void deflate() {
        byte[] buf = null;
        int off = 0;
        int n = 0;
        if (this.getIdatChunkWriter() != null) {
            IdatChunkWriter idatChunkWriter = this.getIdatChunkWriter();
            Intrinsics.checkNotNull((Object)idatChunkWriter);
            buf = idatChunkWriter.getBuf();
            IdatChunkWriter idatChunkWriter2 = this.getIdatChunkWriter();
            Intrinsics.checkNotNull((Object)idatChunkWriter2);
            off = idatChunkWriter2.getOffset();
            IdatChunkWriter idatChunkWriter3 = this.getIdatChunkWriter();
            Intrinsics.checkNotNull((Object)idatChunkWriter3);
            n = idatChunkWriter3.getAvailLen();
        } else {
            if (this.buf1 == null) {
                this.buf1 = new byte[4096];
            }
            Intrinsics.checkNotNull((Object)this.buf1);
            buf = this.buf1;
            off = 0;
            Intrinsics.checkNotNull((Object)this.buf1);
            n = this.buf1.length;
        }
        int len = this.deflater.deflate(buf, off, n);
        if (len > 0) {
            if (this.getIdatChunkWriter() != null) {
                IdatChunkWriter idatChunkWriter = this.getIdatChunkWriter();
                Intrinsics.checkNotNull((Object)idatChunkWriter);
                idatChunkWriter.incrementOffset(len);
            }
            this.setBytesOut(this.getBytesOut() + (long)len);
        }
    }

    @Override
    public void done() {
        if (this.isDone()) {
            return;
        }
        if (!this.deflater.finished()) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate();
            }
        }
        this.setDone(true);
        if (this.getIdatChunkWriter() != null) {
            IdatChunkWriter idatChunkWriter = this.getIdatChunkWriter();
            Intrinsics.checkNotNull((Object)idatChunkWriter);
            idatChunkWriter.close();
        }
    }

    @Override
    public void close() {
        this.done();
        try {
            if (this.deflaterIsOwn) {
                this.deflater.end();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        super.close();
    }

    @Override
    public void reset() {
        this.deflater.reset();
        super.reset();
    }

    @JvmOverloads
    public CompressorStreamDeflater(@Nullable IdatChunkWriter idatCw, int maxBlockLen, long totalLen) {
        this(idatCw, maxBlockLen, totalLen, null, 8, null);
    }
}

