/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.util.io.URLUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NamePrefixSearchQuery;", "Lcom/intellij/javascript/nodejs/npm/registry/NpmRegistryService$SearchQuery;", "prefix", "", "<init>", "(Ljava/lang/String;)V", "myBaseUrl", "myStartKey", "Lorg/jetbrains/annotations/NotNull;", "myEndKey", "getQueryUrl", "from", "", "limit", "maxQueryBatchSize", "getMaxQueryBatchSize", "()I", "parseContent", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "content", "toString", "PrefixPackageListJsonReader", "intellij.javascript.impl"})
public final class NamePrefixSearchQuery
extends NpmRegistryService.SearchQuery {
    @NotNull
    private final String myBaseUrl;
    @NotNull
    private final String myStartKey;
    @NotNull
    private final String myEndKey;

    public NamePrefixSearchQuery(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        super(prefix);
        this.myBaseUrl = StringsKt.startsWith$default((String)prefix, (String)"@", (boolean)false, (int)2, null) ? "https://replicate.npmjs.com" : "https://skimdb.npmjs.com";
        String string = URLUtil.encodeURIComponent((String)("[\"" + prefix + "\"]"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeURIComponent(...)");
        this.myStartKey = string;
        String string2 = URLUtil.encodeURIComponent((String)("[\"" + prefix + "z\",{}]"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeURIComponent(...)");
        this.myEndKey = string2;
    }

    @Override
    @NotNull
    public String getQueryUrl(int from, int limit) {
        return this.myBaseUrl + "/registry/_design/app/_view/browseAll?group_level=2&skip=" + from + "&limit=" + limit + "&start_key=" + this.myStartKey + "&end_key=" + this.myEndKey;
    }

    @Override
    public int getMaxQueryBatchSize() {
        return 10000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Closeable closeable = (Closeable)new JsonReader((Reader)new StringReader(content));
        Throwable throwable = null;
        try {
            JsonReader reader = (JsonReader)closeable;
            boolean bl = false;
            List<NodePackageBasicInfo> list = new PrefixPackageListJsonReader(reader).read();
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public String toString() {
        return "'" + this.myText + "*' (Prefix)";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NamePrefixSearchQuery$PrefixPackageListJsonReader;", "", "myReader", "Lcom/google/gson/stream/JsonReader;", "<init>", "(Lcom/google/gson/stream/JsonReader;)V", "myResult", "", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "read", "", "readPackagesInsideRows", "", "Companion", "intellij.javascript.impl"})
    private static final class PrefixPackageListJsonReader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JsonReader myReader;
        @NotNull
        private final List<NodePackageBasicInfo> myResult;

        public PrefixPackageListJsonReader(@NotNull JsonReader myReader) {
            Intrinsics.checkNotNullParameter((Object)myReader, (String)"myReader");
            this.myReader = myReader;
            this.myResult = new ArrayList();
        }

        @NotNull
        public final List<NodePackageBasicInfo> read() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return CollectionsKt.emptyList();
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if (Intrinsics.areEqual((Object)"rows", (Object)name)) {
                    this.readPackagesInsideRows();
                    break;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
            return this.myResult;
        }

        public final void readPackagesInsideRows() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                NodePackageBasicInfo info = PrefixPackageListJsonReader.Companion.readSinglePackage(this.myReader);
                if (info == null) continue;
                this.myResult.add(info);
            }
            this.myReader.endArray();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/nodejs/npm/registry/NamePrefixSearchQuery$PrefixPackageListJsonReader$Companion;", "", "<init>", "()V", "readSinglePackage", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "reader", "Lcom/google/gson/stream/JsonReader;", "readArrayInsideKey", "intellij.javascript.impl"})
        public static final class Companion {
            private Companion() {
            }

            private final NodePackageBasicInfo readSinglePackage(JsonReader reader) throws IOException {
                if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                    reader.skipValue();
                    return null;
                }
                reader.beginObject();
                NodePackageBasicInfo info = null;
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (Intrinsics.areEqual((Object)"key", (Object)name)) {
                        info = this.readArrayInsideKey(reader);
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                return info;
            }

            private final NodePackageBasicInfo readArrayInsideKey(JsonReader reader) throws IOException {
                if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                    reader.skipValue();
                    return null;
                }
                reader.beginArray();
                String name = null;
                String description = null;
                int i = 0;
                while (reader.hasNext()) {
                    if (i < 2 && reader.peek() == JsonToken.STRING) {
                        String str = reader.nextString();
                        if (i == 0) {
                            name = str;
                        } else {
                            description = str;
                        }
                    } else {
                        reader.skipValue();
                    }
                    ++i;
                }
                reader.endArray();
                return name != null ? new NodePackageBasicInfo(name, description) : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

