/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.names;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNamedEntityKind;
import com.intellij.lang.javascript.names.JSNamesSuggester;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNameSuggestionsUtil {
    public static final Logger LOG = Logger.getInstance(JSNameSuggestionsUtil.class);
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";
    @NonNls
    private static final String ELEMENT_SUFFIX = "Element";
    @NonNls
    private static final String KEY_SUFFIX = "Key";
    @NotNull
    public static final List<String> COMMON_METHOD_PREFIXES = List.of("add", "remove", "push", "contains", "check", "validate", "assert", "create", "read", "update", "delete", "get", "set", "is", "has", "append", "send", "receive", "register", "unregister", "install", "find", "replace", "insert", "write", "run", "exec", "execute", "calculate", "compute", "encode", "decode", "parse", "serialize", "deserialize", "toggle", "render");
    private static final List<String> FOR_LOOP_VARS = Arrays.asList("i", "j", "k");
    public static final String SPLIT_BY_CAMEL_CASE_REGEX = "(?<!^)(?=[A-Z])";

    @NotNull
    public static String getImplSuffix(Project project) {
        return IMPL_SUFFIX;
    }

    @Contract(value="null, _ -> false")
    private static boolean isIdentifier(@Nullable String name, @Nullable PsiElement context2) {
        if (name == null) {
            return false;
        }
        if ((name = QualifiedName.fromDottedString((String)name).getLastComponent()) == null) {
            return false;
        }
        JavascriptLanguage language = context2 == null ? JavascriptLanguage.INSTANCE : context2.getLanguage();
        Project project = context2 == null ? null : context2.getProject();
        return LanguageNamesValidation.isIdentifier((Language)language, (String)name, (Project)project);
    }

    @Nullable
    private static String generateNameFromJSTypeOrNull(@Nullable JSType type, @NotNull PsiElement context2) {
        if (context2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(0);
        }
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type, context2)) == null) {
            return null;
        }
        if (type instanceof JSAnyType) {
            return null;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            String literal = ((JSStringLiteralTypeImpl)type).getLiteral();
            if (literal.length() > 0 && StringUtil.isJavaIdentifierStart((char)literal.charAt(0))) {
                return literal;
            }
            return "s";
        }
        if (type instanceof JSIntType || type instanceof JSUintType) {
            return "i";
        }
        if (type instanceof JSStringType || type instanceof JSTemplateLiteralType) {
            return "s";
        }
        if (type instanceof JSBooleanType) {
            return "b";
        }
        if (type instanceof JSPrimitiveFunctionType) {
            return "f";
        }
        String s = type.getTypeText(JSType.TypeTextFormat.CODE);
        if (!DialectDetector.isJavaScriptFamily(context2) && "Class".equals(s)) {
            return "cls";
        }
        if (JSTypeUtils.getIndexableComponentType(type) != null || type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSNamedType) {
            return JSNameSuggestionsUtil.getNameForComplexType(type, context2);
        }
        return StringUtil.isEmpty((String)s) || !JSNameSuggestionsUtil.isIdentifier(s, context2) ? null : s;
    }

    @Nullable
    private static String getNameForComplexType(@NotNull JSType type, @NotNull PsiElement context2) {
        String s;
        if (type == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(2);
        }
        return StringUtil.isEmpty((String)(s = (String)ObjectUtils.coalesce((Object)JSNameSuggestionsUtil.getNameFromIterableType(type, context2), (Object)JSNameSuggestionsUtil.getNameFromGenericType(type)))) || !JSNameSuggestionsUtil.isIdentifier(s, context2) ? null : s;
    }

    @Nullable
    private static String getNameFromIterableType(@NotNull JSType type, @NotNull PsiElement context2) {
        JSType arrayComponentOrNull;
        if (type == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(4);
        }
        if ((arrayComponentOrNull = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSTypeUtils.getIndexableComponentType(type), context2)) != null && !(arrayComponentOrNull instanceof JSAnyType) && !(arrayComponentOrNull instanceof JSEvaluableType)) {
            return StringUtil.pluralize((String)arrayComponentOrNull.getTypeText(JSType.TypeTextFormat.CODE));
        }
        return null;
    }

    @Nullable
    private static String getNameFromGenericType(@NotNull JSType type) {
        JSType jSType;
        JSGenericTypeImpl genericType;
        if (type == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(5);
        }
        JSGenericTypeImpl jSGenericTypeImpl = genericType = type instanceof JSGenericTypeImpl ? (JSGenericTypeImpl)type : null;
        if (genericType != null && (jSType = genericType.getType()) instanceof JSNamedType) {
            JSType jsType;
            JSNamedType baseType = (JSNamedType)jSType;
            List<JSType> arguments = genericType.getArguments();
            String baseText = baseType.getTypeText(JSType.TypeTextFormat.CODE);
            if (arguments.size() == 1 && (jsType = arguments.get(0)) instanceof JSNamedType) {
                return jsType.getTypeText(JSType.TypeTextFormat.CODE) + baseText;
            }
            return baseText;
        }
        return null;
    }

    @Nullable
    public static String generateVariableNameFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope2) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(6);
        }
        return JSNameSuggestionsUtil.generateVariableNameFromExpression(mainOccurrence, scope2, false);
    }

    @Nullable
    public static String generateVariableNameFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope2, boolean avoidItemsFromTypes) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(7);
        }
        List<String> names = JSNameSuggestionsUtil.generateVariableNamesFromExpression(mainOccurrence, scope2, "", Collections.emptyList(), JSNamedEntityKind.Variable, avoidItemsFromTypes);
        return (String)ContainerUtil.getFirstItem(names);
    }

    @NotNull
    public static List<String> generateVariableNamesFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope2, @NotNull Collection<String> existing) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(8);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(9);
        }
        return JSNameSuggestionsUtil.generateVariableNamesFromExpression(mainOccurrence, scope2, "", existing, JSNamedEntityKind.Variable);
    }

    @NotNull
    public static List<String> generateVariableNamesFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope2, @NotNull String namePrefix, @NotNull Collection<String> existing, @NotNull JSNamedEntityKind entityKind) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(10);
        }
        if (namePrefix == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(11);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(12);
        }
        if (entityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(13);
        }
        return JSNameSuggestionsUtil.generateVariableNamesFromExpression(mainOccurrence, scope2, namePrefix, existing, entityKind, false);
    }

    @NotNull
    public static List<String> generateVariableNamesFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope2, @NotNull String namePrefix, @NotNull Collection<String> existing, @NotNull JSNamedEntityKind entityKind, boolean avoidItemsFromTypes) {
        int intValue;
        Object value;
        JSLiteralExpression literalExpression;
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(14);
        }
        if (namePrefix == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(15);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(16);
        }
        if (entityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(17);
        }
        if (!mainOccurrence.isValid()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(18);
            }
            return list;
        }
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        Processor processor = s -> {
            if (StringUtil.isEmpty((String)s)) {
                return true;
            }
            for (String string : JSNameSuggestionsUtil.generateNamesFromQualifiedName(s, mainOccurrence instanceof JSIndexedPropertyAccessExpression)) {
                void var7_7;
                if (namePrefix.length() > 0) {
                    String string3 = Character.isLetterOrDigit(namePrefix.charAt(namePrefix.length() - 1)) ? StringUtil.capitalize((String)string) : string;
                    string3 = namePrefix + string3;
                }
                results.add(JSNameSuggestionsUtil.ensureUniqueVariableName((String)var7_7, scope2, existing, false));
            }
            return true;
        };
        JSNameSuggestionsUtil.processCandidates(mainOccurrence, (Processor<? super String>)processor, entityKind, avoidItemsFromTypes);
        if (mainOccurrence instanceof JSIndexedPropertyAccessExpression && (literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)((JSIndexedPropertyAccessExpression)mainOccurrence).getIndexExpression(), JSLiteralExpression.class)) != null && literalExpression.getExpressionKind(true).isInteger() && (value = literalExpression.getValue()) instanceof Number && (intValue = ((Number)value).intValue()) >= 0) {
            List<String> ordinalVariants = JSNameSuggestionsUtil.generateOrdinalVariants(results, intValue);
            results.add(JSNameSuggestionsUtil.generateOrdinal(intValue));
            results.addAll(ordinalVariants);
        }
        return new ArrayList<String>(results);
    }

    @Contract(value="null -> null")
    @Nullable
    private static String normalizeTypeName(@Nullable String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.endsWith(IMPL_SUFFIX) && typeName.length() > IMPL_SUFFIX.length()) {
            return typeName.substring(0, typeName.length() - IMPL_SUFFIX.length());
        }
        return typeName;
    }

    @NotNull
    public static String getDefaultVariableNameFromEntityKind(@Nullable PsiElement context2) {
        return JSNameSuggestionsUtil.getDefaultVariableNameForEntityKind(JSNameSuggestionsUtil.getEntityKind(context2));
    }

    @NotNull
    private static String getDefaultVariableNameForEntityKind(@NotNull JSNamedEntityKind entityKind) {
        if (entityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(19);
        }
        return switch (entityKind) {
            default -> throw new IncompatibleClassChangeError();
            case JSNamedEntityKind.Parameter -> "p";
            case JSNamedEntityKind.Field -> "field";
            case JSNamedEntityKind.Function -> "f";
            case JSNamedEntityKind.Variable, JSNamedEntityKind.Accessor -> "x";
            case JSNamedEntityKind.Class -> "Class";
            case JSNamedEntityKind.Interface -> "Interface";
            case JSNamedEntityKind.Enum -> "Enum";
        };
    }

    @NotNull
    public static List<String> generateVariableNamesFromType(@NotNull JSType type, @NotNull PsiElement scope2, @NotNull Collection<String> existing) {
        String fromType;
        if (type == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(20);
        }
        if (scope2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(21);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(22);
        }
        if ((fromType = JSNameSuggestionsUtil.normalizeTypeName(JSNameSuggestionsUtil.generateNameFromJSTypeOrNull(type, scope2))) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(23);
            }
            return list;
        }
        List list = ContainerUtil.map(JSNameSuggestionsUtil.generateNamesFromQualifiedName(fromType, false), nameCandidate -> JSNameSuggestionsUtil.ensureUniqueVariableName(nameCandidate, scope2, existing, false));
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public static List<String> generateTypeNamesFromType(@Nullable JSType jsType, @NotNull PsiElement scope2) {
        PsiElement element;
        if (scope2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(25);
        }
        if (jsType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(26);
            }
            return list;
        }
        String forComplexType = JSNameSuggestionsUtil.getNameForComplexType(jsType, scope2);
        if (forComplexType != null) {
            HashSet existing = new HashSet();
            List<String> names = JSNameSuggestionsUtil.generateNamesFromQualifiedName(forComplexType, false);
            if (!names.isEmpty()) {
                List list = ContainerUtil.map(names, s -> JSNameSuggestionsUtil.ensureUniqueVariableName(StringUtil.capitalize((String)s), scope2, existing, false));
                if (list == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(27);
                }
                return list;
            }
        }
        if ((element = jsType.getSourceElement()) != null) {
            JSFunction function;
            JSParameterListElement[] parameters;
            JSParameterList parameterList;
            PsiElement parent = element.getParent();
            if (parent instanceof JSParameter && (parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)parent, JSParameterList.class)) != null && (parameters = parameterList.getParameters()).length >= 1 && PsiTreeUtil.isAncestor((PsiElement)parameters[0], (PsiElement)element, (boolean)false) && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class)) != null && function.getName() != null) {
                String name = JSNameSuggestionsUtil.guessParameterNameByFunctionName(function.getName());
                List<String> list = Collections.singletonList(JSNameSuggestionsUtil.ensureUniqueVariableName(StringUtil.capitalize((String)name), scope2, new HashSet<String>(), false));
                if (list == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(28);
                }
                return list;
            }
            if (parent instanceof JSNamedElement && ((JSNamedElement)parent).getName() != null) {
                String name = ((JSNamedElement)parent).getName();
                assert (name != null);
                List<String> list = Collections.singletonList(JSNameSuggestionsUtil.ensureUniqueVariableName(StringUtil.capitalize((String)name), scope2, new HashSet<String>(), false));
                if (list == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(29);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public static String guessParameterNameByFunctionName(@NotNull String name) {
        if (name == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(31);
        }
        for (String prefix : COMMON_METHOD_PREFIXES) {
            if (name.length() <= prefix.length() || !StringUtil.startsWithIgnoreCase((String)name, (String)prefix)) continue;
            String string = name.substring(prefix.length());
            if (string == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = name + "Params";
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static String generateDefaultName(@Nullable PsiElement element) {
        String nameFromContext = (String)ContainerUtil.getFirstItem(JSNameSuggestionsUtil.generateDefaultNamesFromContext(element));
        return nameFromContext != null ? nameFromContext : JSNameSuggestionsUtil.getDefaultVariableNameFromEntityKind(element);
    }

    @NotNull
    private static Collection<String> generateDefaultNames(@Nullable PsiElement element) {
        ArrayList<String> nameFromContext = new ArrayList<String>(JSNameSuggestionsUtil.generateDefaultNamesFromContext(element));
        nameFromContext.add(JSNameSuggestionsUtil.getDefaultVariableNameFromEntityKind(element));
        ArrayList<String> arrayList = nameFromContext;
        if (arrayList == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private static String evaluateCollectionItemName(@Nullable JSExpression collectionExpression, boolean forIn) {
        String item;
        if (collectionExpression == null) {
            return null;
        }
        List<String> names = JSNameSuggestionsUtil.generateVariableNamesFromExpression(collectionExpression, null, "", new ArrayList<String>(), JSNamedEntityKind.Variable, true);
        if (!forIn) {
            for (String name : names) {
                String unpluralize = StringUtil.unpluralize((String)name);
                if (unpluralize == null) continue;
                if ("int".equals(unpluralize) || "uint".equals(unpluralize)) {
                    return "i";
                }
                return unpluralize;
            }
        }
        if ((item = (String)ContainerUtil.getFirstItem(names)) != null) {
            return item + (forIn ? KEY_SUFFIX : ELEMENT_SUFFIX);
        }
        return null;
    }

    @NotNull
    private static Collection<String> generateDefaultNamesFromContext(@Nullable PsiElement element) {
        String elementName;
        JSType type;
        PsiElement parent;
        JSExpression initializer;
        if (element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(35);
            }
            return list;
        }
        SmartList variants = new SmartList();
        if (element instanceof JSVariable && (initializer = ((JSVariable)element).getInitializer()) != null) {
            variants.addAll(JSNameSuggestionsUtil.generateVariableNamesFromExpression(initializer, null, "", Collections.emptyList(), JSNamedEntityKind.Variable, true));
        }
        if ((parent = element.getParent()) instanceof JSForStatement) {
            PsiElement lastChild;
            if (element.getNextSibling() instanceof PsiErrorElement && (lastChild = parent.getLastChild()) instanceof JSExpressionStatement) {
                ContainerUtil.addIfNotNull((Collection)variants, (Object)JSNameSuggestionsUtil.evaluateCollectionItemName(((JSExpressionStatement)lastChild).getExpression(), false));
            }
        } else if (parent instanceof JSVarStatement) {
            PsiElement forLoop = parent.getParent();
            if (forLoop instanceof JSForInStatement) {
                ContainerUtil.addIfNotNull((Collection)variants, (Object)JSNameSuggestionsUtil.evaluateCollectionItemName(((JSForInStatement)forLoop).getCollectionExpression(), !((JSForInStatement)forLoop).isForEach()));
            } else if (forLoop instanceof JSForStatement) {
                variants.addAll(FOR_LOOP_VARS);
            }
        }
        if (element instanceof JSVariable && (type = ((JSVariable)element).getJSType()) != null) {
            List<String> names = JSNameSuggestionsUtil.generateVariableNamesFromType(type, element, ContainerUtil.emptyList());
            variants.addAll(names);
        }
        if (element instanceof JSClass && parent instanceof JSFile && ((JSFile)parent).getStatements().length == 1 && (elementName = JSNameSuggestionsUtil.fileNameToElementName((PsiNamedElement)((JSClass)element), (JSFile)parent)) != null) {
            variants.add(StringUtil.capitalize((String)elementName));
        }
        if (parent instanceof JSDestructuringArray) {
            JSExpression initializer2;
            String itemName;
            PsiElement parentParent = parent.getParent();
            if (parentParent instanceof JSDestructuringElement && (itemName = JSNameSuggestionsUtil.evaluateCollectionItemName(initializer2 = ((JSDestructuringElement)parentParent).getInitializer(), false)) != null) {
                variants.add(itemName);
            }
            JSInitializerOwner[] elements = ((JSDestructuringArray)parent).getElements();
            for (int i = 0; i < elements.length; ++i) {
                JSInitializerOwner elem = elements[i];
                if (elem != element) continue;
                List<String> ordinalVariants = JSNameSuggestionsUtil.generateOrdinalVariants((Collection<String>)variants, i);
                variants.add(JSNameSuggestionsUtil.generateOrdinal(i));
                variants.addAll(ordinalVariants);
                break;
            }
        }
        SmartList smartList = variants;
        if (smartList == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(36);
        }
        return smartList;
    }

    @NotNull
    private static List<String> generateOrdinalVariants(Collection<String> variants, int index) {
        List list = ContainerUtil.map(variants, v -> JSNameSuggestionsUtil.generateOrdinal(index, v));
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    public static String generateUniqueVariableNameAtPlace(@Nullable PsiElement place) {
        PsiElement context2 = JSNameSuggestionsUtil.evaluateProperContext(place);
        return JSNameSuggestionsUtil.ensureUniqueVariableName(JSNameSuggestionsUtil.generateDefaultName(context2), place, new HashSet<String>(), false);
    }

    @NotNull
    public static List<String> generateVariableNamesAtPlace(@Nullable PsiElement place) {
        PsiElement context2 = JSNameSuggestionsUtil.evaluateProperContext(place);
        HashSet names = new HashSet();
        SequencedCollection<String> defaultNames = new LinkedHashSet<String>(JSNameSuggestionsUtil.generateDefaultNames(context2));
        String defaultName = JSNameSuggestionsUtil.getDefaultVariableNameFromEntityKind(context2);
        if (defaultNames.size() > 1) {
            defaultNames = ContainerUtil.filter(defaultNames, n -> !defaultName.equals(n));
        }
        List list = ContainerUtil.map(defaultNames, n -> JSNameSuggestionsUtil.ensureUniqueVariableName(n, place, names, false));
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    public static Collection<String> generateVariableNamesAtPlace(@Nullable PsiElement place, @NotNull Set<String> existingNames) {
        if (existingNames == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(39);
        }
        PsiElement context2 = JSNameSuggestionsUtil.evaluateProperContext(place);
        List list = ContainerUtil.map(JSNameSuggestionsUtil.generateDefaultNamesFromContext(context2), n -> JSNameSuggestionsUtil.ensureUniqueVariableName(n, place, existingNames, false));
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    public static boolean isSmartNameAvailable(@Nullable PsiElement place) {
        PsiElement context2 = JSNameSuggestionsUtil.evaluateProperContext(place);
        return !JSNameSuggestionsUtil.generateDefaultNamesFromContext(context2).isEmpty();
    }

    @NotNull
    public static String ensureUniqueVariableName(@NotNull String originalString, @Nullable PsiElement scope2, @NotNull Collection<String> existing, boolean skipSearchInScope) {
        if (originalString == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(41);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(42);
        }
        return JSNameSuggestionsUtil.ensureUniqueVariableName(originalString, scope2, existing, skipSearchInScope, null);
    }

    @NotNull
    public static String ensureUniqueVariableName(@NotNull String originalString, @Nullable PsiElement scope2, @NotNull Collection<String> existing, boolean skipSearchInScope, @Nullable PsiElement scopeToSkip) {
        if (originalString == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(43);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(44);
        }
        Object currentVariant = originalString;
        if ((skipSearchInScope || scope2 != null) && StringUtil.isJavaIdentifier((String)originalString)) {
            int maxAttempts = 100;
            int cnt = 0;
            String originalStringWithoutTrailingNumbers = null;
            while (existing.contains(currentVariant) || !skipSearchInScope && !((String)currentVariant).equals(scope2.getText()) && cnt < maxAttempts && (JSNameSuggestionsUtil.findExistingInScopeAndUp((String)currentVariant, scope2, scopeToSkip) != null || !JSNameSuggestionsUtil.isIdentifier((String)currentVariant, scope2))) {
                ++cnt;
                if (originalStringWithoutTrailingNumbers == null) {
                    int i;
                    originalStringWithoutTrailingNumbers = originalString;
                    int startedPos = i = originalStringWithoutTrailingNumbers.length() - 1;
                    while (i >= 0 && Character.isDigit(originalStringWithoutTrailingNumbers.charAt(i))) {
                        --i;
                    }
                    if (i >= 0 && startedPos != i) {
                        originalStringWithoutTrailingNumbers = originalStringWithoutTrailingNumbers.substring(0, i + 1);
                        currentVariant = originalStringWithoutTrailingNumbers;
                        --cnt;
                        continue;
                    }
                }
                currentVariant = originalStringWithoutTrailingNumbers + cnt;
            }
            if (cnt >= maxAttempts) {
                LOG.warn(String.format("Could not generate a unique name after %s attempts. Returning '%s'", maxAttempts, currentVariant));
            }
        }
        String string = currentVariant;
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    private static void processCandidates(@NotNull JSExpression mainOccurrence, @NotNull Processor<? super String> processor, @NotNull JSNamedEntityKind entityKind, boolean avoidItemsFromTypes) {
        XmlAttribute attribute;
        JSExpression arrayExpr;
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(46);
        }
        if (processor == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(47);
        }
        if (entityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(48);
        }
        if (mainOccurrence instanceof JSParenthesizedExpression) {
            JSExpression expression = ((JSParenthesizedExpression)mainOccurrence).getInnerExpression();
            if (expression != null) {
                JSNameSuggestionsUtil.processCandidates(expression, processor, entityKind, avoidItemsFromTypes);
            }
            return;
        }
        if (mainOccurrence instanceof TypeScriptCastExpression) {
            JSExpression expression = ((TypeScriptCastExpression)mainOccurrence).getExpression();
            if (expression != null) {
                JSNameSuggestionsUtil.processCandidates(expression, processor, entityKind, avoidItemsFromTypes);
            }
            return;
        }
        HashSet reported = new HashSet();
        String someDefaultName = null;
        boolean typeHasHigherPriorityThanName = entityKind == JSNamedEntityKind.Parameter;
        JSType expressionType = JSResolveUtil.getExpressionJSType(mainOccurrence);
        if (mainOccurrence instanceof JSXmlLiteralExpression) {
            someDefaultName = mainOccurrence.getName();
        }
        if (mainOccurrence instanceof JSCallLikeExpression) {
            JSCallLikeExpression callExpression = (JSCallLikeExpression)mainOccurrence;
            typeHasHigherPriorityThanName = expressionType != null && !JSTypeUtils.isIndexableType(expressionType);
            someDefaultName = JSNameSuggestionsUtil.suggestNameForCallLike(callExpression.getMethodExpression(), callExpression.getArguments(), callExpression instanceof JSNewExpression, processor, reported);
        } else if (mainOccurrence instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)mainOccurrence;
            someDefaultName = JSNameSuggestionsUtil.trimPrefix(refExpr, JSNameSuggestionsUtil.getLastMeaningfulName(refExpr));
            if (refExpr.getParent() instanceof JSExpressionStatement) {
                JSNameSuggestionsUtil.addName(someDefaultName, processor, reported);
                someDefaultName = null;
            }
        } else if (mainOccurrence instanceof JSFunctionExpression) {
            PsiElement ownNameId = ((JSFunctionExpression)mainOccurrence).getOwnNameIdentifier();
            if (ownNameId != null) {
                someDefaultName = ownNameId.getText();
            }
        } else if (mainOccurrence instanceof JSIndexedPropertyAccessExpression && (arrayExpr = ((JSIndexedPropertyAccessExpression)mainOccurrence).getQualifier()) != null) {
            for (String name : JSNameSuggestionsUtil.generateVariableNamesFromExpression(arrayExpr, null, "", new ArrayList<String>(), JSNamedEntityKind.Variable, avoidItemsFromTypes)) {
                Object unpluralize = StringUtil.unpluralize((String)name);
                if (unpluralize == null) {
                    unpluralize = name + ELEMENT_SUFFIX;
                }
                JSNameSuggestionsUtil.addName((String)unpluralize, processor, reported);
            }
        }
        PsiElement parent = mainOccurrence.getParent();
        if (parent instanceof JSArgumentList && entityKind != JSNamedEntityKind.Parameter) {
            JSResolveUtil.processParametersForUsedArgument(mainOccurrence, (JSArgumentList)parent, (Processor<? super JSParameterItem>)((Processor)jsParameter -> {
                JSNameSuggestionsUtil.addName(jsParameter.getName(), processor, reported);
                return true;
            }));
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression expression;
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) {
                String name;
                JSParameterItem parameter;
                JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
                PsiElement resolve2 = referenceExpression.resolve();
                if (resolve2 instanceof JSFunction && (parameter = JSResolveUtil.getParameterFromSetAccessor((JSFunction)resolve2)) != null && !"value".equals(name = parameter.getName())) {
                    JSNameSuggestionsUtil.addName(name, processor, reported);
                }
                String referencedName = referenceExpression.getReferenceName();
                JSNameSuggestionsUtil.addName(referencedName, processor, reported);
            }
            if (lOperand != null && mainOccurrence == ((JSAssignmentExpression)parent).getROperand()) {
                for (String name : JSNameSuggestionsUtil.generateVariableNamesFromExpression(lOperand, null, "", new ArrayList<String>(), JSNamedEntityKind.Variable, avoidItemsFromTypes)) {
                    JSNameSuggestionsUtil.addName(name, processor, reported);
                }
            }
        } else if (parent instanceof JSProperty) {
            String name = ((JSProperty)parent).getName();
            if (JSNameSuggestionsUtil.isIdentifier(name, (PsiElement)mainOccurrence)) {
                JSNameSuggestionsUtil.addName(name, processor, reported);
            }
        } else if (JSPsiImplUtils.isEmbeddedExpressionContent(parent) && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)parent, XmlAttribute.class, (boolean)false, (Class[])new Class[]{JSSourceElement.class})) != null) {
            JSNameSuggestionsUtil.addName(attribute.getName(), processor, reported);
        }
        if (parent instanceof JSInitializerOwner && parent instanceof JSNamedElement && JSNameSuggestionsUtil.getEntityKind(parent) != entityKind) {
            JSNameSuggestionsUtil.addName(((JSNamedElement)parent).getName(), processor, reported);
        }
        if (!avoidItemsFromTypes && expressionType != null && JSTypeUtils.isIndexableType(expressionType)) {
            typeHasHigherPriorityThanName = true;
        }
        String typeString = JSNameSuggestionsUtil.normalizeTypeName(JSNameSuggestionsUtil.generateNameFromJSTypeOrNull(expressionType, (PsiElement)mainOccurrence));
        if (typeHasHigherPriorityThanName) {
            JSNameSuggestionsUtil.addName(typeString, processor, reported);
            JSNameSuggestionsUtil.addName(someDefaultName, processor, reported);
        } else {
            JSNameSuggestionsUtil.addName(someDefaultName, processor, reported);
            JSNameSuggestionsUtil.addName(typeString, processor, reported);
        }
    }

    @Nullable
    private static String suggestNameForCallLike(@Nullable JSExpression methodExpression, JSExpression @NotNull [] arguments, boolean isNewExpression, @NotNull Processor<? super String> processor, @NotNull Set<? super String> reported) {
        if (processor == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(49);
        }
        if (reported == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(50);
        }
        if (arguments == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(51);
        }
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return null;
        }
        String referencedName = JSNameSuggestionsUtil.getLastMeaningfulName((JSReferenceExpression)methodExpression);
        if (isNewExpression) {
            JSReferenceExpression typeReference;
            ASTNode node = methodExpression.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
            if (node != null && (typeReference = ((JSGenericSignature)node.getPsi()).getTypeReference()) != null) {
                String typeText = typeReference.getText();
                JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(typeText);
                referencedName = StringUtil.pluralize((String)(signature == null ? typeText : signature.elementType));
            }
            JSNameSuggestionsUtil.addName(referencedName, processor, reported);
        } else {
            String propertyName;
            String string = propertyName = referencedName != null ? JSDocumentationUtils.getPropertyName(referencedName) : null;
            if (propertyName != null) {
                JSNameSuggestionsUtil.addName(propertyName, processor, reported);
            } else {
                if ("$".equals(referencedName) || "get".equals(referencedName) || "set".equals(referencedName) || "require".equals(referencedName)) {
                    String value;
                    if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression && (value = ((JSLiteralExpression)arguments[0]).getStringValue()) != null) {
                        int index;
                        int start = 0;
                        if (value.length() > 0 && !Character.isJavaIdentifierStart(value.charAt(0))) {
                            ++start;
                        }
                        for (index = start; index < value.length() && Character.isJavaIdentifierPart(value.charAt(index)); ++index) {
                        }
                        if (index > start) {
                            Object name = value.substring(start, index);
                            if ("$".equals(referencedName)) {
                                name = "$" + (String)name;
                            }
                            JSNameSuggestionsUtil.addName((String)name, processor, reported);
                        }
                    }
                    return referencedName;
                }
                return referencedName;
            }
        }
        return null;
    }

    private static void addName(@Nullable String name, @NotNull Processor<? super String> processor, @NotNull Set<? super String> reported) {
        if (processor == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(52);
        }
        if (reported == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(53);
        }
        if (name != null && reported.add(name)) {
            processor.process((Object)name);
        }
    }

    @NotNull
    public static JSNamedEntityKind getEntityKind(@Nullable PsiElement context2) {
        if (context2 instanceof JSField) {
            JSNamedEntityKind jSNamedEntityKind = JSNamedEntityKind.Field;
            if (jSNamedEntityKind == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(54);
            }
            return jSNamedEntityKind;
        }
        if (context2 instanceof TypeScriptEnum) {
            JSNamedEntityKind jSNamedEntityKind = JSNamedEntityKind.Enum;
            if (jSNamedEntityKind == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(55);
            }
            return jSNamedEntityKind;
        }
        if (context2 instanceof JSClass) {
            JSNamedEntityKind jSNamedEntityKind = ((JSClass)context2).isInterface() ? JSNamedEntityKind.Interface : JSNamedEntityKind.Class;
            if (jSNamedEntityKind == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(56);
            }
            return jSNamedEntityKind;
        }
        if (context2 instanceof JSFunction) {
            JSNamedEntityKind jSNamedEntityKind = JSNamedEntityKind.Function;
            if (jSNamedEntityKind == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(57);
            }
            return jSNamedEntityKind;
        }
        JSNamedEntityKind jSNamedEntityKind = JSNamedEntityKind.Variable;
        if (jSNamedEntityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(58);
        }
        return jSNamedEntityKind;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private static PsiElement evaluateProperContext(@Nullable PsiElement place) {
        PsiElement context2 = place;
        if (context2 instanceof PsiWhiteSpace) {
            context2 = context2.getParent();
        }
        if (context2 instanceof LeafPsiElement) {
            context2 = context2.getParent();
        }
        if (context2 instanceof JSReferenceExpression) {
            context2 = context2.getParent();
        }
        return context2;
    }

    @NotNull
    private static String sanitizeJavaScriptIdentifier(@NotNull String name) {
        if (name == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(59);
        }
        StringBuilder result2 = new StringBuilder();
        boolean capitalize = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '$') {
                if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch) && ch != '$') {
                    result2.append("_");
                }
                result2.append(capitalize ? Character.toUpperCase(ch) : ch);
                capitalize = false;
                continue;
            }
            capitalize = true;
        }
        String string = result2.toString();
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(60);
        }
        return string;
    }

    @Nullable
    private static String getLastMeaningfulName(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(61);
        }
        while (referenceExpression != null) {
            String name = referenceExpression.getReferenceName();
            JSExpression qualifier = referenceExpression.getQualifier();
            if (!"bind".equals(name) || qualifier == null) {
                return name;
            }
            referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)qualifier, JSReferenceExpression.class);
        }
        return null;
    }

    @NotNull
    private static List<String> generateNamesFromQualifiedName(@NotNull String s, boolean removePlural) {
        String singular;
        if (s == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(62);
        }
        ArrayList<String> results = new ArrayList<String>();
        s = QualifiedName.fromDottedString((String)s).getLastComponent();
        assert (s != null);
        s = JSNameSuggestionsUtil.sanitizeJavaScriptIdentifier(s);
        if (removePlural && (singular = StringUtil.unpluralize((String)s)) != null) {
            s = singular;
        }
        for (String namePart : NameUtil.nameToWords((String)s)) {
            String name;
            if ("get".equals(namePart) || "set".equals(namePart) || "is".equals(namePart) || "create".equals(namePart) || !StringUtil.isJavaIdentifier((String)(name = StringUtil.toLowerCase((String)namePart) + s.substring(s.indexOf(namePart) + namePart.length())))) continue;
            results.add(name);
        }
        ArrayList<String> arrayList = results;
        if (arrayList == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    @Nullable
    public static JSNamedElement findExistingInScopeAndUp(final @NotNull String name, final @NotNull PsiElement scope2, final @Nullable PsiElement scopeToSkip) {
        JSNamedElement element;
        if (name == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(64);
        }
        if (scope2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(65);
        }
        final Ref existing = new Ref();
        final Ref existingRef = new Ref();
        scope2.accept((PsiElementVisitor)new JSElementVisitor(){

            @Override
            public void visitJSFile(@NotNull JSFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (existing.isNull()) {
                    file.acceptChildren(this);
                }
            }

            @Override
            public void visitJSEmbeddedContent(@NotNull JSEmbeddedContent embeddedContent) {
                if (embeddedContent == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (existing.isNull()) {
                    embeddedContent.acceptChildren(this);
                }
            }

            @Override
            public void visitJSElement(@NotNull JSElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (existing.isNull()) {
                    node.acceptChildren(this);
                }
            }

            @Override
            public void visitJSClass(@NotNull JSClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (name.equals(aClass.getName())) {
                    this.setExistingIfNotSkipped(aClass, existing);
                }
            }

            @Override
            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (name.equals(node.getName())) {
                    this.setExistingIfNotSkipped(node, existing);
                }
                super.visitJSVariable(node);
            }

            private <T extends JSElement> void setExistingIfNotSkipped(T node, Ref<T> existingRef2) {
                if (scopeToSkip == null || !PsiTreeUtil.isAncestor((PsiElement)scopeToSkip, node, (boolean)true)) {
                    existingRef2.set(node);
                }
            }

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (JSResolveUtil.isExprInStrictTypeContext(node)) {
                    return;
                }
                if (name.equals(node.getReferenceName()) && node.getQualifier() == null) {
                    this.setExistingIfNotSkipped(node, existingRef);
                }
                super.visitJSReferenceExpression(node);
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (name.equals(node.getName())) {
                    this.setExistingIfNotSkipped(node, existing);
                }
                if (node == scope2) {
                    super.visitJSFunctionDeclaration(node);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "embeddedContent";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/names/JSNameSuggestionsUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSEmbeddedContent";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSClass";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (existing.isNull()) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(name, new ResolveResultSink(null, name));
            JSResolveUtil.treeWalkUp(processor, scope2, null, scope2);
            PsiElement resolved = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(processor.getResultsAsResolveResults()));
            if (resolved instanceof JSNamedElement && !(resolved instanceof JSClass) && StringUtil.equals((CharSequence)name, (CharSequence)((JSNamedElement)resolved).getName()) && !PsiTreeUtil.isAncestor((PsiElement)scopeToSkip, (PsiElement)resolved, (boolean)true) && !JSNameSuggestionsUtil.skipElement(resolved)) {
                existing.set((Object)((JSNamedElement)resolved));
            }
            if (existing.isNull() && !existingRef.isNull()) {
                existing.set((Object)new ImplicitJSVariableImpl(name, (JSType)null, scope2));
            }
        }
        return (element = (JSNamedElement)existing.get()) == scope2 ? null : element;
    }

    private static boolean skipElement(PsiElement resolved) {
        JSVariable variable = (JSVariable)ObjectUtils.tryCast((Object)resolved, JSVariable.class);
        if (variable == null) {
            return false;
        }
        if (!"name".equals(variable.getName())) {
            return false;
        }
        PsiElement scope2 = variable.getDeclarationScope();
        return scope2 instanceof JSFile && TypeScriptUtil.isDefinitionFile((PsiFile)scope2);
    }

    public static boolean matchesFileNameByCodeStyle(@NotNull JSNamedElement namedElement) {
        String elementName;
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(66);
        }
        if ((elementName = namedElement.getName()) == null) {
            return true;
        }
        PsiFile file = namedElement.getContainingFile();
        if (file == null) {
            return true;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)file);
        JSCodeStyleSettings.JSFileNameStyle fileNameStyle = codeStyleSettings.FILE_NAME_STYLE;
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.RELAXED) {
            return JSNameSuggestionsUtil.matchesFileNameRelaxed(elementName, virtualFile);
        }
        String suggestedName = JSNameSuggestionsUtil.suggestFileNameWithoutExtension(elementName, file);
        return suggestedName != null && suggestedName.equals(virtualFile.getNameWithoutExtension());
    }

    public static boolean matchesFileNameRelaxed(@NotNull JSNamedElement namedElement) {
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(67);
        }
        String elementName = namedElement.getName();
        PsiFile file = namedElement.getContainingFile();
        if (file == null) {
            return true;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        return JSNameSuggestionsUtil.matchesFileNameRelaxed(elementName, virtualFile);
    }

    private static boolean matchesFileNameRelaxed(String elementName, VirtualFile virtualFile) {
        String fileName = virtualFile.getNameWithoutExtension();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (i == 0 && !StringUtil.isJavaIdentifierStart((char)c) || i != 0 && !StringUtil.isJavaIdentifierPart((char)c)) continue;
            b.append(c);
        }
        return b.toString().equalsIgnoreCase(elementName);
    }

    @Nullable
    public static String fileNameFromElementName(@NotNull JSNamedElement existingElement, @NotNull String newElementName) {
        JSNamesSuggester[] namesSuggesters;
        PsiFile file;
        if (existingElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(68);
        }
        if (newElementName == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(69);
        }
        if ((file = existingElement.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String fileExtension = virtualFile.getExtension();
        if (fileExtension == null) {
            return null;
        }
        for (JSNamesSuggester suggester : namesSuggesters = (JSNamesSuggester[])JSNamesSuggester.EP_NAME.getExtensions()) {
            String fileName = suggester.suggestFileName(existingElement, newElementName);
            if (fileName == null) continue;
            return fileName;
        }
        return JSNameSuggestionsUtil.suggestFileNameWithoutExtension(newElementName, file);
    }

    @Nullable
    private static String suggestFileNameWithoutExtension(@NotNull String newElementName, @NotNull PsiFile file) {
        boolean isMixed;
        if (newElementName == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(70);
        }
        if (file == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(71);
        }
        JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)file);
        JSCodeStyleSettings.JSFileNameStyle fileNameStyle = codeStyleSettings.FILE_NAME_STYLE;
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.RELAXED) {
            fileNameStyle = JSNameSuggestionsUtil.tryDetectNamingStyle(file);
        }
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.CAMEL_CASE) {
            return JSNameSuggestionsUtil.validateFileName(StringUtil.decapitalize((String)newElementName));
        }
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.PASCAL_CASE) {
            return JSNameSuggestionsUtil.validateFileName(StringUtil.capitalize((String)newElementName));
        }
        boolean isSnake = fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.SNAKE_CASE;
        boolean isLisp = fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.LISP_CASE;
        boolean bl = isMixed = fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.MIXED;
        if (isSnake || isLisp || isMixed) {
            Object[] parts = newElementName.split(SPLIT_BY_CAMEL_CASE_REGEX);
            if (isSnake || isLisp) {
                return JSNameSuggestionsUtil.validateFileName(StringUtil.join((Object[])parts, StringUtil::toLowerCase, (String)(isSnake ? "_" : "-")));
            }
            if (parts.length == 1) {
                return JSNameSuggestionsUtil.validateFileName(StringUtil.toLowerCase((String)parts[0]));
            }
            Object[] allPartsSaveTheLast = (String[])Arrays.copyOf(parts, parts.length - 1);
            return JSNameSuggestionsUtil.validateFileName(StringUtil.join((Object[])allPartsSaveTheLast, StringUtil::toLowerCase, (String)"-") + "." + StringUtil.toLowerCase((String)parts[parts.length - 1]));
        }
        return JSNameSuggestionsUtil.validateFileName(JSNameSuggestionsUtil.capitalizeByConvention((PsiNamedElement)file, newElementName));
    }

    @Contract(value="null -> null")
    @Nullable
    private static String validateFileName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return PathUtil.isValidFileName((String)name) ? name : null;
    }

    @NotNull
    private static JSCodeStyleSettings.JSFileNameStyle tryDetectNamingStyle(@NotNull PsiFile file) {
        String name;
        if (file == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(72);
        }
        if (StringUtil.isCapitalized((String)(name = file.getName()))) {
            JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.PASCAL_CASE;
            if (jSFileNameStyle == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(73);
            }
            return jSFileNameStyle;
        }
        int underscore = name.indexOf(95);
        if (underscore > 0) {
            int lastUnderscore = name.lastIndexOf(95);
            if (underscore != lastUnderscore) {
                JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.SNAKE_CASE;
                if (jSFileNameStyle == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(74);
                }
                return jSFileNameStyle;
            }
            String lastPart = name.substring(lastUnderscore + 1);
            int ext = lastPart.lastIndexOf(46);
            if (ext >= 0) {
                lastPart = lastPart.substring(0, ext);
            }
            for (int i = 0; i < lastPart.length(); ++i) {
                char c = lastPart.charAt(i);
                if (Character.isDigit(c)) continue;
                JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.SNAKE_CASE;
                if (jSFileNameStyle == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(75);
                }
                return jSFileNameStyle;
            }
            JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.CAMEL_CASE;
            if (jSFileNameStyle == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(76);
            }
            return jSFileNameStyle;
        }
        if (name.indexOf(45) > 0) {
            int lastDot = name.lastIndexOf(46);
            if (name.substring(0, lastDot - 1).indexOf(46) > 0) {
                JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.MIXED;
                if (jSFileNameStyle == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(77);
                }
                return jSFileNameStyle;
            }
            JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.LISP_CASE;
            if (jSFileNameStyle == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(78);
            }
            return jSFileNameStyle;
        }
        JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.RELAXED;
        if (jSFileNameStyle == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(79);
        }
        return jSFileNameStyle;
    }

    @Nullable
    public static String fileNameToElementName(@NotNull PsiNamedElement namedElement, @NotNull String newFileName) {
        String capitalizedAsIs;
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(80);
        }
        if (newFileName == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(81);
        }
        return (capitalizedAsIs = JSNameSuggestionsUtil.fileNameToElementName((PsiElement)namedElement, null, newFileName)) != null ? JSNameSuggestionsUtil.capitalizeByConvention(namedElement, capitalizedAsIs) : null;
    }

    @Nullable
    public static String fileNameToElementName(@NotNull PsiNamedElement namedElement, @NotNull PsiFile file) {
        String capitalizedAsIs;
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(82);
        }
        if (file == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(83);
        }
        return (capitalizedAsIs = JSNameSuggestionsUtil.fileNameToElementName((PsiElement)namedElement, file.getVirtualFile(), null)) != null ? JSNameSuggestionsUtil.capitalizeByConvention(namedElement, capitalizedAsIs) : null;
    }

    @Nullable
    public static String fileNameToElementNameCapitalizeAsIs(@NotNull PsiElement context2, @NotNull VirtualFile file) {
        if (context2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(84);
        }
        if (file == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(85);
        }
        return JSNameSuggestionsUtil.fileNameToElementName(context2, file, null);
    }

    @Contract(value="_, null, null -> fail; _, !null, !null -> fail")
    @Nullable
    private static String fileNameToElementName(@NotNull PsiElement context2, @Nullable VirtualFile file, @Nullable String newFileName) {
        VirtualFile directory;
        String fileName;
        if (context2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(86);
        }
        String regex = "\\W+";
        JSCodeStyleSettings.JSFileNameStyle fileNameStyle = JSCodeStyleSettings.getSettings((PsiElement)context2.getContainingFile()).FILE_NAME_STYLE;
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.SNAKE_CASE) {
            regex = "[\\W_]+";
        }
        if (file == null && newFileName == null) {
            throw new IllegalArgumentException();
        }
        if (file != null) {
            newFileName = file.getName();
        }
        if ("index".equals(fileName = JSFileReferencesUtil.getFileNameWithoutExtension(newFileName, JSFileReferencesUtil.IMPLICIT_EXTENSIONS)) && file != null && (directory = file.getParent()) != null) {
            fileName = directory.getName();
        }
        List words = ContainerUtil.map((Object[])fileName.split(regex), StringUtil::capitalize);
        String capitalizedAsIs = StringUtil.join((Collection)words, (String)"");
        return LanguageNamesValidation.isIdentifier((Language)context2.getLanguage(), (String)capitalizedAsIs, (Project)context2.getProject()) ? capitalizedAsIs : null;
    }

    public static boolean isCapitalizedOnly(@NotNull PsiElement namedElement) {
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(87);
        }
        return namedElement instanceof JSClass;
    }

    public static String capitalizeByConvention(@NotNull PsiNamedElement namedElement, @NotNull String newName) {
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(88);
        }
        if (newName == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(89);
        }
        return StringUtil.isCapitalized((String)namedElement.getName()) ? StringUtil.capitalize((String)newName) : StringUtil.decapitalize((String)newName);
    }

    public static String trimPrefix(@NotNull JSReferenceExpression expression, String name) {
        PsiElement resolved;
        if (expression == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(90);
        }
        if ((resolved = expression.resolve()) instanceof JSVariable && JSUtils.getMemberContainingClass(resolved) != null) {
            JSCodeStyleSettings jsCodeStyleSettings = JSCodeStyleSettings.getSettings(resolved);
            return StringUtil.trimStart((String)name, (String)jsCodeStyleSettings.FIELD_PREFIX);
        }
        if (resolved instanceof JSFunction && JSPsiImplUtils.isGetterOrSetter((JSFunction)resolved)) {
            JSCodeStyleSettings jsCodeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)expression);
            return StringUtil.trimStart((String)name, (String)jsCodeStyleSettings.PROPERTY_PREFIX);
        }
        return name;
    }

    @NotNull
    public static String generateOrdinal(int index) {
        assert (index >= 0) : "should pass a valid index but got " + index;
        String string = NumericNameGenerator.generateOrdinal(index);
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(91);
        }
        return string;
    }

    private static String generateOrdinal(int index, String forWhom) {
        if (index + 1 < 100) {
            return NumericNameGenerator.generateOrdinal(index) + StringUtil.capitalize((String)forWhom);
        }
        return forWhom + (index + 1);
    }

    @NotNull
    public static String generateCardinal(int index) {
        assert (index >= 0) : "should pass a valid index but got " + index;
        String string = NumericNameGenerator.generateCardinal(index);
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(92);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 23, 24, 26, 27, 28, 29, 30, 32, 33, 34, 35, 36, 37, 38, 40, 45, 54, 55, 56, 57, 58, 60, 63, 73, 74, 75, 76, 77, 78, 79, 91, 92 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainOccurrence";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 22: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityKind";
                break;
            }
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 63: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/names/JSNameSuggestionsUtil";
                break;
            }
            case 21: 
            case 25: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 31: 
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalString";
                break;
            }
            case 47: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reported";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 66: 
            case 67: 
            case 80: 
            case 82: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingElement";
                break;
            }
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 71: 
            case 72: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/names/JSNameSuggestionsUtil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVariableNamesFromExpression";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVariableNamesFromType";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTypeNamesFromType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "guessParameterNameByFunctionName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefaultNames";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefaultNamesFromContext";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "generateOrdinalVariants";
                break;
            }
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVariableNamesAtPlace";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureUniqueVariableName";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityKind";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaScriptIdentifier";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNamesFromQualifiedName";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "tryDetectNamingStyle";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "generateOrdinal";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCardinal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateNameFromJSTypeOrNull";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNameForComplexType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIterableType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromGenericType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNameFromExpression";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNamesFromExpression";
                break;
            }
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 63: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 91: 
            case 92: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultVariableNameForEntityKind";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNamesFromType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "generateTypeNamesFromType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "guessParameterNameByFunctionName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNamesAtPlace";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "ensureUniqueVariableName";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "suggestNameForCallLike";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addName";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaScriptIdentifier";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getLastMeaningfulName";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "generateNamesFromQualifiedName";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInScopeAndUp";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "matchesFileNameByCodeStyle";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "matchesFileNameRelaxed";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "fileNameFromElementName";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileNameWithoutExtension";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectNamingStyle";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "fileNameToElementName";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "fileNameToElementNameCapitalizeAsIs";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "isCapitalizedOnly";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeByConvention";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "trimPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 23, 24, 26, 27, 28, 29, 30, 32, 33, 34, 35, 36, 37, 38, 40, 45, 54, 55, 56, 57, 58, 60, 63, 73, 74, 75, 76, 77, 78, 79, 91, 92 -> new IllegalStateException(string);
        };
    }

    private static class NumericNameGenerator {
        private static final Int2ObjectMap<String> belowTenOrdinals = new Int2ObjectOpenHashMap();
        private static final Int2ObjectMap<String> belowTenCardinals;
        private static final Int2ObjectMap<String> xtensOrdinals;
        private static final Int2ObjectMap<String> xtensCardinals;
        private static final Int2ObjectMap<String> rounds;

        private NumericNameGenerator() {
        }

        private static String generateOrdinal(int index) {
            return NumericNameGenerator.generateNumericName(index, belowTenOrdinals, xtensOrdinals);
        }

        private static String generateCardinal(int index) {
            return NumericNameGenerator.generateNumericName(index, belowTenCardinals, xtensCardinals);
        }

        private static String generateNumericName(int index, Int2ObjectMap<String> belowTen, Int2ObjectMap<String> xtens) {
            int number = index + 1;
            if (number < 10) {
                return (String)belowTen.get(number);
            }
            if (number < 20) {
                return (String)xtens.get(number);
            }
            IntIterator iterator = rounds.keySet().iterator();
            while (iterator.hasNext()) {
                int key = iterator.nextInt();
                if (number == key) {
                    return (String)rounds.get(key);
                }
                int diff = number - key;
                if (diff <= 0 || diff >= 10) continue;
                return (String)rounds.get(key) + StringUtil.capitalize((String)((String)belowTen.get(diff)));
            }
            return "element" + number;
        }

        static {
            belowTenOrdinals.put(1, (Object)"first");
            belowTenOrdinals.put(2, (Object)"second");
            belowTenOrdinals.put(3, (Object)"third");
            belowTenOrdinals.put(4, (Object)"fourth");
            belowTenOrdinals.put(5, (Object)"fifth");
            belowTenOrdinals.put(6, (Object)"sixth");
            belowTenOrdinals.put(7, (Object)"seventh");
            belowTenOrdinals.put(8, (Object)"eighth");
            belowTenOrdinals.put(9, (Object)"ninth");
            belowTenCardinals = new Int2ObjectOpenHashMap();
            belowTenCardinals.put(1, (Object)"one");
            belowTenCardinals.put(2, (Object)"two");
            belowTenCardinals.put(3, (Object)"three");
            belowTenCardinals.put(4, (Object)"four");
            belowTenCardinals.put(5, (Object)"five");
            belowTenCardinals.put(6, (Object)"six");
            belowTenCardinals.put(7, (Object)"seven");
            belowTenCardinals.put(8, (Object)"eight");
            belowTenCardinals.put(9, (Object)"nine");
            xtensOrdinals = new Int2ObjectOpenHashMap();
            xtensOrdinals.put(10, (Object)"tenth");
            xtensOrdinals.put(11, (Object)"eleventh");
            xtensOrdinals.put(12, (Object)"twelfth");
            xtensOrdinals.put(13, (Object)"thirteens");
            xtensOrdinals.put(14, (Object)"fourteens");
            xtensOrdinals.put(15, (Object)"fifteens");
            xtensOrdinals.put(16, (Object)"sixteens");
            xtensOrdinals.put(17, (Object)"seventeens");
            xtensOrdinals.put(18, (Object)"eighteens");
            xtensOrdinals.put(19, (Object)"nineteens");
            xtensCardinals = new Int2ObjectOpenHashMap();
            xtensCardinals.put(10, (Object)"ten");
            xtensCardinals.put(11, (Object)"eleven");
            xtensCardinals.put(12, (Object)"twelve");
            xtensCardinals.put(13, (Object)"thirteen");
            xtensCardinals.put(14, (Object)"fourteen");
            xtensCardinals.put(15, (Object)"fifteen");
            xtensCardinals.put(16, (Object)"sixteen");
            xtensCardinals.put(17, (Object)"seventeen");
            xtensCardinals.put(18, (Object)"eighteen");
            xtensCardinals.put(19, (Object)"nineteen");
            rounds = new Int2ObjectOpenHashMap();
            rounds.put(20, (Object)"twenty");
            rounds.put(30, (Object)"thirty");
            rounds.put(40, (Object)"forty");
            rounds.put(50, (Object)"fifty");
            rounds.put(60, (Object)"sixty");
            rounds.put(70, (Object)"seventy");
            rounds.put(80, (Object)"eighty");
            rounds.put(90, (Object)"ninety");
        }
    }
}

