/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSIndentOptionsEditor;
import com.intellij.lang.javascript.formatter.JSLanguageCodeStyleSettingsProvider;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleConfigurable;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final String BLANK_LINES_SAMPLE = "/**\n * This is a sample file\n */\nimport {Component} from 'React'\nimport {add, subtract} from 'utils';\nclass Foo {\n    field1 = 1;\n    field2 = 2;\n    foo() {\n        console.log('foo')\n    }\n    static bar() {\n        function hello(n) {\n            console.log('hello ' + n)\n        }\n        var x = 1;\n\n\n        while (x < 10) {\n            hello(x)\n        }\n    }\n}\ninterface IFoo {\n    field: number\n    field2: number\n    foo(): void;\n}\n";
    private static final String SPACING_CODE_SAMPLE = "import {Component} from 'react'\nmodule Greetings {\n    export abstract class Greeter<T> {\n        greetNTimes(to, {from, times}: { from: string[], times: number }) {\n            return range(times).map(item => this.greet(to, from))\n        }\n\n        abstract greet(to: string, from: string[]): T\n    }\n\n    export class ConsoleGreeter extends Greeter<string> {\n        greet(to: string, from: string[]): string {\n            return `Hello, ${to} from ${from.join(',')}`\n        }\n    }\n\n    export class ReactGreeter extends Greeter<JSX.Element> {\n        greet(to, from): JSX.Element {\n            return (<div className=\"greeting\">\n                Hello, {to} from\n                {from.map(name => <Name>{name}</Name>)}\n            </div>)\n        }\n    }\n\n   type Season = Winter | Spring | Summer | Autumn;\n\n   type Foobar = \n            { foo: string } \n            & { bar: number }\n\n   var g:Greetings.ReactGreeter = new ReactGreeter()\n\n   function *fibonacci(current = 1, next = 1) {\n       yield current;\n       yield *fibonacci(next, current + next);\n   }\n\n   let [first, second, ...rest] = take(fibonacci(), 10)\n\nfunction foo(x,y,z) {\n    var i = 0;\n    var x = {0:\"zero\",1:\"one\"};\n    var a = [0,1,2];\n    var foo = function () {}\n    var asyncFoo = async (x, y, z) => { }\n    var v = x.map( s => s.length );\n    if (!i > 10) {\n        for (var j = 0; j < 10; j++) {\n            switch (j) {\n                case 0:\n                    value = \"zero\";\n                    break;\n                case 1:\n                    value = \"one\";\n                    break;\n            }\n            var c = j > 5 ? \"GT 5\" : \"LE 5\";\n        }\n    } else {\n        var j = 0;\n        try {\n            while (j < 10) {\n                if (i == j || j > 5) {\n                    a[j] = i + j * 12;\n                }\n                i = (j << 2) & 4;\n                j++;\n            }\n            do {\n                j--;\n            } while (j > 0)\n        } catch (e) {\n            alert(\"Failure: \" + e.message);\n        } finally {\n            reset(a,i);\n        }\n    }\n}}\n";
    private static final String WRAPPING_CODE_SAMPLE = "import {Component} from 'react'\nimport {Rx} from 'rxjs/Observable'\nimport {property1, property2, property3} from './myModule.js'\n\n@ClassDecorator(param1, param2)\n@ClassDecoratorExt\nclass Foo extends BarComponent implements BazService, QuuxProvider {\n\n    @MethodDecorator(param1) @MethodDecoratorExt\n    foo(@ParamDecoratorExt @Deprecated prop1, @ParamDecoratorExt(property1) prop2) {}\n\n    @FieldDecorator\n    @FieldDecoratorExt\n    field1 = 1;\n}\n\nfunction buzz() { return 0; }\nvar x = 1, y = 2, foregroundColor = 'transparent', highlightColor = 'lime', font = 'Arial';\n/*\n Multiline\n   C-style\n     Comment\n */\nvar myLink  = {img: \"btn.gif\"},\n    local   = true,\n    initial = -1;\nwidth = 400\nheight = 300\n\nvar foo = {\n    numbers:['one', 'two', 'three', 'four', 'five', 'six'],\n    data : {a:{id: 123, type: \"String\", isAvailable: true},\nb:{id: 456, type:\"Int\"}},\n// fBar : function (x,y);\n    fOne:function(a, b, c, d, e, f, g, h) {\n        var x = a + b + c + d + e + f + g + h;\n        fTwo(a, b, c, fThree(d, e, f, g, h));\n        var z = a == 'Some string' ? 'yes' : 'no';\n        z = a == 10 ? 'yes' : 'no';\n        var colors = ['red', 'green', 'blue', 'black', 'white', 'gray'];\n        for (j = 0; j < 2; j ++) i = a;        for (var i = 0; i < colors.length; i++)\n             var colorString = this.numbers[i];\n    },\n\n chainedCallSample: function(a,b,c,d,e,f) {\n        chainRoot.firstCall(a,b,c,d,e,f,g).secondCall(a,b,c,d).thirdCall(a,b,c,d).fourthCall().q(a).r(a,b).s();\n        chainRoot.x().y()\n        .z();     },\n callArgumentsSample: function () {\n    this.fTwo(\"one\", \"two\", \"three\", \"four\");\n    this.fThree({\n      strA: 'a',\n      strB: 'b',\n      strC: 'c',\n      strD: 'd'\n    }, 'strE');\n    [1, 2, 3].reduce(function (previousValue, currentValue) {\n      return previousValue + currentValue;\n    }, 10);\n  },\n    /**\n     * Function JSDoc. Long lines can be wrapped with 'Comments'/'Wrap at right margin' option\n     * @param {string} a Parameter A description.\n     * @param {string} b Parameter B description. Can extend beyond the right margin.\n     */\n    fTwo:function(a, b, c, d) {\n        foo(a, b, c, d); // Line comment which can be wrapped if long.\n        if (true)\n            return c;\n        if (a == 'one' && (b == 'two' || c == 'three')) {\n            return a + b + c + d;\n        } else return strD;\n        if (a == 'one') {\n            return 1;\n        }\n        else if(a == 'two') {\n            return 2;\n        }\n        var number = -10;\n        while (x < 0) {\n            number = number + 1;\n        }\n        do {\n            number = number + 1;\n        } while (number < 10);\n        return d;\n    },\n\n    fThree:function({strA, strB, strC, strD}, strE) {\n        var number = prompt(\"Enter a number:\", 0);\n        switch (number) {\n            case 0 :\n                alert(\"Zero\");\n                break;\n            case 1:\n                alert(\"One\");\n                break;\n        }\n        try {\n            a[2]= 10;\n        }\n        catch(e) {\n            alert(\"Failure: \" + e.message);\n        }\n        return strA + strB + strC + strD + strE;\n    }\n};\ntype Season = Winter | Spring  | Summer | Autumn\nenum Seasons { Winter, Spring, Summer, Autumn }\ntype Winter = { snowflakesAmount: number; averageTemperature: number; didGrinchStealChristmas: boolean}";

    @NotNull
    public Language getLanguage() {
        JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.TYPESCRIPT;
        if (jSLanguageDialect == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return jSLanguageDialect;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return switch (settingsType) {
            case LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS -> SPACING_CODE_SAMPLE;
            case LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS -> WRAPPING_CODE_SAMPLE;
            case LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS -> BLANK_LINES_SAMPLE;
            case LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS -> "foo(\n        \"demo\",\n        {\n            title:\"Demo\",\n            width:100\n        },\n        function() {\n            object.firstCall({\n            a:'a',\n            b:'b'})\n            .secondCall();\n        }\n);";
            default -> SPACING_CODE_SAMPLE;
        };
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (indentOptions == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        JSLanguageCodeStyleSettingsProvider.doCustomizeDefaults(commonSettings, indentOptions);
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new JSIndentOptionsEditor(JavaScriptSupportLoader.TYPESCRIPT);
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return new TypeScriptCodeStyleSettings(settings);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (modelSettings == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        return new TypeScriptCodeStyleConfigurable(baseSettings, modelSettings);
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (text == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (Language)JavaScriptSupportLoader.TYPESCRIPT_JSX, (CharSequence)text, false, false);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        if (settingsType == null) {
            TypeScriptLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        JSLanguageCodeStyleSettingsProvider.addJSOrTSCommonSettings(consumer, TypeScriptCodeStyleSettings.class, settingsType);
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_TYPE_COLON", JavaScriptBundle.message("space.before.type.colon", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_AFTER_TYPE_COLON", JavaScriptBundle.message("space.after.type.colon", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_OBJECT_TYPE_BRACES", JavaScriptBundle.message("spaces.within.object.type.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_BEFORE_CLASS_LBRACE", JavaScriptBundle.message("space.before.class.interface.module.lbrace", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_LEFT_BRACE, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACES_WITHIN_UNION_TYPES", JavaScriptBundle.message("spaces.within.union.and.intersection", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "SPACE_WITHIN_TYPE_ASSERTION", JavaScriptBundle.message("spaces.within.type.assertion", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "UNION_TYPES_WRAP", JavaScriptBundle.message("js.wrap.settings.union.and.intersection.types", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "OBJECT_TYPES_WRAP", JavaScriptBundle.message("js.wrap.settings.object.types", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(TypeScriptCodeStyleSettings.class, "ALIGN_UNION_TYPES", JavaScriptBundle.message("js.code.style.align.caption", new Object[0]), JavaScriptBundle.message("js.wrap.settings.union.and.intersection.types", new Object[0]), new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            ArrayList<String> blankLinesOptions = new ArrayList<String>();
            blankLinesOptions.add("BLANK_LINES_AROUND_FIELD_IN_INTERFACE");
            blankLinesOptions.add("BLANK_LINES_AROUND_METHOD_IN_INTERFACE");
            consumer.showStandardOptions(ArrayUtilRt.toStringArray(blankLinesOptions));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/formatter/TypeScriptLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

