/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptBundle;

public final class CucumberJavaScriptUtil {
    public static final String STEP_INDEX = "$cucumberJSSteps";
    public static final String CUSTOM_PARAMETER_INDEX = "$cucumberJSCustomParameters";
    public static final String FORMATTER_FILE_NAME = "cucumberjs_formatter.js";
    public static final String FORMATTER_FILE_NAME_2 = "cucumberjs_formatter_v2.js";
    public static final String FORMATTER_FILE_NAME_3 = "cucumberjs_formatter_v3.js";
    public static final String FORMATTER_FILE_NAME_7 = "cucumberjs_formatter_v7.js";
    public static final String CUCUMBER_PACKAGE_NAME = "cucumber";
    public static final String CUCUMBER_V7_PACKAGE_NAME = "@cucumber/cucumber";
    public static final List<String> CUCUMBER_PACKAGES = List.of("cucumber", "@cucumber/cucumber");
    public static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor(new String[]{"cucumber", "@cucumber/cucumber", CucumberJavaScriptBundle.message("cucumber.js.package.placeholder.text", new Object[0])});
    @NonNls
    static final String jarPath = PathUtil.getJarPathForClass(CucumberJavaScriptUtil.class);
    private static final String CUCUMBER_PACKAGE_DIR_KEY = "nodejs.cucumber.cucumber_node_package_dir";
    @NotNull
    static final String NAME_PARAMETER_PROP = "name";
    @NotNull
    static final String REGEXP_PARAMETER_PROP = "regexp";
    @NotNull
    static final TokenSet LITERAL_STUBS = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.LITERAL_EXPRESSION, JSStubElementTypes.STRING_TEMPLATE_EXPRESSION});
    @NotNull
    static final TokenSet OBJECT_LITERAL_TYPES = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.OBJECT_LITERAL_EXPRESSION});

    public static String getFormatterPath() {
        return CucumberJavaScriptUtil.getFilePath(FORMATTER_FILE_NAME);
    }

    public static String getV2FormatterPath() {
        return CucumberJavaScriptUtil.getFilePath(FORMATTER_FILE_NAME_2);
    }

    public static String getV3FormatterPath() {
        return CucumberJavaScriptUtil.getFilePath(FORMATTER_FILE_NAME_3);
    }

    public static String getV7FormatterPath() {
        return CucumberJavaScriptUtil.getFilePath(FORMATTER_FILE_NAME_7);
    }

    @NotNull
    private static String getFilePath(String name) {
        File jarFile = new File(jarPath);
        if (jarPath.endsWith(".jar")) {
            String string = FileUtil.toSystemIndependentName((String)(jarFile.getParentFile() + "/" + name));
            if (string == null) {
                CucumberJavaScriptUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = FileUtil.toSystemIndependentName((String)(jarFile.getParentFile() + "/intellij.javascript.cucumber/org/jetbrains/plugins/cucumber/javascript/run/" + name));
        if (string == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static NodePackage getCucumberPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        NodePackage defaultPackage;
        String packageDir;
        if (project == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)(packageDir = PropertiesComponent.getInstance((Project)project).getValue(CUCUMBER_PACKAGE_DIR_KEY))) && !(defaultPackage = NodePackage.findPreferredPackage((Project)project, CUCUMBER_PACKAGES, (NodeJsInterpreter)interpreter)).getSystemIndependentPath().isEmpty()) {
            CucumberJavaScriptUtil.setCucumberPackage(project, defaultPackage);
            NodePackage nodePackage = defaultPackage;
            if (nodePackage == null) {
                CucumberJavaScriptUtil.$$$reportNull$$$0(3);
            }
            return nodePackage;
        }
        return new NodePackage(StringUtil.notNullize((String)packageDir));
    }

    public static void setCucumberPackage(@NotNull Project project, @NotNull NodePackage cucumberPackage) {
        if (project == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(4);
        }
        if (cucumberPackage == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance((Project)project).setValue(CUCUMBER_PACKAGE_DIR_KEY, cucumberPackage.getSystemIndependentPath());
    }

    @Nullable
    public static String getCucumberStepTextFromElement(@Nullable PsiElement element) {
        if (element instanceof JSCallExpression) {
            JSExpression expression = (JSExpression)ArrayUtil.getFirstElement((Object[])((JSCallExpression)element).getArguments());
            if (expression != null) {
                element = expression;
            } else {
                return null;
            }
        }
        if (element instanceof JSStringTemplateExpression && ((JSStringTemplateExpression)element).getExpressionKind(false) != JSLiteralExpressionKind.TEMPLATE_NO_ARGS) {
            return null;
        }
        if (element instanceof JSLiteralExpression) {
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            String expressionText = literalExpression.getText();
            return literalExpression.isRegExpLiteral() && !CucumberJavaScriptUtil.isRegexpString(expressionText) ? null : expressionText;
        }
        return null;
    }

    public static boolean isRegexpString(@Nullable String s) {
        return s != null && s.indexOf(47) == 0 && s.lastIndexOf(47) > 0;
    }

    @Nullable
    public static String getContentFromLiteralText(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)s)) {
            return "";
        }
        if (CucumberJavaScriptUtil.isRegexpString(s)) {
            return s.substring(1, s.lastIndexOf(47));
        }
        if (s.charAt(0) == '`') {
            return s.substring(1, s.length() - 1).replace("\\`", "`");
        }
        return JSStringUtil.unquoteAndUnescapeStringLiteralValue((String)s);
    }

    @Nullable
    public static JSLiteralExpression findFirstChildLiteral(@Nullable StubBasedPsiElementBase<?> element) {
        if (element == null) {
            return null;
        }
        Collection children = JSStubBasedPsiTreeUtil.findDescendants(element, (TokenSet)LITERAL_STUBS);
        return (JSLiteralExpression)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem((Collection)children), JSLiteralExpression.class);
    }

    @Nullable
    public static PsiElement getFirstCallArgument(@NotNull JSCallExpressionImpl callExpression, @NotNull TokenSet argumentTypes) {
        StubElement stub;
        if (callExpression == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(6);
        }
        if (argumentTypes == null) {
            CucumberJavaScriptUtil.$$$reportNull$$$0(7);
        }
        Object[] children = (stub = callExpression.getStub()) != null ? stub.getChildrenByType(argumentTypes, JSExpression.ARRAY_FACTORY) : callExpression.getArguments();
        return (PsiElement)ArrayUtil.getFirstElement((Object[])children);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cucumberPackage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCucumberPackage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberPackage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCucumberPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFirstCallArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

