/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec.run;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationHandler;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhpSpecRunConfigurationHandler
implements PhpTestRunConfigurationHandler {
    private static final Logger LOG = Logger.getInstance(PhpSpecRunConfigurationHandler.class);
    private static final String PHPSPEC_HELPER_ENV_EXE = "IDE_PHPSPEC_EXE";
    private static final PhpSpecRunConfigurationHandler ourInstance = new PhpSpecRunConfigurationHandler();

    PhpSpecRunConfigurationHandler() {
    }

    public static PhpSpecRunConfigurationHandler getInstance() {
        return ourInstance;
    }

    @NotNull
    public String getConfigFileOption() {
        return "-c";
    }

    public void prepareCommand(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String exe, @Nullable String version) throws ExecutionException {
        String scriptFile;
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(0);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(1);
        }
        if (exe == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(scriptFile = PhpExecutionUtil.loadHelperScriptAndGetText((Project)project, (String)"phpspec.php", (PhpCommandSettings)command, PhpSpecRunConfigurationHandler.class)))) {
            String message = PhpBundle.message((String)"php.interpreter.base.configuration.interpreter.is.invalid", (Object[])new Object[]{"PHPSpec tests", "PHPSpec"});
            throw new ExecutionException(message);
        }
        command.setScript(scriptFile, false);
        command.addArgument("run");
        command.addArgument("--format=phpstorm");
        command.addArgument("--no-interaction");
        command.addEnv(PHPSPEC_HELPER_ENV_EXE, exe);
    }

    public void runType(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String type, @NotNull String workingDirectory) throws ExecutionException {
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(3);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(4);
        }
        if (type == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(5);
        }
        if (workingDirectory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(6);
        }
        throw new ExecutionException(PhpBundle.message((String)"php.test.framework.validation.run.configuration.unsupported.type", (Object[])new Object[]{type}));
    }

    public void runDirectory(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String directory, @NotNull String workingDirectory) {
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(7);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(8);
        }
        if (directory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(9);
        }
        if (workingDirectory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(10);
        }
        command.addRelativePathArgument(directory, workingDirectory);
    }

    public void runFile(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String file, @NotNull String workingDirectory) {
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(11);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(12);
        }
        if (file == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(13);
        }
        if (workingDirectory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(14);
        }
        command.addRelativePathArgument(file, workingDirectory);
    }

    public void runMethod(@NotNull Project project, @NotNull PhpCommandSettings command, @NotNull String filePath, @NotNull String methodName, @NotNull String workingDirectory) {
        Method specification;
        PsiFile file;
        if (project == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(15);
        }
        if (command == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(16);
        }
        if (filePath == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(17);
        }
        if (methodName == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(18);
        }
        if (workingDirectory == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(19);
        }
        if ((file = PhpRunUtil.findPsiFile((Project)project, (String)filePath)) instanceof PhpFile && (specification = PhpSpecRunConfigurationHandler.getSpecification((PhpFile)file, methodName)) != null) {
            int line;
            int offset = specification.getTextRange().getStartOffset();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            int n = line = document == null ? -1 : document.getLineNumber(offset) + 1;
            if (line < 0) {
                LOG.warn("Can not find method '" + methodName + "' in " + workingDirectory + File.separator + filePath);
            }
            command.addRelativePathArgument(filePath, workingDirectory, ":" + line);
        }
    }

    @Nullable
    private static Method getSpecification(@NotNull PhpFile file, @Nullable String name) {
        if (file == null) {
            PhpSpecRunConfigurationHandler.$$$reportNull$$$0(20);
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return null;
        }
        return PhpPsiUtil.findAllClasses((PhpFile)file).stream().map(c -> c.findMethodByName((CharSequence)name)).filter(m -> m != null).findAny().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exe";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phpspec/run/PhpSpecRunConfigurationHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareCommand";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "runDirectory";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "runFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "runMethod";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpecification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

