/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DrupalUtil {
    @NonNls
    public static final String MODULE_FILE_EXTENSION = ".module";
    @NonNls
    public static final String ENGINE_FILE_EXTENSION = ".engine";
    @NonNls
    public static final String PROFILE_FILE_EXTENSION = ".profile";
    @NonNls
    public static final String THEME_FILE_EXTENSION = ".theme";
    @NonNls
    public static final String INFO_FILE_EXTENSION = ".info";

    private DrupalUtil() {
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String validateDrupalFolder(String path, @Nullable DrupalVersion version) {
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return DrupalBundle.message("drupal.validate.directory.message", new Object[0]);
        }
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        return DrupalUtil.validateDrupalInstallation(file, version);
    }

    @Contract(value="null, _ -> !null")
    @Nullable
    @NlsContexts.DialogMessage
    public static String validateDrupalInstallation(@Nullable VirtualFile file, @Nullable DrupalVersion version) {
        if (file == null || !file.isDirectory() || VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"modules"}) == null || VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"sites"}) == null) {
            return DrupalBundle.message("drupal.validate.directory.message", new Object[0]);
        }
        if (version == null) {
            return null;
        }
        switch (version) {
            case SIX: 
            case SEVEN: {
                if (VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"includes"}) != null) break;
                return DrupalBundle.message("drupal.validate.directory.message.6.7", new Object[0]);
            }
            case EIGHT: 
            case NINE: {
                if (VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{"core"}) != null) break;
                return DrupalBundle.message("drupal.validate.directory.message.8", new Object[0]);
            }
            default: {
                throw new IllegalStateException("Unknown drupal version: " + version);
            }
        }
        return null;
    }

    public static boolean isValid(DrupalDataService.State state) {
        if (!state.isEnabled()) {
            return true;
        }
        DrupalVersion version = DrupalVersion.getFromNumber(state.getVersion());
        if (version == null) {
            return false;
        }
        return DrupalUtil.validateDrupalFolder(state.getDrupalPath(), version) == null;
    }

    public static void notifyGlobally(@Nullable Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message, NotificationType notificationType, Function<Notification, AnAction> ... actions) {
        Notification notification = new Notification("Drupal", title, message, notificationType);
        notification.setSuggestionType(true);
        for (Function<Notification, AnAction> actionGenerator : actions) {
            notification.addAction(actionGenerator.apply(notification));
        }
        notification.notify(project);
    }

    @Nullable
    public static String getHookBaseName(VirtualFile file, @Nullable Map<VirtualFile, String> hookBaseNamesCache, @NotNull Project project) {
        if (project == null) {
            DrupalUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return null;
        }
        String hookBaseName = DrupalUtil.getHookBaseName(file.getName());
        if (hookBaseName != null) {
            return hookBaseName;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile parent = file;
        while (true) {
            String cachedHookBaseName;
            ProgressManager.checkCanceled();
            parent = parent.getParent();
            if (parent == null) break;
            if (!projectFileIndex.isInProject(parent)) {
                return null;
            }
            if (hookBaseNamesCache != null && (cachedHookBaseName = hookBaseNamesCache.get(parent)) != null) {
                if (cachedHookBaseName.isEmpty()) continue;
                return cachedHookBaseName;
            }
            for (VirtualFile child : parent.getChildren()) {
                if (child.isDirectory()) continue;
                ProgressManager.checkCanceled();
                String childFileName = DrupalUtil.getHookBaseName(child.getName());
                if (childFileName == null) continue;
                if (hookBaseNamesCache != null) {
                    hookBaseNamesCache.put(parent, childFileName);
                }
                return childFileName;
            }
            if (hookBaseNamesCache == null) continue;
            hookBaseNamesCache.put(parent, "");
        }
        return null;
    }

    @Nullable
    private static String getHookBaseName(String fileName) {
        String[] extensions;
        for (String extension : extensions = new String[]{MODULE_FILE_EXTENSION, PROFILE_FILE_EXTENSION, ENGINE_FILE_EXTENSION, THEME_FILE_EXTENSION, INFO_FILE_EXTENSION}) {
            if (!fileName.endsWith(extension)) continue;
            return fileName.substring(0, fileName.length() - extension.length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/drupal/DrupalUtil", "getHookBaseName"));
    }
}

