/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.clt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DrushUtils {
    private static final Logger LOG = Logger.getInstance(DrushUtils.class);
    private static final String FORMAT_JSON_OPTION = "--format=json";
    private static final String DRUSH_9_0 = "9.0.0";
    private static final String DRUSH_9_1 = "9.1.0";
    static final String DRUSH_9_X = "9.";

    private DrushUtils() {
    }

    static List<FrameworkCommand> getFrameworkCommands(String drushPath, @Nullable Project project, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        List<FrameworkCommand> commands;
        if (pi == null) {
            DrushUtils.$$$reportNull$$$0(0);
        }
        FrameworkDescription drushFramework = DrushUtils.getDrushFrameworkDescription(drushPath);
        ScriptRunnerUtil.ScriptOutput commandsOutput = DrushUtils.getCommandsDescription(drushPath, project);
        FrameworkUtils.checkProgress((ProgressIndicator)pi);
        String descriptiveOutput = commandsOutput.getDescriptiveOutput();
        try {
            String drushVersion = DrushUtils.getDrushVersion(drushPath, project);
            commands = DrushUtils.needsPerCommandHandling(drushVersion) ? DrushUtils.parseCommandsSeparatelyFromList(drushPath, project, drushFramework) : DrushUtils.parseCommandsJson(descriptiveOutput, drushFramework, drushVersion);
        }
        catch (JsonSyntaxException e) {
            LOG.warn(descriptiveOutput, (Throwable)e);
            throw new FrameworkDescriptionProvider.FrameworkParseException(DrushUtils.getDescriptionCommand(drushPath), descriptiveOutput, DrupalBundle.message("drush.failed.to.parse.output", new Object[0]));
        }
        if (commands.isEmpty()) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(DrushUtils.getDescriptionCommand(drushPath), descriptiveOutput, DrupalBundle.message("drush.no.commands.found", new Object[0]));
        }
        return commands;
    }

    private static boolean needsPerCommandHandling(@NotNull String version) {
        if (version == null) {
            DrushUtils.$$$reportNull$$$0(1);
        }
        return version.equals(DRUSH_9_0) || version.equals(DRUSH_9_1);
    }

    private static boolean needsCommandWithNamespacesHandling(@NotNull String version) {
        if (version == null) {
            DrushUtils.$$$reportNull$$$0(2);
        }
        return version.startsWith(DRUSH_9_X) && !version.startsWith(DRUSH_9_0) && !version.startsWith(DRUSH_9_1) || Objects.requireNonNull(Version.parseVersion((String)version)).major > 9;
    }

    @NotNull
    private static String getDrushVersion(@NotNull String drushPath, @Nullable Project project) throws ExecutionException {
        String versionOutput;
        JsonParser parser;
        JsonElement element;
        if (drushPath == null) {
            DrushUtils.$$$reportNull$$$0(3);
        }
        if ((element = (parser = new JsonParser()).parse(versionOutput = DrushUtils.getVersionDescription(drushPath, project).getDescriptiveOutput())).isJsonObject()) {
            JsonElement drushVersion = ((JsonObject)element).get("drush-version");
            if (drushVersion != null && drushVersion.isJsonPrimitive()) {
                String string = drushVersion.getAsString();
                if (string == null) {
                    DrushUtils.$$$reportNull$$$0(4);
                }
                return string;
            }
            throw new JsonSyntaxException("Parsed version is not a string.");
        }
        String string = versionOutput;
        if (string == null) {
            DrushUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    static List<FrameworkCommand> parseCommandsSeparatelyFromList(@NotNull String drushPath, @Nullable Project project, @NotNull FrameworkDescription framework) throws ExecutionException {
        if (drushPath == null) {
            DrushUtils.$$$reportNull$$$0(6);
        }
        if (framework == null) {
            DrushUtils.$$$reportNull$$$0(7);
        }
        ScriptRunnerUtil.ScriptOutput listCommandsDescription = DrushUtils.getListCommandsDescription(drushPath, project);
        String[] listLines = StringUtil.splitByLinesDontTrim((String)listCommandsDescription.getDescriptiveOutput());
        String whitespacePattern = "   ";
        ArrayList<FrameworkCommand> result = new ArrayList<FrameworkCommand>();
        for (String line : listLines) {
            String commandWord;
            if (!line.startsWith(whitespacePattern) || StringUtil.isWhiteSpace((char)line.charAt(whitespacePattern.length())) || (commandWord = DrushUtils.getCommandWord(line, whitespacePattern)) == null) continue;
            ScriptRunnerUtil.ScriptOutput commandOutput = DrushUtils.getCommandDescription(drushPath, commandWord, project);
            DrushUtils.parseSeparateCommand(commandWord, commandOutput.getDescriptiveOutput(), framework, result);
        }
        ArrayList<FrameworkCommand> arrayList = result;
        if (arrayList == null) {
            DrushUtils.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    static String getCommandWord(@NotNull String line, @NotNull String pattern) {
        String withoutPrefixLine;
        if (line == null) {
            DrushUtils.$$$reportNull$$$0(9);
        }
        if (pattern == null) {
            DrushUtils.$$$reportNull$$$0(10);
        }
        if ((withoutPrefixLine = StringUtil.substringAfter((String)line, (String)pattern)) != null) {
            return StringUtil.substringBefore((String)withoutPrefixLine, (String)" ");
        }
        return null;
    }

    static void parseSeparateCommand(@NotNull String command, @NotNull String commandDescription, @NotNull FrameworkDescription framework, @NotNull List<FrameworkCommand> commands) {
        JsonParser parser;
        JsonElement element;
        if (command == null) {
            DrushUtils.$$$reportNull$$$0(11);
        }
        if (commandDescription == null) {
            DrushUtils.$$$reportNull$$$0(12);
        }
        if (framework == null) {
            DrushUtils.$$$reportNull$$$0(13);
        }
        if (commands == null) {
            DrushUtils.$$$reportNull$$$0(14);
        }
        if (!(element = (parser = new JsonParser()).parse(commandDescription)).isJsonObject()) {
            throw new JsonSyntaxException("Parsed command is not an object.");
        }
        commands.addAll(DrushUtils.parseCommandDescription(command, (JsonObject)element, framework, ""));
    }

    static List<FrameworkCommand> parseCommandsJson(String json, @NotNull FrameworkDescription framework, @NotNull String version) {
        JsonParser parser;
        JsonElement element;
        if (framework == null) {
            DrushUtils.$$$reportNull$$$0(15);
        }
        if (version == null) {
            DrushUtils.$$$reportNull$$$0(16);
        }
        if (!((element = (parser = new JsonParser()).parse(json)) instanceof JsonObject)) {
            throw new JsonSyntaxException("Parsed element is not an object.");
        }
        JsonObject object = (JsonObject)element;
        ArrayList<FrameworkCommand> result = new ArrayList<FrameworkCommand>();
        if (DrushUtils.needsCommandWithNamespacesHandling(version)) {
            DrushUtils.parseCommandsFromJsonWithNamespaces(framework, object, result);
        } else {
            DrushUtils.parseCommandsFromJsonWithSourceKeys(framework, object, result);
        }
        return result;
    }

    private static void parseCommandsFromJsonWithNamespaces(@NotNull FrameworkDescription framework, @NotNull JsonObject object, @NotNull List<FrameworkCommand> result) {
        if (framework == null) {
            DrushUtils.$$$reportNull$$$0(17);
        }
        if (object == null) {
            DrushUtils.$$$reportNull$$$0(18);
        }
        if (result == null) {
            DrushUtils.$$$reportNull$$$0(19);
        }
        Map<String, String> commandSources = DrushUtils.parseNamespaces(object);
        JsonElement jsonElement = object.get("commands");
        if (!jsonElement.isJsonArray()) {
            throw new JsonSyntaxException("Commands are not an array");
        }
        JsonArray commands = jsonElement.getAsJsonArray();
        for (JsonElement command : commands) {
            String nameString;
            String source;
            if (!command.isJsonObject()) {
                throw new JsonSyntaxException("Command is not an object");
            }
            JsonObject commandObject = command.getAsJsonObject();
            JsonElement name = commandObject.get("name");
            if (!name.isJsonPrimitive() || (source = commandSources.get(nameString = name.getAsString())) == null) continue;
            result.addAll(DrushUtils.parseCommandDescription(nameString, commandObject, framework, source));
        }
    }

    @NotNull
    private static Map<String, String> parseNamespaces(@NotNull JsonObject object) {
        if (object == null) {
            DrushUtils.$$$reportNull$$$0(20);
        }
        HashMap<String, String> commandSources = new HashMap<String, String>();
        JsonElement jsonElement = object.get("namespaces");
        if (!jsonElement.isJsonArray()) {
            throw new JsonSyntaxException("Namespaces are not an array");
        }
        JsonArray namespaces = jsonElement.getAsJsonArray();
        for (JsonElement namespace : namespaces) {
            if (!namespace.isJsonObject()) {
                throw new JsonSyntaxException("Namespace is not an object");
            }
            JsonObject namespaceObject = namespace.getAsJsonObject();
            JsonElement namespaceId = namespaceObject.get("id");
            JsonElement commands = namespaceObject.get("commands");
            if (!namespaceId.isJsonPrimitive() || !commands.isJsonArray()) continue;
            String source = namespaceId.getAsString();
            for (JsonElement command : commands.getAsJsonArray()) {
                if (!command.isJsonPrimitive()) continue;
                String commandName = command.getAsString();
                commandSources.put(commandName, source);
            }
        }
        HashMap<String, String> hashMap = commandSources;
        if (hashMap == null) {
            DrushUtils.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    private static void parseCommandsFromJsonWithSourceKeys(@NotNull FrameworkDescription framework, @NotNull JsonObject object, @NotNull List<FrameworkCommand> result) {
        if (framework == null) {
            DrushUtils.$$$reportNull$$$0(22);
        }
        if (object == null) {
            DrushUtils.$$$reportNull$$$0(23);
        }
        if (result == null) {
            DrushUtils.$$$reportNull$$$0(24);
        }
        for (Map.Entry entry : object.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof JsonObject)) {
                LOG.warn("Description is not an object:\n" + ((JsonElement)entry.getValue()).toString());
                continue;
            }
            JsonObject sourceObject = (JsonObject)v;
            JsonElement commandsObject = sourceObject.get("commands");
            String source = (String)entry.getKey();
            if (!(commandsObject instanceof JsonObject)) {
                throw new JsonSyntaxException("Commands element is not an object for" + source);
            }
            for (Map.Entry commandEntry : ((JsonObject)commandsObject).entrySet()) {
                if (!(commandEntry.getValue() instanceof JsonObject)) {
                    throw new JsonSyntaxException("Command element is not an object for" + source + "/" + (String)commandEntry.getKey());
                }
                result.addAll(DrushUtils.parseCommandDescription((String)commandEntry.getKey(), (JsonObject)commandEntry.getValue(), framework, source));
            }
        }
    }

    @NotNull
    private static Collection<? extends FrameworkCommand> parseCommandDescription(String commandName, JsonObject commandJson, FrameworkDescription framework, String source) {
        JsonObject commandDefinition = DrushUtils.getCommandDefinition(commandJson);
        List<DrushParameter> drushParameters = DrushUtils.parseParameters(commandDefinition.get("arguments"), commandName, commandJson, source);
        List<String> aliases = DrushUtils.parseCommandAliases(DrushUtils.getAliasesElement(commandJson), source, commandName);
        String description = "";
        JsonElement descriptionElement = commandJson.get("description");
        if (descriptionElement.isJsonPrimitive()) {
            description = descriptionElement.getAsString();
        }
        @NonNls StringBuilder helpBuilder = new StringBuilder();
        helpBuilder.append("<html>");
        if (!description.isEmpty()) {
            helpBuilder.append(description).append("<br/>");
        }
        if (!drushParameters.isEmpty()) {
            helpBuilder.append("<table>\n<tr><td><strong>Arguments:</strong></td>");
            for (DrushParameter drushParameter : drushParameters) {
                helpBuilder.append("<tr>");
                helpBuilder.append("<td valign=\"baseline\">").append(drushParameter.getName()).append("</td></td>").append(drushParameter.getHelp()).append("</td>");
                helpBuilder.append("</tr>");
            }
            helpBuilder.append("</table><br/>\n");
        } else {
            helpBuilder.append("<br/>No arguments<br/>\n");
        }
        List<Pair<String, String>> options = DrushUtils.parseOptions(commandDefinition.get("options"), commandName, source);
        if (options.isEmpty()) {
            helpBuilder.append("<br/>No options<br/>\n");
        } else {
            helpBuilder.append("<table>\n<tr><td><strong>Options:</strong></td>");
            for (Pair<String, String> pair : options) {
                helpBuilder.append("<tr>");
                helpBuilder.append("<td valign=\"baseline\">").append((String)pair.getFirst()).append("</td></td>").append((String)pair.getSecond()).append("</td>");
                helpBuilder.append("</tr>");
            }
            helpBuilder.append("</table><br/>\n");
        }
        List<Pair<String, String>> list = DrushUtils.parseExamples(commandJson.get("examples"), commandName, source);
        if (!list.isEmpty()) {
            helpBuilder.append("<table>\n<tr><td><strong>Examples:</strong></td>");
            for (Pair<String, String> pair : list) {
                helpBuilder.append("<tr>");
                helpBuilder.append("<td valign=\"baseline\">").append((String)pair.getFirst()).append("</td></td>").append((String)pair.getSecond()).append("</td>");
                helpBuilder.append("</tr>");
            }
            helpBuilder.append("</table><br/>\n");
        }
        helpBuilder.append("</html>");
        String string = helpBuilder.toString();
        ArrayList<DrushParameter> arrayList = new ArrayList<DrushParameter>(drushParameters);
        if (aliases.isEmpty()) {
            List<FrameworkCommand> list2 = Collections.singletonList(new FrameworkCommand(commandName, arrayList, false, string, Collections.emptyList(), framework));
            if (list2 == null) {
                DrushUtils.$$$reportNull$$$0(25);
            }
            return list2;
        }
        ArrayList<FrameworkCommand> result = new ArrayList<FrameworkCommand>();
        result.add(new FrameworkCommand(commandName, arrayList, false, string, Collections.emptyList(), framework));
        for (String alias : aliases) {
            result.add(new FrameworkCommand(alias, arrayList, false, string, Collections.emptyList(), framework));
        }
        ArrayList<FrameworkCommand> arrayList2 = result;
        if (arrayList2 == null) {
            DrushUtils.$$$reportNull$$$0(26);
        }
        return arrayList2;
    }

    @NotNull
    private static JsonObject getCommandDefinition(@NotNull JsonObject commandJson) {
        JsonElement commandDefinitionElement;
        if (commandJson == null) {
            DrushUtils.$$$reportNull$$$0(27);
        }
        JsonObject jsonObject = (commandDefinitionElement = (JsonElement)ObjectUtils.notNull((Object)commandJson.get("definition"), (Object)commandJson)).isJsonObject() ? (JsonObject)commandDefinitionElement : commandJson;
        if (jsonObject == null) {
            DrushUtils.$$$reportNull$$$0(28);
        }
        return jsonObject;
    }

    @Nullable
    private static JsonElement getAliasesElement(@NotNull JsonObject commandJson) {
        if (commandJson == null) {
            DrushUtils.$$$reportNull$$$0(29);
        }
        return (JsonElement)ObjectUtils.chooseNotNull((Object)commandJson.get("aliases"), (Object)commandJson.get("usage"));
    }

    private static List<Pair<String, String>> parseExamples(JsonElement examplesElement, String commandName, String source) {
        if (examplesElement == null) {
            return Collections.emptyList();
        }
        if (examplesElement instanceof JsonArray) {
            ArrayList<Pair<String, String>> examples = new ArrayList<Pair<String, String>>();
            for (JsonElement entry : examplesElement.getAsJsonArray()) {
                if (entry.isJsonPrimitive()) {
                    examples.add((Pair<String, String>)Pair.create((Object)"", (Object)entry.getAsString()));
                    continue;
                }
                if (entry.isJsonObject()) {
                    JsonObject jsonObject = entry.getAsJsonObject();
                    JsonElement description = jsonObject.get("description");
                    JsonElement usage = jsonObject.get("usage");
                    if (!description.isJsonPrimitive() || !usage.isJsonPrimitive()) continue;
                    examples.add((Pair<String, String>)Pair.create((Object)usage.getAsString(), (Object)description.getAsString()));
                    continue;
                }
                throw new JsonSyntaxException("Unexpected examples description element at " + entry + "/" + source + "/" + commandName + ":\n" + examplesElement.toString());
            }
            return examples;
        }
        if (examplesElement instanceof JsonObject) {
            JsonObject examplesObject = (JsonObject)examplesElement;
            ArrayList<Pair<String, String>> examples = new ArrayList<Pair<String, String>>();
            for (Map.Entry entry : examplesObject.entrySet()) {
                String exampleName = (String)entry.getKey();
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    examples.add((Pair<String, String>)Pair.create((Object)exampleName, (Object)((JsonElement)entry.getValue()).getAsString()));
                    continue;
                }
                throw new JsonSyntaxException("Unexpected examples description element at " + exampleName + "/" + source + "/" + commandName + ":\n" + examplesElement.toString());
            }
            return examples;
        }
        throw new JsonSyntaxException("Unexpected examples element at " + source + "/" + commandName + ":\n" + examplesElement.toString());
    }

    private static List<Pair<String, String>> parseOptions(JsonElement optionsElement, String commandName, String source) {
        if (optionsElement == null) {
            return Collections.emptyList();
        }
        if (optionsElement instanceof JsonArray && optionsElement.getAsJsonArray().size() == 0) {
            return Collections.emptyList();
        }
        if (optionsElement instanceof JsonObject) {
            JsonObject optionsObject = (JsonObject)optionsElement;
            ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
            for (Map.Entry entry : optionsObject.entrySet()) {
                String optionName = (String)entry.getKey();
                JsonElement optionDescription = (JsonElement)entry.getValue();
                if (optionDescription.isJsonPrimitive()) {
                    options.add((Pair<String, String>)Pair.create((Object)optionName, (Object)optionDescription.getAsString()));
                    continue;
                }
                if (optionDescription.isJsonObject()) {
                    JsonElement descriptionElement = optionDescription.getAsJsonObject().get("description");
                    if (descriptionElement != null && descriptionElement.isJsonPrimitive()) {
                        options.add((Pair<String, String>)Pair.create((Object)optionName, (Object)descriptionElement.getAsString()));
                        continue;
                    }
                    if (descriptionElement == null) continue;
                    throw new JsonSyntaxException("Unexpected options/description element at " + optionName + "/" + source + "/" + commandName + ":\n" + optionDescription.toString());
                }
                if (optionDescription.isJsonNull()) {
                    options.add((Pair<String, String>)Pair.create((Object)optionName, (Object)""));
                    continue;
                }
                throw new JsonSyntaxException("Unexpected options description element at " + optionName + "/" + source + "/" + commandName + ":\n" + optionDescription.toString());
            }
            return options;
        }
        throw new JsonSyntaxException("Unexpected options element at " + source + "/" + commandName + ":\n" + optionsElement.toString());
    }

    private static List<String> parseCommandAliases(JsonElement aliasesElement, String source, String commandName) {
        if (aliasesElement == null) {
            return Collections.emptyList();
        }
        if (aliasesElement instanceof JsonArray) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (JsonElement aliasElement : (JsonArray)aliasesElement) {
                if (aliasElement.isJsonPrimitive()) {
                    String alias = aliasElement.getAsString();
                    if (commandName.equals(alias) || StringUtil.containsWhitespaces((CharSequence)alias)) continue;
                    aliases.add(alias);
                    continue;
                }
                throw new JsonSyntaxException("Unexpected aliases element at " + source + "/" + commandName + ":\n" + aliasElement.toString());
            }
            return aliases;
        }
        throw new JsonSyntaxException("Unexpected aliases element at " + source + "/" + commandName + ":\n" + aliasesElement.toString());
    }

    private static List<DrushParameter> parseParameters(JsonElement argumentsElement, String commandName, JsonObject commandJson, String source) {
        ArrayList<DrushParameter> parameters = new ArrayList<DrushParameter>();
        if (argumentsElement instanceof JsonObject) {
            int requiredNumber;
            JsonElement requiredArgumentsElement = commandJson.get("required-arguments");
            Set argumentsEntrySet = ((JsonObject)argumentsElement).entrySet();
            if (requiredArgumentsElement == null) {
                requiredNumber = argumentsEntrySet.size();
            } else if (requiredArgumentsElement.isJsonPrimitive() && requiredArgumentsElement.getAsJsonPrimitive().isNumber()) {
                requiredNumber = requiredArgumentsElement.getAsNumber().intValue();
            } else if (requiredArgumentsElement.isJsonPrimitive() && requiredArgumentsElement.getAsJsonPrimitive().isBoolean()) {
                requiredNumber = requiredArgumentsElement.getAsBoolean() ? argumentsEntrySet.size() : 0;
            } else {
                throw new JsonSyntaxException("Unexpected required-arguments at " + source + "/" + commandName + ":\n" + argumentsElement.toString());
            }
            int parameterNumber = 0;
            for (Map.Entry argumentEntry : argumentsEntrySet) {
                String parameterName = ((String)argumentEntry.getKey()).replaceAll(" ", "_");
                JsonElement value = (JsonElement)argumentEntry.getValue();
                JsonPrimitive descriptionPrimitive = null;
                if (value.isJsonPrimitive()) {
                    descriptionPrimitive = value.getAsJsonPrimitive();
                } else if (value.isJsonObject()) {
                    JsonElement description = value.getAsJsonObject().get("description");
                    if (description != null && description.isJsonPrimitive()) {
                        descriptionPrimitive = description.getAsJsonPrimitive();
                    } else {
                        JsonElement name = value.getAsJsonObject().get("name");
                        if (name != null && name.isJsonPrimitive()) {
                            descriptionPrimitive = name.getAsJsonPrimitive();
                        }
                    }
                }
                if (descriptionPrimitive == null) {
                    throw new JsonSyntaxException("Unexpected parameter description at " + source + "/" + commandName + "/" + parameterName + ":\n" + argumentEntry.toString());
                }
                String parameterDescription = descriptionPrimitive.getAsString();
                boolean isRequired = DrushUtils.isParameterRequired(value, parameterNumber, requiredNumber);
                parameters.add(new DrushParameter(parameterName, isRequired ? null : "null", parameterDescription));
                ++parameterNumber;
            }
        } else if (argumentsElement != null && !(argumentsElement instanceof JsonArray)) {
            throw new JsonSyntaxException("Unexpected arguments at " + source + "/" + commandName + ":\n" + argumentsElement.toString());
        }
        return parameters;
    }

    private static boolean isParameterRequired(@NotNull JsonElement value, int parameterNumber, int requiredNumber) {
        JsonElement requiredElement;
        boolean isRequired;
        if (value == null) {
            DrushUtils.$$$reportNull$$$0(30);
        }
        boolean bl = isRequired = parameterNumber < requiredNumber;
        if (value.isJsonObject() && (requiredElement = value.getAsJsonObject().get("is_required")) != null && requiredElement.isJsonPrimitive()) {
            return requiredElement.getAsBoolean();
        }
        return isRequired;
    }

    private static ScriptRunnerUtil.ScriptOutput getCommandsDescription(String drushPath, @Nullable Project project) throws ExecutionException {
        return FrameworkUtils.executeCommandWithFullOutput((String[])DrushUtils.getDescriptionCommand(drushPath), null, (Project)project, (boolean)true, (boolean)false);
    }

    @NotNull
    private static ScriptRunnerUtil.ScriptOutput getVersionDescription(@NotNull String drushPath, @Nullable Project project) throws ExecutionException {
        if (drushPath == null) {
            DrushUtils.$$$reportNull$$$0(31);
        }
        ScriptRunnerUtil.ScriptOutput scriptOutput = FrameworkUtils.executeCommandWithFullOutput((String[])new String[]{drushPath, "version", FORMAT_JSON_OPTION}, null, (Project)project, (boolean)true, (boolean)false);
        if (scriptOutput == null) {
            DrushUtils.$$$reportNull$$$0(32);
        }
        return scriptOutput;
    }

    @NotNull
    private static ScriptRunnerUtil.ScriptOutput getListCommandsDescription(@NotNull String drushPath, @Nullable Project project) throws ExecutionException {
        if (drushPath == null) {
            DrushUtils.$$$reportNull$$$0(33);
        }
        ScriptRunnerUtil.ScriptOutput scriptOutput = FrameworkUtils.executeCommandWithFullOutput((String[])new String[]{drushPath, "list"}, null, (Project)project, (boolean)true, (boolean)false);
        if (scriptOutput == null) {
            DrushUtils.$$$reportNull$$$0(34);
        }
        return scriptOutput;
    }

    @NotNull
    private static ScriptRunnerUtil.ScriptOutput getCommandDescription(@NotNull String drushPath, @NotNull String drushCommand, @Nullable Project project) throws ExecutionException {
        if (drushPath == null) {
            DrushUtils.$$$reportNull$$$0(35);
        }
        if (drushCommand == null) {
            DrushUtils.$$$reportNull$$$0(36);
        }
        ScriptRunnerUtil.ScriptOutput scriptOutput = FrameworkUtils.executeCommandWithFullOutput((String[])new String[]{drushPath, "help", drushCommand, FORMAT_JSON_OPTION}, null, (Project)project, (boolean)true, (boolean)false);
        if (scriptOutput == null) {
            DrushUtils.$$$reportNull$$$0(37);
        }
        return scriptOutput;
    }

    @NonNls
    private static String[] getDescriptionCommand(String drushPath) {
        return new String[]{drushPath, FORMAT_JSON_OPTION};
    }

    @NonNls
    @NotNull
    static FrameworkDescription getDrushFrameworkDescription(String drushPath) {
        if (((String)drushPath).contains(" ")) {
            drushPath = "\"" + (String)drushPath + "\"";
        }
        return new FrameworkDescription("Drush_" + FrameworkUtils.getCurrentFormattedDate(), (String)drushPath, "drush", true, "ws.drush", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 21, 25, 26, 28, 32, 34, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 1: 
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 6: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drushPath";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/drupal/clt/DrushUtils";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandDescription";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandJson";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drushCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/drupal/clt/DrushUtils";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrushVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCommandsSeparatelyFromList";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNamespaces";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCommandDescription";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandDefinition";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionDescription";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCommandsDescription";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkCommands";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "needsPerCommandHandling";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "needsCommandWithNamespacesHandling";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDrushVersion";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 37: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandsSeparatelyFromList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommandWord";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSeparateCommand";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandsJson";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandsFromJsonWithNamespaces";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseNamespaces";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandsFromJsonWithSourceKeys";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCommandDefinition";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAliasesElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isParameterRequired";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getVersionDescription";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getListCommandsDescription";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getCommandDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 21, 25, 26, 28, 32, 34, 37 -> new IllegalStateException(string);
        };
    }

    private static final class DrushParameter
    extends FrameworkCommand.Parameter {
        private final String myHelp;

        private DrushParameter(@NotNull String name, @NonNls @Nullable String defaultValue, @Nullable String help) {
            if (name == null) {
                DrushParameter.$$$reportNull$$$0(0);
            }
            super(name, defaultValue);
            this.myHelp = help;
        }

        private String getHelp() {
            return this.myHelp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/drupal/clt/DrushUtils$DrushParameter", "<init>"));
        }
    }
}

