/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.util.AsyncProducer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.debug.PhpDebugErrorDetector;
import com.jetbrains.php.phpunit.coverage.PhpCoverageResultManager;
import com.jetbrains.php.remote.PhpRemoteCommandLinePathProcessor;
import com.jetbrains.php.remote.PhpRemoteCredentialsProducer;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpCreateRemoteInterpreterDialog;
import com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterComponent;
import com.jetbrains.php.remote.tools.quality.QualityRemoteToolProcessHandler;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessHandler;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshCredentialsUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteInterpreterManagerImpl
extends PhpRemoteInterpreterManager {
    private static final Logger LOG = Logger.getInstance(PhpRemoteInterpreterManagerImpl.class);
    public static final String PHP_PREFIX = "php";

    @Nullable
    public PhpInterpreter addRemoteSdk(@NotNull Project project, @NotNull Supplier<? extends PhpInterpreter> producer) {
        PhpCreateRemoteInterpreterDialog dialog;
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        if (producer == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        if (!(dialog = new PhpCreateRemoteInterpreterDialog(project)).showAndGet()) {
            return null;
        }
        Sdk sdk = dialog.getSdk();
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (!(data instanceof PhpRemoteSdkAdditionalData)) {
            LOG.warn(PhpRemoteInterpreterManagerImpl.getRemoteInterpreterPluginIsDisabledErrorMessage());
            return null;
        }
        PhpRemoteSdkAdditionalData remoteData = (PhpRemoteSdkAdditionalData)data;
        PhpInterpreter interpreter = producer.get();
        interpreter.setPhpSdkAdditionalData((PhpSdkAdditionalData)remoteData);
        interpreter.setHomePath(remoteData.getSdkId());
        interpreter.setIsProjectLevel(true);
        return interpreter;
    }

    public void subscribeOnSshConfigsChanged(final @Nullable Project project) {
        MessageBus bus = project != null ? project.getMessageBus() : ApplicationManager.getApplication().getMessageBus();
        bus.connect().subscribe(SshConfigManager.SSH_CONFIGS, (Object)new SshConfigManager.Listener(){

            public void sshConfigsChanged() {
                SshConfigManager configManager = SshConfigManager.getInstance((Project)project);
                for (PhpInterpreter interpreter : PhpInterpretersManagerImpl.getInstance((Project)project).getInterpreters()) {
                    PhpSdkAdditionalData additionalData = interpreter.getPhpSdkAdditionalData();
                    RemoteSdkUtil.updateSshConfigData((SdkAdditionalData)additionalData, (SshConfigManager)configManager);
                }
            }
        });
    }

    public boolean producesSshSdkCredentials(@NotNull PhpSdkAdditionalData data) {
        PhpRemoteSdkAdditionalData remoteData;
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        return data instanceof PhpRemoteSdkAdditionalData && SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)(remoteData = (PhpRemoteSdkAdditionalData)data));
    }

    @NotNull
    public PhpSdkAdditionalData loadRemote(@Nullable Project project, @Nullable Element element, @NotNull Sdk interpreter) {
        if (interpreter == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = PhpRemoteSdkAdditionalData.loadRemote(interpreter, element, project);
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        return phpRemoteSdkAdditionalData;
    }

    public PhpInterpreterComponent createRemoteInterpreterEditor(@NotNull Project project, @NotNull String interpreterName, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
        }
        if (interpreterName == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        return new PhpRemoteInterpreterComponent(project, PhpRemoteInterpreterManagerImpl.getRemoteData(data), interpreterName);
    }

    @NotNull
    public ProcessOutput getProcessOutput(@NotNull Project project, @NotNull PhpSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, @NotNull @NlsContexts.ProgressTitle String title, @Nullable JComponent parent) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        if (commandLine == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
        }
        if (title == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        Ref exception = new Ref(null);
        Ref outputRef = new Ref(null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
                PhpRemoteProcessRunner runner = PhpRemoteProcessManager.getInstance(remoteData).getRemoteProcessRunner(remoteData);
                outputRef.set((Object)runner.getProcessOutput(project, remoteData, commandLine, title, parent));
            }
            catch (ExecutionException e) {
                exception.set((Object)e);
            }
            catch (InterruptedException | RuntimeException e) {
                exception.set((Object)new ExecutionException((Throwable)e));
            }
        }, title, true, project, parent);
        if (!exception.isNull()) {
            throw (ExecutionException)((Object)exception.get());
        }
        if (outputRef.isNull()) {
            throw new InterruptedException("process was interrupted");
        }
        ProcessOutput processOutput = (ProcessOutput)outputRef.get();
        if (processOutput == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
        }
        return processOutput;
    }

    @NotNull
    public PhpCommandLinePathProcessor createPathMapper(@NotNull Project project, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        return new PhpRemoteCommandLinePathProcessor(remoteData, this.createPathMappings(project, data));
    }

    @NotNull
    public PhpCommandSettings createPhpCommand(@NotNull Project project, @NotNull PhpSdkAdditionalData data) throws ExecutionException {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(16);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        String path = remoteData.getInterpreterPath();
        String validate = remoteData.validate(project, null);
        if (StringUtil.isNotEmpty((String)validate)) {
            throw new ExecutionException(validate);
        }
        PhpRemoteCommandLinePathProcessor pathProcessor = new PhpRemoteCommandLinePathProcessor(remoteData, this.createPathMappings(project, data));
        PhpCommandSettings phpCommandSettings = PhpCommandSettingsBuilder.create((String)path, (PhpCommandLinePathProcessor)pathProcessor, (PhpSdkAdditionalData)data);
        if (phpCommandSettings == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(17);
        }
        return phpCommandSettings;
    }

    @NotNull
    public ProcessHandler getRemoteProcessHandler(@NotNull Project project, @NotNull PhpSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, boolean verbose, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(18);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(19);
        }
        if (commandLine == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(20);
        }
        if (additionalMappings == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(21);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        PhpRemoteProcessRunner runner = PhpRemoteProcessManager.getInstance(remoteData).getRemoteProcessRunner(remoteData);
        Process process = runner.getRemoteProcess(project, remoteData, commandLine, additionalMappings);
        Object commandTitle = commandLine.getCommandLineString(remoteData.toPresentablePath());
        String additionalCommandTitle = runner.getAdditionalCommandTitle(commandLine);
        if (additionalCommandTitle != null) {
            commandTitle = (String)commandTitle + " [" + additionalCommandTitle + "]";
        }
        Charset charset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
        ProcessHandler processHandler = runner.createRemoteProcessHandler(process, (String)commandTitle, charset, remoteData, verbose);
        if (processHandler == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(22);
        }
        return processHandler;
    }

    @NotNull
    public ProcessHandler getRemoteToolProcessHandler(@NotNull Project project, @NotNull QualityToolMessageProcessor messageProcessor, @NotNull PhpSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(23);
        }
        if (messageProcessor == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(24);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(25);
        }
        if (commandLine == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(26);
        }
        if (additionalMappings == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(27);
        }
        try {
            Object object;
            PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
            PhpRemoteProcessRunner runner = PhpRemoteProcessManager.getInstance(remoteData).getRemoteProcessRunner(remoteData);
            Process process = runner.getRemoteBackgroundProcess(project, remoteData, commandLine, additionalMappings);
            String commandTitle = commandLine.getCommandLineString(remoteData.constructFullInterpreterPath(commandLine.getExePath()));
            if (process instanceof RemoteProcess) {
                RemoteProcess rp = (RemoteProcess)process;
                object = new QualityRemoteToolProcessHandler(rp, messageProcessor, commandTitle);
            } else {
                object = new QualityToolProcessHandler(process, messageProcessor, commandTitle);
            }
            return object;
        }
        catch (RemoteSdkException | InterruptedException e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    @NotNull
    public PathMappingSettings createPathMappings(@Nullable Project project, @NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(28);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        PathMappingSettings newMappingSettings = new PathMappingSettings();
        if (project != null) {
            RemoteMappingsManager.Mappings mappings = RemoteMappingsManager.getInstance((Project)project).getForServer(PHP_PREFIX, data.getInterpreterId());
            if (mappings != null) {
                newMappingSettings.addAll(mappings.getSettings());
            }
            for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)remoteData)) {
                PathMappingSettings settings = mappingProvider.getPathMappingSettings(project, (RemoteSdkAdditionalData)remoteData);
                newMappingSettings.addAll(settings);
            }
        }
        PathMappingSettings pathMappingSettings = newMappingSettings;
        if (pathMappingSettings == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(29);
        }
        return pathMappingSettings;
    }

    @NotNull
    public String getPathMappingsSource(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(30);
        }
        PhpRemoteSdkAdditionalData remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data);
        SmartList locations = new SmartList();
        for (PathMappingProvider mappingProvider : PathMappingProvider.getSuitableMappingProviders((RemoteSdkAdditionalData)remoteData)) {
            locations.add((Object)mappingProvider.getProviderPresentableName((RemoteSdkAdditionalData)remoteData));
        }
        String string = StringUtil.join((Collection)locations, (String)" or ");
        if (string == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static PhpRemoteSdkAdditionalData getRemoteData(PhpSdkAdditionalData data) {
        assert (data instanceof PhpRemoteSdkAdditionalData) : "Remote Interpreter data expected instead of: " + data.getClass();
        return (PhpRemoteSdkAdditionalData)data;
    }

    public static boolean supportRemoteBrowseAction(@NotNull PhpRemoteSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(32);
        }
        try {
            return SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)data);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @NotNull
    public ActionListener createRemoteBrowserAction(@Nullable Project project, @NotNull PhpSdkAdditionalData data, @NotNull @NlsContexts.DialogTitle String title, @NotNull JTextField textField, boolean withFoldersOnly) throws PhpInvalidSdkTypeException {
        PhpRemoteSdkAdditionalData remoteData;
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(33);
        }
        if (title == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(34);
        }
        if (textField == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(35);
        }
        if (!SshCredentialsUtil.producesSshSdkCredentials((RemoteSdkAdditionalData)(remoteData = PhpRemoteInterpreterManagerImpl.getRemoteData(data)))) {
            throw new PhpInvalidSdkTypeException(PhpBundle.message((String)"remote.interpreter.browse.action.is.not.supported.for.docker", (Object[])new Object[0]));
        }
        PhpRemoteCredentialsProducer producer = new PhpRemoteCredentialsProducer(project, PhpRemoteInterpreterManagerImpl.getRemoteData(data));
        RemoteBrowseActionListener remoteBrowseActionListener = new RemoteBrowseActionListener(textField, title, (AsyncProducer)producer).withFoldersOnly(withFoldersOnly);
        if (remoteBrowseActionListener == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(36);
        }
        return remoteBrowseActionListener;
    }

    public String getRemoteHost(@NotNull Project project, @NotNull String interpreterName, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(37);
        }
        if (interpreterName == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(38);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(39);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).getRemoteHost(project, interpreterName, remote);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public PhpSdkHelpersManager getHelpersManager(@NotNull PhpSdkAdditionalData data) throws ExecutionException {
        PhpSdkHelpersManager phpSdkHelpersManager;
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(40);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            phpSdkHelpersManager = PhpRemoteProcessManager.getInstance(remote).getSdkHelpersManager(remote);
        } else {
            phpSdkHelpersManager = null;
        }
        return phpSdkHelpersManager;
    }

    @Nullable
    public PhpCoverageResultManager getCoverageResultManager(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(41);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).getCoverageResultManager(remote);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public PhpSdkFileTransfer getSdkFileTransfer(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(42);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).getSdkFileTransfer(remote);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    public void replaceWithPhpDbg(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(43);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote;
            String path = (remote = (PhpRemoteSdkAdditionalData)data).getInterpreterPath();
            String parentPath = PathUtil.getParentPath((String)path);
            remote.setInterpreterPath((String)(StringUtil.isEmpty((String)parentPath) ? "" : parentPath + "/") + PathUtil.getFileName((String)path).replace(PHP_PREFIX, "phpdbg"));
        }
    }

    public String escape(@NotNull PhpSdkAdditionalData data, @NotNull String path) {
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(44);
        }
        if (path == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(45);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).escape(path);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return StringUtil.escapeBackSlashes((String)path);
    }

    @Nullable
    public PhpDebugErrorDetector newErrorDetector(@NotNull Project project, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(46);
        }
        if (data == null) {
            PhpRemoteInterpreterManagerImpl.$$$reportNull$$$0(47);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            PhpRemoteSdkAdditionalData remote = (PhpRemoteSdkAdditionalData)data;
            try {
                return PhpRemoteProcessManager.getInstance(remote).newErrorDetector(project, remote);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 17, 22, 29, 31, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: 
            case 12: 
            case 17: 
            case 22: 
            case 29: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/PhpRemoteInterpreterManagerImpl";
                break;
            }
            case 6: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 10: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMappings";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteInterpreterManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemote";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createPhpCommand";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteProcessHandler";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMappings";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappingsSource";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteBrowserAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteSdk";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "producesSshSdkCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadRemote";
                break;
            }
            case 4: 
            case 12: 
            case 17: 
            case 22: 
            case 29: 
            case 31: 
            case 36: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteInterpreterEditor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPathMapper";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createPhpCommand";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcessHandler";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteToolProcessHandler";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createPathMappings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingsSource";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "supportRemoteBrowseAction";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteBrowserAction";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteHost";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersManager";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageResultManager";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSdkFileTransfer";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithPhpDbg";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "newErrorDetector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 17, 22, 29, 31, 36 -> new IllegalStateException(string);
        };
    }
}

