/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.ui.RemoteSdkUpdatedCallback;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import javax.swing.JComponent;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteSshHelpersManager
extends PhpSdkHelpersManager {
    private static final RemoteSdkUpdatedCallback EMPTY_CALLBACK = sdkProperties -> {};
    private final PhpRemoteSdkAdditionalData mySdkData;

    public PhpRemoteSshHelpersManager(PhpRemoteSdkAdditionalData sdkData) {
        this.mySdkData = sdkData;
    }

    @Nullable
    public String getHelperScript(@NotNull String scriptName, @NotNull Class<?> resourceHolder) {
        if (scriptName == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(0);
        }
        if (resourceHolder == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(1);
        }
        return StringUtil.isEmpty((String)this.mySdkData.getHelpersPath()) ? null : this.mySdkData.getHelpersPath() + "/" + scriptName;
    }

    public void update(@NotNull Project project, @Nullable JComponent parentComponent) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(2);
        }
        RemoteCredentials credentials = this.mySdkData.getRemoteCredentials(project, false);
        String title = PhpRemoteSdkBundle.message("validation.ssh.connecting.to.remote.host.title", credentials.getHost());
        try {
            RemoteSdkUpdatedCallback callback;
            Object object = callback = StringUtil.isEmpty((String)this.mySdkData.getHelpersPath()) ? EMPTY_CALLBACK : null;
            if (!RemoteSdkUtil.testConnectionAndCreateHelpersPath((Project)project, (RemoteCredentials)credentials, (RemoteSdkProperties)this.mySdkData, (String)title, (RemoteSdkUpdatedCallback)callback)) {
                String fullInterpreterPath = RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)credentials, (RemoteSdkProperties)this.mySdkData);
                throw new ExecutionException(PhpRemoteSdkBundle.message("validation.ssh.can.not.connect.to.remote.host", fullInterpreterPath));
            }
        }
        catch (FileSystemException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (StringUtil.isEmpty((String)this.mySdkData.getHelpersPath())) {
            String fullInterpreterPath = RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)credentials, (RemoteSdkProperties)this.mySdkData);
            throw new ExecutionException(PhpRemoteSdkBundle.message("validation.ssh.can.not.connect.to.remote.host", fullInterpreterPath));
        }
        new PhpRemoteTransfer(project, parentComponent, credentials, (RemoteSdkProperties)this.mySdkData).uploadHelpers();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteSshHelpersManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelperScript";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

