/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.behat.BehatBundle;
import com.jetbrains.php.behat.steps.BehatPatternExtractor;
import com.jetbrains.php.behat.steps.generation.BehatForceStepDefinitionsSnippetProvider;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddAttributeQuickFixBase;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRemoveDocTagQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BehatDocStepCanBeConvertedToAttributeInspection
extends PhpInspection {
    private static final String BEHAT_STEP_NAMESPACE = "\\Behat\\Step\\";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BehatDocStepCanBeConvertedToAttributeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpDocTag(PhpDocTag tag) {
                String stepName = BehatDocStepCanBeConvertedToAttributeInspection.getStepName(tag);
                if (!BehatForceStepDefinitionsSnippetProvider.STEP_DEFINITION_KEYWORDS.contains(stepName)) {
                    return;
                }
                PhpDocComment comment = (PhpDocComment)ObjectUtils.tryCast((Object)tag.getParent(), PhpDocComment.class);
                if (comment == null || !(comment.getOwner() instanceof Method)) {
                    return;
                }
                if (!BehatDocStepCanBeConvertedToAttributeInspection.behatStepAttributeExists(stepName, holder)) {
                    return;
                }
                String attributeText = BehatDocStepCanBeConvertedToAttributeInspection.getAttributeTextPresentable(tag);
                if (attributeText != null) {
                    holder.registerProblem((PsiElement)comment, tag.getTextRangeInParent(), BehatBundle.message("inspection.message.can.be.replaced.with", attributeText), new LocalQuickFix[]{new BehatReplaceStepDocCommentWithAttributeQuickFix(tag)});
                }
            }
        };
    }

    private static boolean behatStepAttributeExists(String keyword, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            BehatDocStepCanBeConvertedToAttributeInspection.$$$reportNull$$$0(1);
        }
        return !PhpIndex.getInstance((Project)holder.getProject()).getAnyByFQN(BEHAT_STEP_NAMESPACE + keyword).isEmpty();
    }

    @Nullable
    private static String getAttributeTextPresentable(PhpDocTag tag) {
        return BehatDocStepCanBeConvertedToAttributeInspection.getAttributeListText(tag, BehatDocStepCanBeConvertedToAttributeInspection.getStepName(tag));
    }

    @NotNull
    private static String getStepName(PhpDocTag tag) {
        String string = StringUtil.trimStart((String)tag.getName(), (String)"@");
        if (string == null) {
            BehatDocStepCanBeConvertedToAttributeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static String getAttributeListText(PhpDocTag tag, String name) {
        String text = BehatDocStepCanBeConvertedToAttributeInspection.getAttributeText(tag, name);
        return text != null ? "#[" + text + "]" : null;
    }

    @Nullable
    private static String getAttributeText(PhpDocTag tag, String name) {
        String pattern = BehatPatternExtractor.extractPatternText(tag);
        if (pattern == null) {
            return null;
        }
        return "%s('%s')".formatted(name, pattern);
    }

    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/BehatDocStepCanBeConvertedToAttributeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/BehatDocStepCanBeConvertedToAttributeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "behatStepAttributeExists";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class BehatReplaceStepDocCommentWithAttributeQuickFix
    extends LocalQuickFixOnPsiElement {
        protected BehatReplaceStepDocCommentWithAttributeQuickFix(@NotNull PhpDocTag element) {
            if (element == null) {
                BehatReplaceStepDocCommentWithAttributeQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        @NotNull
        public String getText() {
            PsiElement psiElement = this.getStartElement();
            if (psiElement instanceof PhpDocTag) {
                PhpDocTag tag = (PhpDocTag)psiElement;
                String attributeText = BehatDocStepCanBeConvertedToAttributeInspection.getAttributeTextPresentable(tag);
                String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{attributeText});
                if (string == null) {
                    BehatReplaceStepDocCommentWithAttributeQuickFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = this.getFamilyName();
            if (string == null) {
                BehatReplaceStepDocCommentWithAttributeQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement docTag, @NotNull PsiElement endElement) {
            PsiElement psiElement;
            PhpDocComment comment;
            if (project == null) {
                BehatReplaceStepDocCommentWithAttributeQuickFix.$$$reportNull$$$0(3);
            }
            if (file == null) {
                BehatReplaceStepDocCommentWithAttributeQuickFix.$$$reportNull$$$0(4);
            }
            if (docTag == null) {
                BehatReplaceStepDocCommentWithAttributeQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                BehatReplaceStepDocCommentWithAttributeQuickFix.$$$reportNull$$$0(6);
            }
            if ((comment = (PhpDocComment)PhpPsiUtil.getParentOfClass((PsiElement)docTag, PhpDocComment.class)) != null && (psiElement = comment.getOwner()) instanceof PhpAttributesOwner) {
                PhpAttributesOwner attributesOwner = (PhpAttributesOwner)psiElement;
                BehatReplaceStepDocCommentWithAttributeQuickFix.addStepAttribute((PhpDocTag)docTag, attributesOwner);
                PhpRemoveDocTagQuickFix.remove((PhpDocTag)((PhpDocTag)docTag));
            }
        }

        private static void addStepAttribute(PhpDocTag docTag, PhpAttributesOwner attributesOwner) {
            String attributeText = BehatDocStepCanBeConvertedToAttributeInspection.BEHAT_STEP_NAMESPACE + BehatDocStepCanBeConvertedToAttributeInspection.getStepName(docTag);
            PhpAddAttributeQuickFixBase.addAttribute((PhpAttributesOwner)attributesOwner, (String)Objects.requireNonNull(BehatDocStepCanBeConvertedToAttributeInspection.getAttributeText(docTag, attributeText)));
        }

        @NotNull
        public String getFamilyName() {
            String string = BehatBundle.message("intention.family.name.replace.with.attribute.step", new Object[0]);
            if (string == null) {
                BehatReplaceStepDocCommentWithAttributeQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/behat/BehatDocStepCanBeConvertedToAttributeInspection$BehatReplaceStepDocCommentWithAttributeQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docTag";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/behat/BehatDocStepCanBeConvertedToAttributeInspection$BehatReplaceStepDocCommentWithAttributeQuickFix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 7 -> new IllegalStateException(string);
            };
        }
    }
}

