/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps.generation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.php.behat.ContextInterfaceProvider;
import com.jetbrains.php.behat.steps.generation.BehatMultilineArgument;
import com.jetbrains.php.behat.steps.generation.BehatStepDefinitionsSnippetProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;

public class BehatForceStepDefinitionsSnippetProvider
implements BehatStepDefinitionsSnippetProvider {
    private static final Logger LOG = Logger.getInstance(BehatForceStepDefinitionsSnippetProvider.class);
    public static final Set<String> STEP_DEFINITION_KEYWORDS = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("Given", "When", "Then"));
    private static final String ESCAPED_PARAM_PATTERN = "(<[^>]*>)|(\\d+)[ ,.]|(\"([^\\\\\"]*)\")|('([^\\\\']*)')";
    private static final String FULL_ESCAPED_PARAM_PATTERN = "(<[^>]*>)|(\\d+)[ ,.]|(\"([^\\\\\"]*)\")|('([^\\\\']*)')|(\\$)";
    private static final Pattern ESCAPED_PARAM_REGEXP = Pattern.compile("(<[^>]*>)|(\\d+)[ ,.]|(\"([^\\\\\"]*)\")|('([^\\\\']*)')");
    private static final String[][] REPLACE_PATTERNS = new String[][]{{"\\\\", "\\\\\\\\"}, {"\\|", "\\\\|"}, {"\\$", "\\\\\\$"}, {"\\^", "\\\\^"}, {"\\+", "\\+"}, {"\\-", "\\\\-"}, {"\\#", "\\\\#"}, {"\\?", "\\\\?"}, {"\\*", "\\\\*"}, {"\\{", "\\\\{"}, {"\\}", "\\\\}"}, {"\\[", "\\\\["}, {"\\]", "\\\\]"}, {"\\(", "\\\\("}, {"\\)", "\\\\)"}, {"\\+", "\\\\+"}, {"'([^\\\\']*)'", "\\\\'([^\\\\']*)\\\\'"}, {"\"([^\\\\\"]*)\"", "\"([^\"]*)\""}, {"\\/", "\\\\/"}, {"(?<=^|[ .,])\\d+[ ]", "(\\\\d+) "}, {"(?<=^|[ .,])\\d+[,]", "(\\\\d+),"}, {"(?<=^|[ .,])\\d+[.]", "(\\\\d+)."}, {"(?<=^|[ .,])\\d+$", "(\\\\d+)"}, {"\\.", "\\\\."}, {"(<[^>]*>)", "(.*)"}};
    private static final String FORMAT = "/**\n* @%s /^%s$/\n */\npublic function %s(%s) {\nthrow new %s();\n}";
    private static final String DEFAULT_METHOD_NAME = "stepDefinition";
    private static final String ARGUMENT_TEMPLATE = "$arg";
    public static final String DEFAULT_KEYWORD = "Given";

    protected static String snippetText(@NotNull String stepKeyword, @NotNull String stepName, @Nullable BehatMultilineArgument multilineArgName, @NotNull Set<String> occupiedMethodNames, @NotNull Project project) {
        if (stepKeyword == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(0);
        }
        if (stepName == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(1);
        }
        if (occupiedMethodNames == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(3);
        }
        String escaped = Pattern.quote(stepName);
        escaped = StringUtil.trimEnd((String)StringUtil.trimStart((String)escaped, (String)"\\Q"), (String)"\\E");
        escaped = BehatForceStepDefinitionsSnippetProvider.prepareStepRegexp(escaped);
        ArrayList<Object> arguments = new ArrayList<Object>();
        Matcher m = ESCAPED_PARAM_REGEXP.matcher(StringUtil.newBombedCharSequence((CharSequence)(stepName + " "), (long)1000L));
        int counter = 1;
        while (m.find()) {
            String argument = m.group();
            if (argument.startsWith("<")) {
                arguments.add("$" + argument.substring(1, argument.length() - 1));
                continue;
            }
            arguments.add(ARGUMENT_TEMPLATE + counter);
            ++counter;
        }
        if (multilineArgName != null) {
            arguments.add(multilineArgName.getPresentableName());
        }
        Object methodName = BehatForceStepDefinitionsSnippetProvider.suggestMethodName(stepName);
        int count = 1;
        String lowerCase = StringUtil.toLowerCase((String)methodName);
        if (occupiedMethodNames.contains(lowerCase)) {
            while (occupiedMethodNames.contains(lowerCase + count)) {
                ++count;
            }
            methodName = (String)methodName + count;
        }
        return String.format(FORMAT, stepKeyword, escaped, methodName, arguments.size() > 0 ? StringUtil.join(arguments, (String)", ") : "", ContextInterfaceProvider.chooseDummyStepException(project));
    }

    @NotNull
    private static String suggestMethodName(@NotNull String stepName) {
        String functionNameTemplate;
        List words;
        if (stepName == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(4);
        }
        if ((words = StringUtil.getWordsIn((String)(functionNameTemplate = stepName + " ").replaceAll(FULL_ESCAPED_PARAM_PATTERN, ""))).isEmpty()) {
            return DEFAULT_METHOD_NAME;
        }
        Object functionName = StringUtil.notNullize((String)StringUtil.toLowerCase((String)((String)words.get(0))));
        for (int i = 1; i < words.size(); ++i) {
            functionName = (String)functionName + StringUtil.capitalize((String)((String)words.get(i)));
        }
        if (!PhpLangUtil.isPhpIdentifier((String)functionName)) {
            LOG.error("Generated function name is invalid identifier: " + (String)functionName);
            return DEFAULT_METHOD_NAME;
        }
        String string = functionName;
        if (string == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String prepareStepRegexp(String stepName) {
        String result = stepName;
        for (String[] rule : REPLACE_PATTERNS) {
            result = result.replaceAll(rule[0], rule[1]);
        }
        return result;
    }

    @Override
    public String makeSnippet(@NotNull GherkinStep step, @NotNull String stepKeyword, @NotNull String stepName, @Nullable BehatMultilineArgument multilineArgName, @NotNull Set<String> occupiedMethodNames) {
        if (step == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(6);
        }
        if (stepKeyword == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(7);
        }
        if (stepName == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(8);
        }
        if (occupiedMethodNames == null) {
            BehatForceStepDefinitionsSnippetProvider.$$$reportNull$$$0(9);
        }
        if (!STEP_DEFINITION_KEYWORDS.contains(StringUtil.toLowerCase((String)stepKeyword))) {
            stepKeyword = DEFAULT_KEYWORD;
        }
        return BehatForceStepDefinitionsSnippetProvider.snippetText(stepKeyword, stepName, multilineArgName, occupiedMethodNames, step.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepKeyword";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occupiedMethodNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/steps/generation/BehatForceStepDefinitionsSnippetProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/steps/generation/BehatForceStepDefinitionsSnippetProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "snippetText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestMethodName";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeSnippet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

