/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps.generation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.behat.steps.generation.BehatForceStepDefinitionsSnippetProvider;
import com.jetbrains.php.behat.steps.generation.BehatMultilineArgument;
import com.jetbrains.php.behat.steps.generation.BehatStepDefinitionsSnippetProvider;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinPystring;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public final class BehatStepDefinitionsFactory {
    private static final BehatStepDefinitionsSnippetProvider myProvider = new BehatForceStepDefinitionsSnippetProvider();
    private static final Logger LOG = Logger.getInstance(BehatStepDefinitionsFactory.class);
    private static final BehatStepDefinitionsFactory myInstance = new BehatStepDefinitionsFactory();
    private static final String TO_STRING_CELL_DELIMITER = ", ";
    private static final String TABLE_TO_STRING_PREFIX = "table.hashes.keys # => [";

    private BehatStepDefinitionsFactory() {
    }

    public static BehatStepDefinitionsFactory getInstance() {
        return myInstance;
    }

    public String makeSnippet(@NotNull GherkinStep step, @NotNull Set<String> occupiedMethodNames) {
        GherkinKeywordProvider keywordProvider;
        String baseKeyword;
        if (step == null) {
            BehatStepDefinitionsFactory.$$$reportNull$$$0(0);
        }
        if (occupiedMethodNames == null) {
            BehatStepDefinitionsFactory.$$$reportNull$$$0(1);
        }
        String keyword = (baseKeyword = (keywordProvider = JsonGherkinKeywordProvider.getKeywordProvider((PsiElement)step)).getBaseKeyword("en", step.getKeyword().getText())) == null ? "When" : baseKeyword;
        String stepName = step.getName();
        BehatMultilineArgument multilineArgClass = BehatStepDefinitionsFactory.getMultiLineArgClass(step);
        try {
            return myProvider.makeSnippet(step, keyword, stepName, multilineArgClass, occupiedMethodNames);
        }
        catch (Throwable e) {
            LOG.warn("Snippet provider wasn't able to process keyword=[" + keyword + "], stepName=[" + stepName + "], multilineArg=[" + multilineArgClass + "]. Exception message: " + e.getMessage() + "(" + e.getClass().getName() + ").Default dummy implementation will be used", e);
            return BehatStepDefinitionsFactory.generateStupidDefinition(keyword, stepName);
        }
    }

    @Nullable
    private static BehatMultilineArgument getMultiLineArgClass(@NotNull GherkinStep step) {
        GherkinPystring pystring;
        if (step == null) {
            BehatStepDefinitionsFactory.$$$reportNull$$$0(2);
        }
        if ((pystring = step.getPystring()) != null) {
            return new BehatMultilineArgument(BehatMultilineArgument.Type.PY_STRING_NODE, pystring.getText());
        }
        GherkinTable table = step.getTable();
        if (table != null) {
            GherkinTableRow headerRowElement = table.getHeaderRow();
            StringBuilder sb = new StringBuilder(TABLE_TO_STRING_PREFIX);
            if (headerRowElement != null && headerRowElement.getPsiCells().size() > 0) {
                boolean smthAdded = false;
                for (GherkinTableCell cell : headerRowElement.getPsiCells()) {
                    String cellName = cell.getName();
                    if (cellName == null || cellName.length() <= 0) continue;
                    smthAdded = true;
                    sb.append(':').append(cellName).append(TO_STRING_CELL_DELIMITER);
                }
                if (smthAdded) {
                    sb.delete(sb.length() - TO_STRING_CELL_DELIMITER.length(), sb.length());
                }
            }
            sb.append("]");
            return new BehatMultilineArgument(BehatMultilineArgument.Type.TABLE_NODE, sb.toString());
        }
        return null;
    }

    private static String generateStupidDefinition(@NotNull String keyword, @NotNull String stepName) {
        if (keyword == null) {
            BehatStepDefinitionsFactory.$$$reportNull$$$0(3);
        }
        if (stepName == null) {
            BehatStepDefinitionsFactory.$$$reportNull$$$0(4);
        }
        String regexpText = "/^" + StringUtil.escapeToRegexp((String)stepName) + "$/";
        return "/**\n* @" + keyword + " " + regexpText + "\n */\npublic function stepDefinition() {\nthrow new PendingException();\n}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occupiedMethodNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/behat/steps/generation/BehatStepDefinitionsFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "makeSnippet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMultiLineArgClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateStupidDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

