/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.api;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import ru.adelf.idea.dotenv.DotEnvSettings;
import ru.adelf.idea.dotenv.api.EnvironmentVariablesProvider;
import ru.adelf.idea.dotenv.api.EnvironmentVariablesUsagesProvider;
import ru.adelf.idea.dotenv.api.FileAcceptResult;
import ru.adelf.idea.dotenv.indexing.DotEnvKeyValuesIndex;
import ru.adelf.idea.dotenv.util.EnvironmentVariablesProviderUtil;
import ru.adelf.idea.dotenv.util.EnvironmentVariablesUtil;

public class EnvironmentVariablesApi {
    @NotNull
    public static Map<String, String> getAllKeyValues(Project project) {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        HashMap keyValues = new HashMap();
        HashMap<String, String> secondaryKeyValues = new HashMap<String, String>();
        HashMap resultsCache = new HashMap();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        boolean showValues = DotEnvSettings.getInstance().storeValues;
        fileBasedIndex.processAllKeys(DotEnvKeyValuesIndex.KEY, key -> {
            for (VirtualFile virtualFile : fileBasedIndex.getContainingFiles(DotEnvKeyValuesIndex.KEY, key, scope)) {
                FileAcceptResult fileAcceptResult;
                if (resultsCache.containsKey(virtualFile)) {
                    fileAcceptResult = (FileAcceptResult)resultsCache.get(virtualFile);
                } else {
                    fileAcceptResult = EnvironmentVariablesApi.getFileAcceptResult(virtualFile);
                    resultsCache.put(virtualFile, fileAcceptResult);
                }
                if (!fileAcceptResult.isAccepted()) continue;
                fileBasedIndex.processValues(DotEnvKeyValuesIndex.KEY, key, virtualFile, (file, val) -> {
                    String keyValue = val;
                    if (!showValues) {
                        keyValue = "";
                    }
                    if (fileAcceptResult.isPrimary()) {
                        keyValues.putIfAbsent(key, keyValue);
                    } else {
                        secondaryKeyValues.putIfAbsent((String)key, keyValue);
                    }
                    return true;
                }, scope);
            }
            return true;
        }, project);
        secondaryKeyValues.putAll(keyValues);
        HashMap<String, String> hashMap = secondaryKeyValues;
        if (hashMap == null) {
            EnvironmentVariablesApi.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @NotNull
    public static PsiElement[] getKeyDeclarations(Project project, String key) {
        ArrayList targets = new ArrayList();
        ArrayList secondaryTargets = new ArrayList();
        FileBasedIndex.getInstance().getFilesWithKey(DotEnvKeyValuesIndex.KEY, new HashSet<String>(Collections.singletonList(key)), virtualFile -> {
            PsiFile psiFileTarget = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFileTarget == null) {
                return true;
            }
            for (EnvironmentVariablesProvider provider : EnvironmentVariablesProviderUtil.getEnvVariablesProviders()) {
                FileAcceptResult fileAcceptResult = provider.acceptFile((VirtualFile)virtualFile);
                if (!fileAcceptResult.isAccepted()) continue;
                (fileAcceptResult.isPrimary() ? targets : secondaryTargets).addAll(EnvironmentVariablesUtil.getElementsByKey(key, provider.getElements(psiFileTarget)));
            }
            return true;
        }, GlobalSearchScope.allScope((Project)project));
        PsiElement[] psiElementArray = (!targets.isEmpty() ? targets : secondaryTargets).toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            EnvironmentVariablesApi.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @NotNull
    public static PsiElement[] getKeyUsages(Project project, String key) {
        ArrayList targets = new ArrayList();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        Processor psiFileProcessor = psiFile -> {
            for (EnvironmentVariablesUsagesProvider provider : EnvironmentVariablesProviderUtil.getEnvVariablesUsagesProviders()) {
                targets.addAll(EnvironmentVariablesUtil.getUsagesElementsByKey(key, provider.getUsages((PsiFile)psiFile)));
            }
            return true;
        };
        searchHelper.processAllFilesWithWord(key, GlobalSearchScope.allScope((Project)project), psiFileProcessor, true);
        searchHelper.processAllFilesWithWordInLiterals(key, GlobalSearchScope.allScope((Project)project), psiFileProcessor);
        searchHelper.processAllFilesWithWordInText(key, GlobalSearchScope.allScope((Project)project), psiFileProcessor, true);
        PsiElement[] psiElementArray = targets.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            EnvironmentVariablesApi.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    private static FileAcceptResult getFileAcceptResult(VirtualFile virtualFile) {
        for (EnvironmentVariablesProvider provider : EnvironmentVariablesProviderUtil.getEnvVariablesProviders()) {
            FileAcceptResult fileAcceptResult = provider.acceptFile(virtualFile);
            if (!fileAcceptResult.isAccepted()) continue;
            return fileAcceptResult;
        }
        return FileAcceptResult.NOT_ACCEPTED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ru/adelf/idea/dotenv/api/EnvironmentVariablesApi";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeyValues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDeclarations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyUsages";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

