/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.DotEnvPsiElementsVisitor;
import ru.adelf.idea.dotenv.models.KeyValuePsiElement;
import ru.adelf.idea.dotenv.psi.DotEnvFile;

public class DuplicateKeyInspection
extends LocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return "Duplicate key";
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof DotEnvFile)) {
            return null;
        }
        return this.analyzeFile(file, manager, isOnTheFly).getResultsArray();
    }

    @NotNull
    private ProblemsHolder analyzeFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(3);
        }
        DotEnvPsiElementsVisitor visitor = new DotEnvPsiElementsVisitor();
        file.acceptChildren((PsiElementVisitor)visitor);
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        HashMap<String, PsiElement> existingKeys = new HashMap<String, PsiElement>();
        HashSet<PsiElement> markedElements = new HashSet<PsiElement>();
        for (KeyValuePsiElement keyValue : visitor.getCollectedItems()) {
            String key = keyValue.getKey();
            if (existingKeys.containsKey(key)) {
                problemsHolder.registerProblem(keyValue.getElement(), "Duplicate key", new LocalQuickFix[0]);
                PsiElement markedElement = (PsiElement)existingKeys.get(key);
                if (markedElements.contains(markedElement)) continue;
                problemsHolder.registerProblem(markedElement, "Duplicate key", new LocalQuickFix[0]);
                markedElements.add(markedElement);
                continue;
            }
            existingKeys.put(key, keyValue.getElement());
        }
        ProblemsHolder problemsHolder2 = problemsHolder;
        if (problemsHolder2 == null) {
            DuplicateKeyInspection.$$$reportNull$$$0(4);
        }
        return problemsHolder2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ru/adelf/idea/dotenv/inspections/DuplicateKeyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ru/adelf/idea/dotenv/inspections/DuplicateKeyInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

