/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.DotEnvFactory;
import ru.adelf.idea.dotenv.psi.DotEnvFile;

public class ExtraBlankLineInspection
extends LocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return "Extra blank line";
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ExtraBlankLineInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ExtraBlankLineInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof DotEnvFile)) {
            return null;
        }
        return this.analyzeFile(file, manager, isOnTheFly).getResultsArray();
    }

    @NotNull
    private ProblemsHolder analyzeFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ExtraBlankLineInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            ExtraBlankLineInspection.$$$reportNull$$$0(3);
        }
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiWhiteSpaceImpl.class).forEach(whiteSpace -> {
            Pattern pattern = Pattern.compile("\r\n|\r|\n");
            Matcher matcher = pattern.matcher(whiteSpace.getText());
            int count = 0;
            while (matcher.find()) {
                ++count;
            }
            if (count > 2) {
                problemsHolder.registerProblem((PsiElement)whiteSpace, "Only one extra line allowed between properties", new LocalQuickFix[]{new RemoveExtraBlankLineQuickFix()});
            }
        });
        ProblemsHolder problemsHolder2 = problemsHolder;
        if (problemsHolder2 == null) {
            ExtraBlankLineInspection.$$$reportNull$$$0(4);
        }
        return problemsHolder2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ru/adelf/idea/dotenv/inspections/ExtraBlankLineInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ru/adelf/idea/dotenv/inspections/ExtraBlankLineInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class RemoveExtraBlankLineQuickFix
    implements LocalQuickFix {
        private RemoveExtraBlankLineQuickFix() {
        }

        @NotNull
        public String getName() {
            return "Remove extra blank line";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveExtraBlankLineQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                RemoveExtraBlankLineQuickFix.$$$reportNull$$$0(1);
            }
            try {
                PsiElement psiElement = descriptor.getPsiElement();
                PsiElement newPsiElement = DotEnvFactory.createFromText(project, TokenType.WHITE_SPACE, "\n\n");
                psiElement.replace(newPsiElement);
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance(ExtraBlankLineInspection.class).error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                RemoveExtraBlankLineQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ru/adelf/idea/dotenv/inspections/ExtraBlankLineInspection$RemoveExtraBlankLineQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ru/adelf/idea/dotenv/inspections/ExtraBlankLineInspection$RemoveExtraBlankLineQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

