/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.DotEnvFactory;
import ru.adelf.idea.dotenv.psi.DotEnvFile;
import ru.adelf.idea.dotenv.psi.DotEnvTypes;
import ru.adelf.idea.dotenv.psi.impl.DotEnvKeyImpl;

public class IncorrectDelimiterInspection
extends LocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return "Incorrect delimiter";
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            IncorrectDelimiterInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            IncorrectDelimiterInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof DotEnvFile)) {
            return null;
        }
        return this.analyzeFile(file, manager, isOnTheFly).getResultsArray();
    }

    @NotNull
    private ProblemsHolder analyzeFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            IncorrectDelimiterInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            IncorrectDelimiterInspection.$$$reportNull$$$0(3);
        }
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        PsiTreeUtil.findChildrenOfType((PsiElement)file, DotEnvKeyImpl.class).forEach(key -> {
            if (key.getText().contains("-")) {
                problemsHolder.registerProblem((PsiElement)key, "Expected: '_' Found: '-'", new LocalQuickFix[0]);
            }
        });
        ProblemsHolder problemsHolder2 = problemsHolder;
        if (problemsHolder2 == null) {
            IncorrectDelimiterInspection.$$$reportNull$$$0(4);
        }
        return problemsHolder2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ru/adelf/idea/dotenv/inspections/IncorrectDelimiterInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ru/adelf/idea/dotenv/inspections/IncorrectDelimiterInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class ReplaceDelimiterQuickFix
    implements LocalQuickFix {
        private ReplaceDelimiterQuickFix() {
        }

        @NotNull
        public String getName() {
            return "Replace delimiter";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ReplaceDelimiterQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ReplaceDelimiterQuickFix.$$$reportNull$$$0(1);
            }
            try {
                PsiElement psiElement = descriptor.getPsiElement();
                PsiElement newPsiElement = DotEnvFactory.createFromText(project, DotEnvTypes.KEY, psiElement.getText().replace("-", "_") + "=dummy");
                psiElement.replace(newPsiElement);
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance(IncorrectDelimiterInspection.class).error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                ReplaceDelimiterQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ru/adelf/idea/dotenv/inspections/IncorrectDelimiterInspection$ReplaceDelimiterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ru/adelf/idea/dotenv/inspections/IncorrectDelimiterInspection$ReplaceDelimiterQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

