/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.psi.DotEnvFile;
import ru.adelf.idea.dotenv.psi.DotEnvKey;

public class LeadingCharacterInspection
extends LocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        return "Invalid leading character";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            LeadingCharacterInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            LeadingCharacterInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof DotEnvFile)) {
            return null;
        }
        return this.analyzeFile(file, manager, isOnTheFly).getResultsArray();
    }

    @NotNull
    private ProblemsHolder analyzeFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            LeadingCharacterInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            LeadingCharacterInspection.$$$reportNull$$$0(3);
        }
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        PsiTreeUtil.findChildrenOfType((PsiElement)file, DotEnvKey.class).forEach(dotEnvKey -> {
            if (!dotEnvKey.getText().matches("[A-Za-z_-].*")) {
                problemsHolder.registerProblem((PsiElement)dotEnvKey, "Invalid first char for a key. Only A-Z and '_' are allowed.", new LocalQuickFix[0]);
            }
        });
        ProblemsHolder problemsHolder2 = problemsHolder;
        if (problemsHolder2 == null) {
            LeadingCharacterInspection.$$$reportNull$$$0(4);
        }
        return problemsHolder2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ru/adelf/idea/dotenv/inspections/LeadingCharacterInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ru/adelf/idea/dotenv/inspections/LeadingCharacterInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

