/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.DotEnvFactory;
import ru.adelf.idea.dotenv.psi.DotEnvFile;
import ru.adelf.idea.dotenv.psi.DotEnvTypes;
import ru.adelf.idea.dotenv.psi.DotEnvValue;

public class SpaceInsideNonQuotedInspection
extends LocalInspectionTool {
    private AddQuotesQuickFix addQuotesQuickFix = new AddQuotesQuickFix();

    @NotNull
    public String getDisplayName() {
        return "Space inside non-quoted value";
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpaceInsideNonQuotedInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpaceInsideNonQuotedInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof DotEnvFile)) {
            return null;
        }
        return this.analyzeFile(file, manager, isOnTheFly).getResultsArray();
    }

    @NotNull
    private ProblemsHolder analyzeFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpaceInsideNonQuotedInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpaceInsideNonQuotedInspection.$$$reportNull$$$0(3);
        }
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        PsiTreeUtil.findChildrenOfType((PsiElement)file, DotEnvValue.class).forEach(dotEnvValue -> {
            if (dotEnvValue.getFirstChild().getNode().getElementType() == DotEnvTypes.VALUE_CHARS && dotEnvValue.getText().trim().contains(" ")) {
                problemsHolder.registerProblem((PsiElement)dotEnvValue, "Space inside allowed only for quoted values", new LocalQuickFix[]{this.addQuotesQuickFix});
            }
        });
        ProblemsHolder problemsHolder2 = problemsHolder;
        if (problemsHolder2 == null) {
            SpaceInsideNonQuotedInspection.$$$reportNull$$$0(4);
        }
        return problemsHolder2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ru/adelf/idea/dotenv/inspections/SpaceInsideNonQuotedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ru/adelf/idea/dotenv/inspections/SpaceInsideNonQuotedInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class AddQuotesQuickFix
    implements LocalQuickFix {
        private AddQuotesQuickFix() {
        }

        @NotNull
        public String getName() {
            return "Add quotes";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            long singleQuoted;
            if (project == null) {
                AddQuotesQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                AddQuotesQuickFix.$$$reportNull$$$0(1);
            }
            Supplier<Stream> supplier = () -> PsiTreeUtil.findChildrenOfType((PsiElement)descriptor.getPsiElement().getContainingFile(), DotEnvValue.class).stream().filter(dotEnvValue -> dotEnvValue.getFirstChild().getNode().getElementType() == DotEnvTypes.QUOTE);
            long total = supplier.get().count();
            long doubleQuoted = supplier.get().filter(dotEnvValue -> dotEnvValue.getFirstChild().getText().contains("\"")).count();
            String quote = doubleQuoted > (singleQuoted = total - doubleQuoted) ? "\"" : "'";
            try {
                DotEnvValue valueElement = (DotEnvValue)descriptor.getPsiElement();
                PsiElement newValueElement = DotEnvFactory.createFromText(project, DotEnvTypes.VALUE, "DUMMY=" + quote + valueElement.getText() + quote);
                valueElement.getNode().getTreeParent().replaceChild(valueElement.getNode(), newValueElement.getNode());
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance(SpaceInsideNonQuotedInspection.class).error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                AddQuotesQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ru/adelf/idea/dotenv/inspections/SpaceInsideNonQuotedInspection$AddQuotesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ru/adelf/idea/dotenv/inspections/SpaceInsideNonQuotedInspection$AddQuotesQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

