/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.java;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import ru.adelf.idea.dotenv.java.JavaPsiHelper;
import ru.adelf.idea.dotenv.models.KeyUsagePsiElement;

class JavaEnvironmentCallsVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final Collection<KeyUsagePsiElement> collectedItems = new HashSet<KeyUsagePsiElement>();

    JavaEnvironmentCallsVisitor() {
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        if (JavaPsiHelper.isEnvMethodCall(expression)) {
            PsiExpression[] parameters = expression.getArgumentList().getExpressions();
            if (parameters.length == 0) {
                return;
            }
            if (!(parameters[0] instanceof PsiLiteralExpression)) {
                return;
            }
            Object value = ((PsiLiteralExpression)parameters[0]).getValue();
            if (value instanceof String) {
                this.collectedItems.add(new KeyUsagePsiElement((String)value, (PsiElement)parameters[0]));
            }
        }
        super.visitMethodCallExpression(expression);
    }

    @NotNull
    Collection<KeyUsagePsiElement> getCollectedItems() {
        Collection<KeyUsagePsiElement> collection = this.collectedItems;
        if (collection == null) {
            JavaEnvironmentCallsVisitor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/adelf/idea/dotenv/java/JavaEnvironmentCallsVisitor", "getCollectedItems"));
    }
}

