/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.php;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Arrays;
import java.util.List;

class PhpPsiHelper {
    public static final List<String> FUNCTIONS = Arrays.asList("getenv", "env");
    public static final List<String> ARRAY_NAMES = Arrays.asList("_ENV", "_SERVER");

    PhpPsiHelper() {
    }

    static boolean isEnvStringLiteral(StringLiteralExpression literal) {
        PsiElement arrayAccess;
        PsiElement parent = literal.getParent();
        if (parent instanceof ParameterList) {
            return PhpPsiHelper.isFunctionParameter((PsiElement)literal, 0, FUNCTIONS);
        }
        if (parent instanceof ArrayIndex && (arrayAccess = parent.getParent()) instanceof ArrayAccessExpression) {
            return PhpPsiHelper.isEnvArrayCall((ArrayAccessExpression)arrayAccess);
        }
        return false;
    }

    static boolean isEnvFunction(FunctionReference functionReference) {
        String name = functionReference.getName();
        return name != null && FUNCTIONS.contains(name);
    }

    static boolean isEnvArrayCall(ArrayAccessExpression arrayAccess) {
        PhpPsiElement variable = arrayAccess.getValue();
        if (!(variable instanceof Variable)) {
            return false;
        }
        return variable.getName() != null && ARRAY_NAMES.contains(variable.getName());
    }

    private static boolean isFunctionParameter(PsiElement psiElement, int parameterIndex, List<String> functions) {
        PsiElement variableContext = psiElement.getContext();
        if (!(variableContext instanceof ParameterList)) {
            return false;
        }
        ParameterList parameterList = (ParameterList)variableContext;
        PsiElement context = parameterList.getContext();
        if (!(context instanceof FunctionReference)) {
            return false;
        }
        FunctionReference methodReference = (FunctionReference)context;
        String name = methodReference.getName();
        return name != null && functions.contains(name) && PhpPsiHelper.getParameterIndex(parameterList, psiElement) == parameterIndex;
    }

    private static int getParameterIndex(ParameterList parameterList, PsiElement parameter) {
        PsiElement[] parameters = parameterList.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].equals(parameter)) continue;
            return i;
        }
        return -1;
    }
}

