/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;
import ru.adelf.idea.dotenv.DotEnvSettings;

public class DotEnvSettingsConfigurable
implements Configurable {
    private JCheckBox completionEnabledCheckbox;
    private JCheckBox storeValuesCheckbox;
    private JCheckBox hideValuesCheckbox;

    @Nls
    public String getDisplayName() {
        return "DotEnv";
    }

    @Nullable
    public JComponent createComponent() {
        DotEnvSettings settings = this.getSettings();
        Border standardBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.completionEnabledCheckbox = new JCheckBox("Enable environment variables completions", settings.completionEnabled);
        this.completionEnabledCheckbox.setBorder(standardBorder);
        this.storeValuesCheckbox = new JCheckBox("Store and complete values", settings.storeValues);
        this.storeValuesCheckbox.setBorder(standardBorder);
        this.storeValuesCheckbox.setToolTipText("Storing values in the indices can be turned off due to security reasons");
        JBLabel storeValuesInvalidateCachesLabel = new JBLabel("Run File > Invalidate Caches... to update indices");
        storeValuesInvalidateCachesLabel.setBorder(standardBorder);
        storeValuesInvalidateCachesLabel.setVisible(false);
        this.storeValuesCheckbox.addChangeListener(arg_0 -> this.lambda$createComponent$0((JLabel)storeValuesInvalidateCachesLabel, arg_0));
        this.hideValuesCheckbox = new JCheckBox("Hide values in .env files", settings.storeValues);
        this.hideValuesCheckbox.setBorder(standardBorder);
        JBLabel hideValuesLabel = new JBLabel("<html>Check this if you want values to be hidden by default.<br>Main menu > Code > Folding actions can be used to control it.</html>");
        hideValuesLabel.setBorder(standardBorder);
        JPanel rootPanel = new JPanel();
        rootPanel.setLayout(new BoxLayout(rootPanel, 3));
        rootPanel.add(this.completionEnabledCheckbox);
        rootPanel.add(this.storeValuesCheckbox);
        rootPanel.add((Component)storeValuesInvalidateCachesLabel);
        rootPanel.add(this.hideValuesCheckbox);
        rootPanel.add((Component)hideValuesLabel);
        return rootPanel;
    }

    public boolean isModified() {
        return !this.completionEnabledCheckbox.isSelected() == this.getSettings().completionEnabled || !this.storeValuesCheckbox.isSelected() == this.getSettings().storeValues || !this.hideValuesCheckbox.isSelected() == this.getSettings().hideValuesInTheFile;
    }

    public void apply() {
        DotEnvSettings settings = this.getSettings();
        settings.completionEnabled = this.completionEnabledCheckbox.isSelected();
        settings.storeValues = this.storeValuesCheckbox.isSelected();
        settings.hideValuesInTheFile = this.hideValuesCheckbox.isSelected();
    }

    public void reset() {
        this.completionEnabledCheckbox.setSelected(this.getSettings().completionEnabled);
        this.storeValuesCheckbox.setSelected(this.getSettings().storeValues);
        this.hideValuesCheckbox.setSelected(this.getSettings().hideValuesInTheFile);
    }

    private DotEnvSettings getSettings() {
        return DotEnvSettings.getInstance();
    }

    private /* synthetic */ void lambda$createComponent$0(JLabel storeValuesInvalidateCachesLabel, ChangeEvent e) {
        storeValuesInvalidateCachesLabel.setVisible(this.storeValuesCheckbox.isSelected() != this.getSettings().storeValues);
    }
}

