/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.psalm.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.tools.quality.psalm.PsalmConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="psalm_fixer_by_interpreter")
public class PsalmRemoteConfiguration
extends PsalmConfiguration
implements PhpSdkDependentConfiguration {
    private String myInterpreterId;

    @Override
    @Attribute(value="interpreter_id")
    @Nullable
    @NlsSafe
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    public void setInterpreterId(@NotNull String interpreterId) {
        if (interpreterId == null) {
            PsalmRemoteConfiguration.$$$reportNull$$$0(0);
        }
        this.myInterpreterId = interpreterId;
    }

    @NotNull
    @NlsContexts.Label
    public String getPresentableName(@Nullable Project project) {
        if (this.isCreatedAsDefaultInterpreterConfiguration()) {
            String string = PhpBundle.message((String)"quality.tools.label.by.default.project.interpreter", (Object[])new Object[0]);
            if (string == null) {
                PsalmRemoteConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }
        return PsalmRemoteConfiguration.getDefaultName(PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterName(this.getInterpreterId()));
    }

    @Override
    @NotNull
    public String getId() {
        if (this.isCreatedAsDefaultInterpreterConfiguration()) {
            return "DEFAULT_INTERPRETER";
        }
        String interpreterId = this.getInterpreterId();
        String string = StringUtil.isEmpty((String)interpreterId) ? PhpBundle.message((String)"undefined.interpreter", (Object[])new Object[0]) : interpreterId;
        if (string == null) {
            PsalmRemoteConfiguration.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsContexts.Label
    public static String getDefaultName(@NlsContexts.Label @Nullable String interpreterName) {
        String string = StringUtil.isEmpty((String)interpreterName) ? PhpBundle.message((String)"undefined.interpreter", (Object[])new Object[0]) : interpreterName;
        if (string == null) {
            PsalmRemoteConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public PsalmRemoteConfiguration clone() {
        PsalmRemoteConfiguration settings = new PsalmRemoteConfiguration();
        settings.myInterpreterId = this.myInterpreterId;
        settings.setCreatedAsDefaultInterpreterConfiguration(this.isCreatedAsDefaultInterpreterConfiguration());
        settings.setDeletedFromTheList(this.isDeletedFromTheList());
        this.clone(settings);
        return settings;
    }

    public String serialize(@Nullable String path) {
        return path;
    }

    public String deserialize(@Nullable String path) {
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/psalm/remote/PsalmRemoteConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/psalm/remote/PsalmRemoteConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

