/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.actions.ChangePageSizeActionGroup;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.FloatingPagingManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.roots.ui.configuration.actions.AlignedIconWithTextAction;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CountRowsAction
extends IconWithTextAction
implements CustomComponentAction,
GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CountRowsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CountRowsAction.$$$reportNull$$$0(1);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            CountRowsAction.countRows(grid);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CountRowsAction.$$$reportNull$$$0(2);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (FloatingPagingManager.adjustAction(e) == FloatingPagingManager.AdjustmentResult.HIDDEN) {
            return;
        }
        MyActionState state = CountRowsAction.getActionState(grid);
        if (GridUtil.hidePageActions(grid, e.getPlace())) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            CountRowsAction.updatePresentation(state, e.getPresentation());
        }
        super.update(e);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            CountRowsAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            CountRowsAction.$$$reportNull$$$0(4);
        }
        ActionButtonWithText c = new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            public Color getInactiveTextColor() {
                return this.getForeground();
            }

            public Insets getInsets() {
                return new JBInsets(0, 0, 0, 0);
            }
        };
        JComponent jComponent = AlignedIconWithTextAction.align((JComponent)c);
        if (jComponent == null) {
            CountRowsAction.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    public static AsyncFutureResult<Long> countRows(@NotNull GridDataHookUp<GridRow, GridColumn> hookUp) {
        if (hookUp == null) {
            CountRowsAction.$$$reportNull$$$0(6);
        }
        return CountRowsAction.countRows(hookUp, null);
    }

    public static AsyncFutureResult<Long> countRows(@NotNull DataGrid grid) {
        if (grid == null) {
            CountRowsAction.$$$reportNull$$$0(7);
        }
        return CountRowsAction.countRows((GridDataHookUp<GridRow, GridColumn>)grid.getDataHookup(), grid);
    }

    private static AsyncFutureResult<Long> countRows(final @NotNull GridDataHookUp<GridRow, GridColumn> hookUp, @Nullable DataGrid grid) {
        if (hookUp == null) {
            CountRowsAction.$$$reportNull$$$0(8);
        }
        final AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        final GridRequestSource requestSource = new GridRequestSource((GridRequestSource.RequestPlace)(grid == null ? null : new DataGridRequestPlace((CoreGrid)grid)));
        final Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)ObjectUtils.notNull((Object)grid, (Object)hookUp.getProject())), (Disposable)disposable);
        hookUp.addRequestListener((GridDataHookUp.RequestListener)new GridDataHookUp.RequestListener<GridRow, GridColumn>(){

            public void error(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (errorInfo == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            public void updateCountReceived(@NotNull GridRequestSource source, int updateCount) {
                if (source == null) {
                    2.$$$reportNull$$$0(2);
                }
                throw new AssertionError((Object)"Row count query should not modify data");
            }

            public void requestFinished(@NotNull GridRequestSource source, boolean success) {
                if (source == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (source != requestSource) {
                    return;
                }
                if (success) {
                    long rowCount = hookUp.getPageModel().getTotalRowCount();
                    result.set((Object)rowCount);
                } else {
                    result.setException((Throwable)new Exception("Row count update failed"));
                }
                Disposer.dispose((Disposable)disposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorInfo";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/actions/CountRowsAction$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCountReceived";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
        hookUp.getLoader().updateTotalRowCount(requestSource);
        return result;
    }

    private static void updatePresentation(MyActionState state, Presentation presentation) {
        MyActionState oldState = CountRowsAction.getActionState(presentation);
        if (oldState.equals(state)) {
            return;
        }
        presentation.setText(state.text);
        presentation.setDescription(state.description);
        presentation.setEnabled(state.enabled);
        presentation.setVisible(state.visible);
    }

    @NotNull
    private static MyActionState getActionState(@NotNull Presentation presentation) {
        if (presentation == null) {
            CountRowsAction.$$$reportNull$$$0(9);
        }
        String text = presentation.getText();
        String description = presentation.getDescription();
        boolean loading = presentation.isEnabled();
        boolean visible = presentation.isVisible();
        return new MyActionState(text, description, loading, visible);
    }

    @NotNull
    private static MyActionState getActionState(@NotNull DataGrid grid) {
        if (grid == null) {
            CountRowsAction.$$$reportNull$$$0(10);
        }
        GridPagingModel pageModel = grid.getDataHookup().getPageModel();
        int pageEndIdx = pageModel.getPageEnd();
        long totalRowCount = pageModel.getTotalRowCount();
        boolean totalRowCountIsPrecise = pageModel.isTotalRowCountPrecise();
        boolean canUpdateTotalRowCount = pageModel.isTotalRowCountUpdateable();
        boolean rowsWereDeleted = totalRowCount < (long)pageEndIdx;
        String text = DataGridBundle.message((String)"count.rows.action.of.text", (Object[])new Object[]{ChangePageSizeActionGroup.format(totalRowCount)}) + (totalRowCountIsPrecise ? "" : "+");
        boolean querying = grid.getDataHookup().getBusyCount() > 0;
        boolean isSinglePage = pageModel.isFirstPage() && pageModel.isLastPage() && !rowsWereDeleted;
        boolean visible = !isSinglePage;
        boolean enabled = canUpdateTotalRowCount && !querying && grid.isReady();
        String description = DataGridBundle.message((String)"action.CountRows.description", (Object[])new Object[0]);
        if (!enabled) {
            description = canUpdateTotalRowCount && querying ? DataGridBundle.message((String)"action.CountRows.querying", (Object[])new Object[0]) : "";
        }
        return new MyActionState(text, description, enabled, visible);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CountRowsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CountRowsAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "countRows";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActionState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyActionState {
        final @NlsActions.ActionText String text;
        final @NlsActions.ActionDescription String description;
        final @NlsContexts.Tooltip boolean enabled;
        final boolean visible;

        private MyActionState(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, boolean enabled, boolean visible) {
            this.text = text;
            this.description = description;
            this.enabled = enabled;
            this.visible = visible;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyActionState state = (MyActionState)o;
            return this.enabled == state.enabled && this.visible == state.visible && Objects.equals(this.text, state.text) && Objects.equals(this.description, state.description);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.description, this.enabled, this.visible);
        }
    }
}

