/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 136332536205737L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1684249500 + -((char)-30511), -1684249500 + -((char)-16802), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1684249500 + -((char)-30510), 1684249500 + 29001, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 12029551948942L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.W();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(651417900 + 25994, 651417900 + 11418, (int)l2) + string + WindowsNamedPipeAgentIpc.b(651417900 + 25995, -651417900 + -29211, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(651417900 + 25988, 651417900 + 18577, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 115473226586301L;
                Object object = this.lock;
                int[] nArray = SshAgentIpcService.W();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1264170150 - 25124, -1264170150 - -((char)-28287), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1264170150 - 25125, -1264170150 - -17068, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1264170150 - 25126, -1264170150 - -25290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1264170150 - 25111, 1264170150 - (char)-22102, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1264170150 - 25112, -1264170150 - -26503, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1264170150 - 25126, -1264170150 - -25290, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1264170150 - 25113, 1264170150 - 16672, (int)l2));
            if (ActionTimestamp.W() == null) {
                SshAgentIpcService.W(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 46520869647076L;
                    nArray = SshAgentIpcService.W();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 56587371692728L;
                int[] nArray2 = SshAgentIpcService.W();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1177532880 + -32167, -1177532880 + -22594, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1177532880 + -32171, 1177532880 + 31313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177532880 + -32162, -1177532880 + -((char)-30001), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1177532880 + -32171, 1177532880 + 31313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177532880 + -32161, 1177532880 + (char)-24738, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1177532880 + -32167, -1177532880 + -22594, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1177532880 + -32171, 1177532880 + 31313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177532880 + -32164, -1177532880 + -((char)-29120), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1177532880 + -32167, -1177532880 + -22594, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1177532880 + -32171, 1177532880 + 31313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177532880 + -32163, 1177532880 + (char)-29105, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1177532880 + -32171, 1177532880 + 31313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177532880 + -32158, 1177532880 + 23811, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1177532880 + -32171, 1177532880 + 31313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177532880 + -32161, 1177532880 + (char)-24738, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1177532880 + -32167, -1177532880 + -22594, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1177532880 + -32171, 1177532880 + 31313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1177532880 + -32157, -1177532880 + -((char)-21773), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 137863640996088L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-514187610 + -((char)-2164), 514187610 + (char)-13421, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 74632898103554L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-748540770 + -((char)-2627), -748540770 + -((char)-8796), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u0096_\u008a\u008e\u00c0\u0014\u0090\u00e3\u009e~}6'<\u00eam\u00d2\u008d\u00fe\u0014HqQM\u00a0\u00ae\u00e112\"-i\u00ef.2\u00a4$r'Y";
                        var4_3 = "\u0096_\u008a\u008e\u00c0\u0014\u0090\u00e3\u009e~}6'<\u00eam\u00d2\u008d\u00fe\u0014HqQM\u00a0\u00ae\u00e112\"-i\u00ef.2\u00a4$r'Y".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 55;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 82;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 113;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 23;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 26;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 85;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 71;
                                        break;
                                    }
                                    default: {
                                        v11 = 37;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x7FE2) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 83;
                            case 1 -> 200;
                            case 2 -> 244;
                            case 3 -> 122;
                            case 4 -> 57;
                            case 5 -> 31;
                            case 6 -> 5;
                            case 7 -> 1;
                            case 8 -> 85;
                            case 9 -> 61;
                            case 10 -> 171;
                            case 11 -> 134;
                            case 12 -> 158;
                            case 13 -> 233;
                            case 14 -> 62;
                            case 15 -> 176;
                            case 16 -> 95;
                            case 17 -> 0;
                            case 18 -> 150;
                            case 19 -> 216;
                            case 20 -> 35;
                            case 21 -> 218;
                            case 22 -> 241;
                            case 23 -> 59;
                            case 24 -> 78;
                            case 25 -> 177;
                            case 26 -> 170;
                            case 27 -> 187;
                            case 28 -> 143;
                            case 29 -> 194;
                            case 30 -> 160;
                            case 31 -> 202;
                            case 32 -> 138;
                            case 33 -> 60;
                            case 34 -> 40;
                            case 35 -> 199;
                            case 36 -> 114;
                            case 37 -> 93;
                            case 38 -> 102;
                            case 39 -> 92;
                            case 40 -> 25;
                            case 41 -> 168;
                            case 42 -> 142;
                            case 43 -> 20;
                            case 44 -> 148;
                            case 45 -> 181;
                            case 46 -> 107;
                            case 47 -> 79;
                            case 48 -> 63;
                            case 49 -> 87;
                            case 50 -> 135;
                            case 51 -> 14;
                            case 52 -> 81;
                            case 53 -> 13;
                            case 54 -> 154;
                            case 55 -> 70;
                            case 56 -> 55;
                            case 57 -> 111;
                            case 58 -> 231;
                            case 59 -> 193;
                            case 60 -> 38;
                            case 61 -> 98;
                            case 62 -> 21;
                            case 63 -> 192;
                            case 64 -> 10;
                            case 65 -> 82;
                            case 66 -> 39;
                            case 67 -> 178;
                            case 68 -> 253;
                            case 69 -> 125;
                            case 70 -> 174;
                            case 71 -> 255;
                            case 72 -> 238;
                            case 73 -> 197;
                            case 74 -> 75;
                            case 75 -> 26;
                            case 76 -> 157;
                            case 77 -> 96;
                            case 78 -> 105;
                            case 79 -> 109;
                            case 80 -> 208;
                            case 81 -> 141;
                            case 82 -> 65;
                            case 83 -> 76;
                            case 84 -> 229;
                            case 85 -> 127;
                            case 86 -> 121;
                            case 87 -> 186;
                            case 88 -> 191;
                            case 89 -> 161;
                            case 90 -> 240;
                            case 91 -> 27;
                            case 92 -> 23;
                            case 93 -> 51;
                            case 94 -> 12;
                            case 95 -> 17;
                            case 96 -> 206;
                            case 97 -> 50;
                            case 98 -> 179;
                            case 99 -> 163;
                            case 100 -> 42;
                            case 101 -> 235;
                            case 102 -> 88;
                            case 103 -> 162;
                            case 104 -> 113;
                            case 105 -> 151;
                            case 106 -> 128;
                            case 107 -> 19;
                            case 108 -> 245;
                            case 109 -> 196;
                            case 110 -> 228;
                            case 111 -> 166;
                            case 112 -> 210;
                            case 113 -> 99;
                            case 114 -> 242;
                            case 115 -> 15;
                            case 116 -> 167;
                            case 117 -> 6;
                            case 118 -> 110;
                            case 119 -> 43;
                            case 120 -> 103;
                            case 121 -> 250;
                            case 122 -> 80;
                            case 123 -> 224;
                            case 124 -> 66;
                            case 125 -> 183;
                            case 126 -> 190;
                            case 127 -> 153;
                            case 128 -> 133;
                            case 129 -> 247;
                            case 130 -> 124;
                            case 131 -> 36;
                            case 132 -> 116;
                            case 133 -> 77;
                            case 134 -> 67;
                            case 135 -> 137;
                            case 136 -> 101;
                            case 137 -> 182;
                            case 138 -> 9;
                            case 139 -> 86;
                            case 140 -> 243;
                            case 141 -> 24;
                            case 142 -> 195;
                            case 143 -> 248;
                            case 144 -> 225;
                            case 145 -> 146;
                            case 146 -> 32;
                            case 147 -> 207;
                            case 148 -> 108;
                            case 149 -> 226;
                            case 150 -> 252;
                            case 151 -> 203;
                            case 152 -> 155;
                            case 153 -> 221;
                            case 154 -> 213;
                            case 155 -> 41;
                            case 156 -> 132;
                            case 157 -> 205;
                            case 158 -> 152;
                            case 159 -> 234;
                            case 160 -> 94;
                            case 161 -> 188;
                            case 162 -> 56;
                            case 163 -> 222;
                            case 164 -> 91;
                            case 165 -> 3;
                            case 166 -> 2;
                            case 167 -> 37;
                            case 168 -> 72;
                            case 169 -> 126;
                            case 170 -> 58;
                            case 171 -> 104;
                            case 172 -> 34;
                            case 173 -> 232;
                            case 174 -> 112;
                            case 175 -> 131;
                            case 176 -> 184;
                            case 177 -> 69;
                            case 178 -> 119;
                            case 179 -> 22;
                            case 180 -> 254;
                            case 181 -> 165;
                            case 182 -> 145;
                            case 183 -> 144;
                            case 184 -> 130;
                            case 185 -> 219;
                            case 186 -> 106;
                            case 187 -> 172;
                            case 188 -> 223;
                            case 189 -> 123;
                            case 190 -> 71;
                            case 191 -> 246;
                            case 192 -> 164;
                            case 193 -> 117;
                            case 194 -> 4;
                            case 195 -> 44;
                            case 196 -> 90;
                            case 197 -> 215;
                            case 198 -> 201;
                            case 199 -> 84;
                            case 200 -> 89;
                            case 201 -> 249;
                            case 202 -> 220;
                            case 203 -> 136;
                            case 204 -> 54;
                            case 205 -> 212;
                            case 206 -> 217;
                            case 207 -> 48;
                            case 208 -> 11;
                            case 209 -> 74;
                            case 210 -> 173;
                            case 211 -> 236;
                            case 212 -> 47;
                            case 213 -> 18;
                            case 214 -> 8;
                            case 215 -> 64;
                            case 216 -> 52;
                            case 217 -> 230;
                            case 218 -> 129;
                            case 219 -> 33;
                            case 220 -> 209;
                            case 221 -> 45;
                            case 222 -> 46;
                            case 223 -> 16;
                            case 224 -> 211;
                            case 225 -> 239;
                            case 226 -> 139;
                            case 227 -> 49;
                            case 228 -> 189;
                            case 229 -> 140;
                            case 230 -> 53;
                            case 231 -> 159;
                            case 232 -> 97;
                            case 233 -> 237;
                            case 234 -> 100;
                            case 235 -> 7;
                            case 236 -> 118;
                            case 237 -> 29;
                            case 238 -> 198;
                            case 239 -> 251;
                            case 240 -> 204;
                            case 241 -> 68;
                            case 242 -> 180;
                            case 243 -> 120;
                            case 244 -> 30;
                            case 245 -> 175;
                            case 246 -> 73;
                            case 247 -> 147;
                            case 248 -> 115;
                            case 249 -> 227;
                            case 250 -> 156;
                            case 251 -> 149;
                            case 252 -> 169;
                            case 253 -> 214;
                            case 254 -> 28;
                            default -> 185;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray == null) {
                ActionTimestamp.W("MbbaS");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 52033326382164L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.W();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(202503150 - (char)-631, 202372080 + (char)-8430, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(202503150 - (char)-635, -202503150 - -((char)-325), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(202503150 - (char)-654, 202372080 + (char)-13689, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(202503150 - (char)-631, 202372080 + (char)-8430, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(202503150 - (char)-635, -202503150 - -((char)-325), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(202503150 - (char)-655, -202372080 + -((char)-117), (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 101776717284762L;
                        int[] nArray2 = SshAgentIpcService.W();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1122745620 - (char)-21152, 1122745620 - 26421, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1122745620 - (char)-21153, -1122745620 - -((char)-24936), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 94238218709357L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                nArray = SshAgentIpcService.W();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1953729420 - 10288, 1953729420 - 17745, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1953729420 - 10300, -1953729420 - -11136, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1953729420 - 10315, 1953729420 - 18325, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1953729420 - 10300, -1953729420 - -11136, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1953729420 - 10290, -1953729420 - -32391, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1953729420 - 10288, 1953729420 - 17745, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1953729420 - 10300, -1953729420 - -11136, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1953729420 - 10316, 1953729420 - 11976, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1953729420 - 10288, 1953729420 - 17745, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1953729420 - 10300, -1953729420 - -11136, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1953729420 - 10301, 1953729420 - 20327, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1953729420 - 10288, 1953729420 - 17745, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1953729420 - 10300, -1953729420 - -11136, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1953729420 - 10302, -1953729420 - -13548, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 99562557710169L;
                    Object object = this.lock;
                    nArray = SshAgentIpcService.W();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8572), -920897820 - -((char)-1749), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8576), 920897820 - (char)-8356, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8555), 920766750 + (char)-14494, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8556), -920897820 - -((char)-9909), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8572), -920897820 - -((char)-1749), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8576), 920897820 - (char)-8356, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8549), 920766750 + (char)-7974, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8572), -920897820 - -((char)-1749), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8576), 920897820 - (char)-8356, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8550), 920897820 - (char)-867, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8572), -920897820 - -((char)-1749), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8576), 920897820 - (char)-8356, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8551), -920766750 + -((char)-8753), (int)l2));
                    if (nArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8572), -920897820 - -((char)-1749), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8576), 920897820 - (char)-8356, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-920897820 - -((char)-8552), 920766750 + (char)-10814, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "n\u00a1:c\u00d3P\u0016\u0087\u0014\u00a1\u00e7\u00fbL\u0015=a0\u0089\nH\u00d6V\u0011\u00f8\u00b8\u0013\u00b1\u00e4\"\u0006\u00d1O\u00cd\u00beG\u00aa\u0018\u00c64w\u0006\u0006\u00b1\u0001aM]\u00dfL\u00c2\u00bd8\u00af\u00a2:\u00fc\u00ce`\u001b\u00b3n\t\u00a7g\u00c5\u00dd;U\u00be\u00b5\u0086\u0005\u00bc)`r\u00e8\b\u0090A\u00e5\u000ez\u00db%\u0014\u0005\u00b1\u00e3\u00c1+\u00dc\u001e\u00a7\u00a2\u0016g\u00bbY\u0014\u0006J\u00a5t\u00d4\u00fb\u008e\u00bd\u00ad\u00f3\u00eb\u0004\u0000\u00d3\u00ed\u00c9}\u0017\u009d\u00e9\u00a2\u00db\u00ca\u0010\u00ea\u0094[dE\u000b=\u00b5\u0012a\u00f2\u00b1-w\u00c8\r\t\u008chv-\u001el<\r8\u0010<\u00f9\u0081\u00c9\u001e\u00beV\u0003\u007f\u00b7_k\u0098,~f?\u00fb\u00ef\u0095\u00ce\u00c6e>\u00ed~\t\u00b7\u00ba<\u00b5x\u00f3\u008eE\u00d6\u0010\u0007\u00bd(\u0011;\u00f8a\u00ba\u00fd\u009f\u00c1\u00d3 \u00b1\u000e\u00fer\u00cdK r\u00ed,\u00d9\u001dn\u00d5\u008eZ\u00e2-\u008b\u00b9\u00b4\u001e\u0084\u00b1)\u009f/\u00c7Y}\b\u00cc?n\u00c1\u000b\"\u000b+\f\u00cei>\u0010\u001cz\u0007'|{m\u00f6F\u0086\u00177\u00df=\u0083#\u0018\u00f8\u0090\u00f7O\u00a2\u0003\u00b4\u0003\u00eb<z\u0090\u0080\u00ff\u00dbks\u009c\u009b=\u001dF\u00e7\u00d4\u00d8\u00e7\u00d3\u0015\u0013\u00fd\u00cc\u00e2\u0011\u00a0\u00cb\u008b?\u00a1\u00c5\n\u00bf\u008a\u00f7,\r\u00d6\u009e\u00d3>\u00b7\u00f8@\u0018\u00dd\u00da\u00f9Rb\u00a5w\n\u008d\u001f\u00a8\u00f7\u00f7\u00cd\u0087\f\u0093\u00ac\u00ba\u00f0j~8\u00c6\u00ce\u0015\u00e6\u0014\u00db5\u00e3\u00cb\u0018\u0012L\u00a0\u0095\u00c9IVo\u000b\b\u0080\u00e6-\u0007\u00ddd\u00d3\u0010\u00e9\u00ea\u0015\u00ac\u00b9r\t\u00921:3\u00e5\u0015\u009c\tX\u0084\u00df\u000b?C=\u00a6\t)c\u00f4\u008e\u00ad\u00a8\u0000v-\u0006\u00c0\u00fdx\u00ce\f\u008eI\u00b1\u0017\u00ea\u00f25K\u0004\u001a\u00a0\u00e8\u00df\u00b8/\u008c!\u00b3\u00fe\u00aeq\u00b1Yt\u000ez\u00ea\u0007<\u00cdo\u0090\u00b0\u00fa\u00ee\u0007\u00a9y\u00b9j\u008dJ_(\u00b8o\u00b9\u00ff\u00fe J\u000e\u00f1s)8w\u0085\u00fb\u00fb\u0018\u00ecq\u00ce'\u00f2)\u00e6\u0095\u00cb\u00cf\u00a7\u001a\u000f\\\u00da\u00aa\u00e8e\u00d4a\u00a5\u009a\u00b3\u000fC\u0003\u0088[0\u00d86\u00d2\u000be\u00d7\u00ab\b\u00a3\u008a\"\u00ce\t;\u0012\u001e\u00f7\u00a0\u00d3\u00dc\u001f\u00a6\u0083\u00a6\u007f\u00e7\u00e9w*\u00b8\u0017\u0095\u00f7\u00b0\u00dd\u00a5D\u00b2\u00f3\u00a6\u00d7\u00b2\u00df\u00a2\u00d0\u000e\u00b9>\u00d7\u00fc\u00db,KL\u00a4\u00b6\"\u00d1\u00ba\u00e6\u001b\u0016\u00a8%+~cj\u00f9\u00d7\u0087\u00c1\u00f6\u00964\u00c7\u0096\u00dbo\u0090#\u00abE\u0004-x7\\\n\u00f7\u00fc\u00dd\u00a6u6\u00d8y*\u00f5\u0018\u001f\u00fe\u0004\u00ec['\u00ef/y\u0094\u00d6\u000b\u00cd\u00d8P*^\u00f9\u00f7\u0088?{\u00cd\u00b9)Jm\u00ab\u009e\ff\u00e2\u00e1\u0094Y\u00afK\u0080c\u00d8\u00df\u0005\u00b0\u00a3\u00c3&}/\u00d0\u00b0#@-\u008fb\u008e\u00ff.\u00f9\u00be\u00cf~\u009f\u00ea\u0007v";
                var4_3 = "n\u00a1:c\u00d3P\u0016\u0087\u0014\u00a1\u00e7\u00fbL\u0015=a0\u0089\nH\u00d6V\u0011\u00f8\u00b8\u0013\u00b1\u00e4\"\u0006\u00d1O\u00cd\u00beG\u00aa\u0018\u00c64w\u0006\u0006\u00b1\u0001aM]\u00dfL\u00c2\u00bd8\u00af\u00a2:\u00fc\u00ce`\u001b\u00b3n\t\u00a7g\u00c5\u00dd;U\u00be\u00b5\u0086\u0005\u00bc)`r\u00e8\b\u0090A\u00e5\u000ez\u00db%\u0014\u0005\u00b1\u00e3\u00c1+\u00dc\u001e\u00a7\u00a2\u0016g\u00bbY\u0014\u0006J\u00a5t\u00d4\u00fb\u008e\u00bd\u00ad\u00f3\u00eb\u0004\u0000\u00d3\u00ed\u00c9}\u0017\u009d\u00e9\u00a2\u00db\u00ca\u0010\u00ea\u0094[dE\u000b=\u00b5\u0012a\u00f2\u00b1-w\u00c8\r\t\u008chv-\u001el<\r8\u0010<\u00f9\u0081\u00c9\u001e\u00beV\u0003\u007f\u00b7_k\u0098,~f?\u00fb\u00ef\u0095\u00ce\u00c6e>\u00ed~\t\u00b7\u00ba<\u00b5x\u00f3\u008eE\u00d6\u0010\u0007\u00bd(\u0011;\u00f8a\u00ba\u00fd\u009f\u00c1\u00d3 \u00b1\u000e\u00fer\u00cdK r\u00ed,\u00d9\u001dn\u00d5\u008eZ\u00e2-\u008b\u00b9\u00b4\u001e\u0084\u00b1)\u009f/\u00c7Y}\b\u00cc?n\u00c1\u000b\"\u000b+\f\u00cei>\u0010\u001cz\u0007'|{m\u00f6F\u0086\u00177\u00df=\u0083#\u0018\u00f8\u0090\u00f7O\u00a2\u0003\u00b4\u0003\u00eb<z\u0090\u0080\u00ff\u00dbks\u009c\u009b=\u001dF\u00e7\u00d4\u00d8\u00e7\u00d3\u0015\u0013\u00fd\u00cc\u00e2\u0011\u00a0\u00cb\u008b?\u00a1\u00c5\n\u00bf\u008a\u00f7,\r\u00d6\u009e\u00d3>\u00b7\u00f8@\u0018\u00dd\u00da\u00f9Rb\u00a5w\n\u008d\u001f\u00a8\u00f7\u00f7\u00cd\u0087\f\u0093\u00ac\u00ba\u00f0j~8\u00c6\u00ce\u0015\u00e6\u0014\u00db5\u00e3\u00cb\u0018\u0012L\u00a0\u0095\u00c9IVo\u000b\b\u0080\u00e6-\u0007\u00ddd\u00d3\u0010\u00e9\u00ea\u0015\u00ac\u00b9r\t\u00921:3\u00e5\u0015\u009c\tX\u0084\u00df\u000b?C=\u00a6\t)c\u00f4\u008e\u00ad\u00a8\u0000v-\u0006\u00c0\u00fdx\u00ce\f\u008eI\u00b1\u0017\u00ea\u00f25K\u0004\u001a\u00a0\u00e8\u00df\u00b8/\u008c!\u00b3\u00fe\u00aeq\u00b1Yt\u000ez\u00ea\u0007<\u00cdo\u0090\u00b0\u00fa\u00ee\u0007\u00a9y\u00b9j\u008dJ_(\u00b8o\u00b9\u00ff\u00fe J\u000e\u00f1s)8w\u0085\u00fb\u00fb\u0018\u00ecq\u00ce'\u00f2)\u00e6\u0095\u00cb\u00cf\u00a7\u001a\u000f\\\u00da\u00aa\u00e8e\u00d4a\u00a5\u009a\u00b3\u000fC\u0003\u0088[0\u00d86\u00d2\u000be\u00d7\u00ab\b\u00a3\u008a\"\u00ce\t;\u0012\u001e\u00f7\u00a0\u00d3\u00dc\u001f\u00a6\u0083\u00a6\u007f\u00e7\u00e9w*\u00b8\u0017\u0095\u00f7\u00b0\u00dd\u00a5D\u00b2\u00f3\u00a6\u00d7\u00b2\u00df\u00a2\u00d0\u000e\u00b9>\u00d7\u00fc\u00db,KL\u00a4\u00b6\"\u00d1\u00ba\u00e6\u001b\u0016\u00a8%+~cj\u00f9\u00d7\u0087\u00c1\u00f6\u00964\u00c7\u0096\u00dbo\u0090#\u00abE\u0004-x7\\\n\u00f7\u00fc\u00dd\u00a6u6\u00d8y*\u00f5\u0018\u001f\u00fe\u0004\u00ec['\u00ef/y\u0094\u00d6\u000b\u00cd\u00d8P*^\u00f9\u00f7\u0088?{\u00cd\u00b9)Jm\u00ab\u009e\ff\u00e2\u00e1\u0094Y\u00afK\u0080c\u00d8\u00df\u0005\u00b0\u00a3\u00c3&}/\u00d0\u00b0#@-\u008fb\u008e\u00ff.\u00f9\u00be\u00cf~\u009f\u00ea\u0007v".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 2;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "B\u00ba6\u00f0\u0085\u0081\u0080r\u008b\u001d\u00d6\u001a\u00a1\u00e9\u00d4\u0011`\u0096].\u000f<\r\u0014\u00f0\u00a8\u0099\u00cb\u00f9\u00b1\u00a1\u0095\u00b5\u008a\u00d1\u00edd(\u0002";
                    var4_3 = "B\u00ba6\u00f0\u0085\u0081\u0080r\u008b\u001d\u00d6\u001a\u00a1\u00e9\u00d4\u0011`\u0096].\u000f<\r\u0014\u00f0\u00a8\u0099\u00cb\u00f9\u00b1\u00a1\u0095\u00b5\u008a\u00d1\u00edd(\u0002".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 117;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 101;
                            break;
                        }
                        case 1: {
                            v15 = 11;
                            break;
                        }
                        case 2: {
                            v15 = 23;
                            break;
                        }
                        case 3: {
                            v15 = 85;
                            break;
                        }
                        case 4: {
                            v15 = 26;
                            break;
                        }
                        case 5: {
                            v15 = 124;
                            break;
                        }
                        default: {
                            v15 = 67;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFF8A3A) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 177;
                case 1 -> 151;
                case 2 -> 22;
                case 3 -> 37;
                case 4 -> 147;
                case 5 -> 102;
                case 6 -> 96;
                case 7 -> 218;
                case 8 -> 63;
                case 9 -> 54;
                case 10 -> 236;
                case 11 -> 80;
                case 12 -> 194;
                case 13 -> 214;
                case 14 -> 52;
                case 15 -> 59;
                case 16 -> 81;
                case 17 -> 143;
                case 18 -> 16;
                case 19 -> 3;
                case 20 -> 157;
                case 21 -> 140;
                case 22 -> 85;
                case 23 -> 205;
                case 24 -> 124;
                case 25 -> 246;
                case 26 -> 213;
                case 27 -> 129;
                case 28 -> 12;
                case 29 -> 170;
                case 30 -> 56;
                case 31 -> 24;
                case 32 -> 116;
                case 33 -> 105;
                case 34 -> 250;
                case 35 -> 219;
                case 36 -> 139;
                case 37 -> 166;
                case 38 -> 36;
                case 39 -> 220;
                case 40 -> 210;
                case 41 -> 60;
                case 42 -> 39;
                case 43 -> 229;
                case 44 -> 0;
                case 45 -> 15;
                case 46 -> 152;
                case 47 -> 239;
                case 48 -> 169;
                case 49 -> 33;
                case 50 -> 94;
                case 51 -> 183;
                case 52 -> 237;
                case 53 -> 197;
                case 54 -> 146;
                case 55 -> 32;
                case 56 -> 128;
                case 57 -> 167;
                case 58 -> 72;
                case 59 -> 132;
                case 60 -> 65;
                case 61 -> 231;
                case 62 -> 159;
                case 63 -> 207;
                case 64 -> 224;
                case 65 -> 168;
                case 66 -> 174;
                case 67 -> 163;
                case 68 -> 255;
                case 69 -> 43;
                case 70 -> 99;
                case 71 -> 20;
                case 72 -> 162;
                case 73 -> 45;
                case 74 -> 30;
                case 75 -> 120;
                case 76 -> 8;
                case 77 -> 150;
                case 78 -> 57;
                case 79 -> 144;
                case 80 -> 247;
                case 81 -> 90;
                case 82 -> 226;
                case 83 -> 66;
                case 84 -> 4;
                case 85 -> 98;
                case 86 -> 123;
                case 87 -> 83;
                case 88 -> 78;
                case 89 -> 113;
                case 90 -> 109;
                case 91 -> 26;
                case 92 -> 91;
                case 93 -> 176;
                case 94 -> 202;
                case 95 -> 34;
                case 96 -> 115;
                case 97 -> 206;
                case 98 -> 55;
                case 99 -> 31;
                case 100 -> 49;
                case 101 -> 79;
                case 102 -> 160;
                case 103 -> 203;
                case 104 -> 234;
                case 105 -> 135;
                case 106 -> 108;
                case 107 -> 9;
                case 108 -> 110;
                case 109 -> 101;
                case 110 -> 112;
                case 111 -> 48;
                case 112 -> 161;
                case 113 -> 142;
                case 114 -> 133;
                case 115 -> 178;
                case 116 -> 217;
                case 117 -> 251;
                case 118 -> 195;
                case 119 -> 67;
                case 120 -> 95;
                case 121 -> 11;
                case 122 -> 240;
                case 123 -> 121;
                case 124 -> 23;
                case 125 -> 84;
                case 126 -> 172;
                case 127 -> 44;
                case 128 -> 87;
                case 129 -> 93;
                case 130 -> 69;
                case 131 -> 158;
                case 132 -> 137;
                case 133 -> 242;
                case 134 -> 61;
                case 135 -> 68;
                case 136 -> 38;
                case 137 -> 40;
                case 138 -> 2;
                case 139 -> 103;
                case 140 -> 92;
                case 141 -> 114;
                case 142 -> 19;
                case 143 -> 190;
                case 144 -> 186;
                case 145 -> 7;
                case 146 -> 215;
                case 147 -> 75;
                case 148 -> 225;
                case 149 -> 211;
                case 150 -> 28;
                case 151 -> 125;
                case 152 -> 76;
                case 153 -> 198;
                case 154 -> 47;
                case 155 -> 221;
                case 156 -> 51;
                case 157 -> 156;
                case 158 -> 126;
                case 159 -> 185;
                case 160 -> 88;
                case 161 -> 182;
                case 162 -> 208;
                case 163 -> 149;
                case 164 -> 27;
                case 165 -> 107;
                case 166 -> 6;
                case 167 -> 253;
                case 168 -> 188;
                case 169 -> 181;
                case 170 -> 70;
                case 171 -> 5;
                case 172 -> 119;
                case 173 -> 248;
                case 174 -> 232;
                case 175 -> 196;
                case 176 -> 230;
                case 177 -> 184;
                case 178 -> 74;
                case 179 -> 111;
                case 180 -> 127;
                case 181 -> 86;
                case 182 -> 130;
                case 183 -> 21;
                case 184 -> 77;
                case 185 -> 53;
                case 186 -> 25;
                case 187 -> 223;
                case 188 -> 18;
                case 189 -> 117;
                case 190 -> 42;
                case 191 -> 148;
                case 192 -> 71;
                case 193 -> 222;
                case 194 -> 233;
                case 195 -> 180;
                case 196 -> 131;
                case 197 -> 227;
                case 198 -> 189;
                case 199 -> 179;
                case 200 -> 171;
                case 201 -> 141;
                case 202 -> 245;
                case 203 -> 50;
                case 204 -> 201;
                case 205 -> 104;
                case 206 -> 97;
                case 207 -> 118;
                case 208 -> 14;
                case 209 -> 252;
                case 210 -> 249;
                case 211 -> 173;
                case 212 -> 235;
                case 213 -> 138;
                case 214 -> 243;
                case 215 -> 46;
                case 216 -> 199;
                case 217 -> 134;
                case 218 -> 13;
                case 219 -> 187;
                case 220 -> 212;
                case 221 -> 241;
                case 222 -> 41;
                case 223 -> 155;
                case 224 -> 200;
                case 225 -> 204;
                case 226 -> 10;
                case 227 -> 100;
                case 228 -> 145;
                case 229 -> 58;
                case 230 -> 254;
                case 231 -> 136;
                case 232 -> 64;
                case 233 -> 209;
                case 234 -> 73;
                case 235 -> 106;
                case 236 -> 122;
                case 237 -> 1;
                case 238 -> 191;
                case 239 -> 193;
                case 240 -> 62;
                case 241 -> 82;
                case 242 -> 17;
                case 243 -> 165;
                case 244 -> 29;
                case 245 -> 216;
                case 246 -> 35;
                case 247 -> 238;
                case 248 -> 192;
                case 249 -> 164;
                case 250 -> 228;
                case 251 -> 175;
                case 252 -> 154;
                case 253 -> 244;
                case 254 -> 153;
                default -> 89;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 34346909321298L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-55835820 + -6999, 55835820 + 6683, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 55938749575711L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.W();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1095483060 + -((char)-23653), -1095483060 + -((char)-19255), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1095483060 + -((char)-23654), 1095483060 + (char)-19196, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1095483060 + -((char)-23655), 1095483060 + (char)-23140, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00a9!uy~\u00db\u0096\u00f2\u0010\u0091\u0099\u0083\u00cf\u001a\u00b6\u00e3\u0006\u00c5\u00a0\u0002\u00cd\u00fb\u00cd\u0016V";
                    var4_3 = "\u00a9!uy~\u00db\u0096\u00f2\u0010\u0091\u0099\u0083\u00cf\u001a\u00b6\u00e3\u0006\u00c5\u00a0\u0002\u00cd\u00fb\u00cd\u0016V".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 120;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "A\u009eE\u00a3%5\u00f5\u0088\u00c4\r\u00c7\u00fam\tN\u00d7\u00cc\u00ce\u00f8j^\u0005\u00ceu b\u00dd_\u00fe\u0083\u00a7l\b\u001ai\u009a\u0018\u0013\u008e\u00f0\u00c7\u00be\u00afu\u00935<x[\u00a2<\u00cdj\u008d\u0001]t\u00c3\u00f0";
                        var4_3 = "A\u009eE\u00a3%5\u00f5\u0088\u00c4\r\u00c7\u00fam\tN\u00d7\u00cc\u00ce\u00f8j^\u0005\u00ceu b\u00dd_\u00fe\u0083\u00a7l\b\u001ai\u009a\u0018\u0013\u008e\u00f0\u00c7\u00be\u00afu\u00935<x[\u00a2<\u00cdj\u008d\u0001]t\u00c3\u00f0".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 80;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 59;
                                break;
                            }
                            case 1: {
                                v15 = 83;
                                break;
                            }
                            case 2: {
                                v15 = 94;
                                break;
                            }
                            case 3: {
                                v15 = 97;
                                break;
                            }
                            case 4: {
                                v15 = 66;
                                break;
                            }
                            case 5: {
                                v15 = 7;
                                break;
                            }
                            default: {
                                v15 = 72;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFAFAF) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 148;
                    case 1 -> 24;
                    case 2 -> 237;
                    case 3 -> 63;
                    case 4 -> 53;
                    case 5 -> 68;
                    case 6 -> 9;
                    case 7 -> 51;
                    case 8 -> 129;
                    case 9 -> 217;
                    case 10 -> 39;
                    case 11 -> 36;
                    case 12 -> 110;
                    case 13 -> 117;
                    case 14 -> 219;
                    case 15 -> 140;
                    case 16 -> 35;
                    case 17 -> 218;
                    case 18 -> 245;
                    case 19 -> 214;
                    case 20 -> 111;
                    case 21 -> 76;
                    case 22 -> 210;
                    case 23 -> 40;
                    case 24 -> 41;
                    case 25 -> 247;
                    case 26 -> 221;
                    case 27 -> 167;
                    case 28 -> 156;
                    case 29 -> 1;
                    case 30 -> 197;
                    case 31 -> 25;
                    case 32 -> 132;
                    case 33 -> 165;
                    case 34 -> 233;
                    case 35 -> 112;
                    case 36 -> 183;
                    case 37 -> 91;
                    case 38 -> 89;
                    case 39 -> 59;
                    case 40 -> 38;
                    case 41 -> 201;
                    case 42 -> 77;
                    case 43 -> 78;
                    case 44 -> 172;
                    case 45 -> 65;
                    case 46 -> 147;
                    case 47 -> 185;
                    case 48 -> 96;
                    case 49 -> 194;
                    case 50 -> 199;
                    case 51 -> 255;
                    case 52 -> 143;
                    case 53 -> 66;
                    case 54 -> 184;
                    case 55 -> 154;
                    case 56 -> 95;
                    case 57 -> 227;
                    case 58 -> 240;
                    case 59 -> 180;
                    case 60 -> 92;
                    case 61 -> 125;
                    case 62 -> 206;
                    case 63 -> 94;
                    case 64 -> 187;
                    case 65 -> 102;
                    case 66 -> 139;
                    case 67 -> 135;
                    case 68 -> 130;
                    case 69 -> 106;
                    case 70 -> 145;
                    case 71 -> 33;
                    case 72 -> 198;
                    case 73 -> 104;
                    case 74 -> 131;
                    case 75 -> 70;
                    case 76 -> 254;
                    case 77 -> 173;
                    case 78 -> 28;
                    case 79 -> 188;
                    case 80 -> 87;
                    case 81 -> 11;
                    case 82 -> 181;
                    case 83 -> 99;
                    case 84 -> 61;
                    case 85 -> 243;
                    case 86 -> 170;
                    case 87 -> 166;
                    case 88 -> 54;
                    case 89 -> 47;
                    case 90 -> 16;
                    case 91 -> 100;
                    case 92 -> 126;
                    case 93 -> 234;
                    case 94 -> 241;
                    case 95 -> 204;
                    case 96 -> 120;
                    case 97 -> 15;
                    case 98 -> 212;
                    case 99 -> 44;
                    case 100 -> 178;
                    case 101 -> 152;
                    case 102 -> 195;
                    case 103 -> 79;
                    case 104 -> 244;
                    case 105 -> 224;
                    case 106 -> 32;
                    case 107 -> 253;
                    case 108 -> 46;
                    case 109 -> 14;
                    case 110 -> 242;
                    case 111 -> 21;
                    case 112 -> 67;
                    case 113 -> 128;
                    case 114 -> 18;
                    case 115 -> 182;
                    case 116 -> 80;
                    case 117 -> 124;
                    case 118 -> 52;
                    case 119 -> 72;
                    case 120 -> 64;
                    case 121 -> 193;
                    case 122 -> 205;
                    case 123 -> 160;
                    case 124 -> 186;
                    case 125 -> 202;
                    case 126 -> 71;
                    case 127 -> 43;
                    case 128 -> 121;
                    case 129 -> 142;
                    case 130 -> 57;
                    case 131 -> 60;
                    case 132 -> 213;
                    case 133 -> 209;
                    case 134 -> 22;
                    case 135 -> 190;
                    case 136 -> 174;
                    case 137 -> 162;
                    case 138 -> 20;
                    case 139 -> 17;
                    case 140 -> 75;
                    case 141 -> 235;
                    case 142 -> 74;
                    case 143 -> 208;
                    case 144 -> 34;
                    case 145 -> 8;
                    case 146 -> 45;
                    case 147 -> 3;
                    case 148 -> 119;
                    case 149 -> 0;
                    case 150 -> 151;
                    case 151 -> 220;
                    case 152 -> 230;
                    case 153 -> 113;
                    case 154 -> 163;
                    case 155 -> 232;
                    case 156 -> 97;
                    case 157 -> 228;
                    case 158 -> 171;
                    case 159 -> 30;
                    case 160 -> 27;
                    case 161 -> 169;
                    case 162 -> 179;
                    case 163 -> 115;
                    case 164 -> 168;
                    case 165 -> 69;
                    case 166 -> 211;
                    case 167 -> 134;
                    case 168 -> 159;
                    case 169 -> 250;
                    case 170 -> 101;
                    case 171 -> 26;
                    case 172 -> 19;
                    case 173 -> 48;
                    case 174 -> 86;
                    case 175 -> 103;
                    case 176 -> 136;
                    case 177 -> 50;
                    case 178 -> 73;
                    case 179 -> 5;
                    case 180 -> 109;
                    case 181 -> 105;
                    case 182 -> 189;
                    case 183 -> 238;
                    case 184 -> 144;
                    case 185 -> 175;
                    case 186 -> 191;
                    case 187 -> 93;
                    case 188 -> 85;
                    case 189 -> 6;
                    case 190 -> 10;
                    case 191 -> 82;
                    case 192 -> 114;
                    case 193 -> 236;
                    case 194 -> 90;
                    case 195 -> 55;
                    case 196 -> 246;
                    case 197 -> 81;
                    case 198 -> 225;
                    case 199 -> 56;
                    case 200 -> 216;
                    case 201 -> 226;
                    case 202 -> 62;
                    case 203 -> 12;
                    case 204 -> 133;
                    case 205 -> 42;
                    case 206 -> 207;
                    case 207 -> 248;
                    case 208 -> 229;
                    case 209 -> 29;
                    case 210 -> 231;
                    case 211 -> 83;
                    case 212 -> 138;
                    case 213 -> 146;
                    case 214 -> 13;
                    case 215 -> 239;
                    case 216 -> 37;
                    case 217 -> 203;
                    case 218 -> 107;
                    case 219 -> 84;
                    case 220 -> 223;
                    case 221 -> 49;
                    case 222 -> 31;
                    case 223 -> 88;
                    case 224 -> 4;
                    case 225 -> 153;
                    case 226 -> 98;
                    case 227 -> 157;
                    case 228 -> 161;
                    case 229 -> 192;
                    case 230 -> 108;
                    case 231 -> 116;
                    case 232 -> 149;
                    case 233 -> 155;
                    case 234 -> 251;
                    case 235 -> 127;
                    case 236 -> 150;
                    case 237 -> 164;
                    case 238 -> 176;
                    case 239 -> 123;
                    case 240 -> 249;
                    case 241 -> 7;
                    case 242 -> 196;
                    case 243 -> 137;
                    case 244 -> 252;
                    case 245 -> 222;
                    case 246 -> 215;
                    case 247 -> 118;
                    case 248 -> 177;
                    case 249 -> 141;
                    case 250 -> 2;
                    case 251 -> 58;
                    case 252 -> 122;
                    case 253 -> 200;
                    case 254 -> 23;
                    default -> 158;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 124502537574749L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0015'=l7ozL\t\u0012-.fz-gPk";
                    var5_4 = "\u0015'=l7ozL\t\u0012-.fz-gPk".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 25;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 103;
                                    break;
                                }
                                case 1: {
                                    v11 = 91;
                                    break;
                                }
                                case 2: {
                                    v11 = 86;
                                    break;
                                }
                                case 3: {
                                    v11 = 27;
                                    break;
                                }
                                case 4: {
                                    v11 = 75;
                                    break;
                                }
                                case 5: {
                                    v11 = 26;
                                    break;
                                }
                                default: {
                                    v11 = 80;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 61749922264926L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u007fUo\u0001w\u000e\u0007\u0004yKc\u001b\nuTh\u001b{\f\u001f_Ua\tuTh\u001b{\f\u001fS_\rrRu\u0016q\u0001\u0005SXr\u001cp\b";
                    var5_4 = "\u007fUo\u0001w\u000e\u0007\u0004yKc\u001b\nuTh\u001b{\f\u001f_Ua\tuTh\u001b{\f\u001fS_\rrRu\u0016q\u0001\u0005SXr\u001cp\b".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 3;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "'\u0005;T%S^\u0006'\u0005;T)Y";
                        var5_4 = "'\u0005;T%S^\u0006'\u0005;T)Y".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 81;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 53;
                                break;
                            }
                            case 1: {
                                v15 = 56;
                                break;
                            }
                            case 2: {
                                v15 = 5;
                                break;
                            }
                            case 3: {
                                v15 = 118;
                                break;
                            }
                            case 4: {
                                v15 = 29;
                                break;
                            }
                            case 5: {
                                v15 = 108;
                                break;
                            }
                            default: {
                                v15 = 104;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 109598010949006L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-964544130 - -((char)-32220), 964544130 - (char)-26253, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 97336358097792L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00e4\u00f1\u00bd\u00d7{\u0003\u00f0\u00a2\u008b\u0005\u00d6p\u00dd#\u0094\rkP\\mQ\u00cf\u008e\u0015\u00c4\u0001\u00b1;\u00d3\u0010\u00c0\u00cc\u00ee\u00158U\u0088{\u00cdHs_m\u00b0\u00c5\u009c\u0005\u00cdi\u00be\u0000\u00f83,\u00d6\u0093\u0080B\u00a3\u00f7\u00b1_\u00ec\u00aa\u00e2\u0090VV_\u0095x\u009eV\u00af\u00f3\u009e\u00f4=\u00bf'4\u001e\u00a3\u00a34\u009a'\u00a7\u0003\u0011\u00ea\u00a9nsK\u008f\u00be\u00bda\u0096\u00a7\u0015\u0004N";
                    var4_3 = "\u00e4\u00f1\u00bd\u00d7{\u0003\u00f0\u00a2\u008b\u0005\u00d6p\u00dd#\u0094\rkP\\mQ\u00cf\u008e\u0015\u00c4\u0001\u00b1;\u00d3\u0010\u00c0\u00cc\u00ee\u00158U\u0088{\u00cdHs_m\u00b0\u00c5\u009c\u0005\u00cdi\u00be\u0000\u00f83,\u00d6\u0093\u0080B\u00a3\u00f7\u00b1_\u00ec\u00aa\u00e2\u0090VV_\u0095x\u009eV\u00af\u00f3\u009e\u00f4=\u00bf'4\u001e\u00a3\u00a34\u009a'\u00a7\u0003\u0011\u00ea\u00a9nsK\u008f\u00be\u00bda\u0096\u00a7\u0015\u0004N".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 39;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "a9\u008a\u00fb\u00e4\u00d8C\u009a\u00e4$\u0006\u0082\u0093[J\u00b1Ly\u00a8~\u0003P\u000f\u00bb\u000er%x\u001bR\u00e6\u00e1\u007f6\u00fdE@\u00ec\u0005\u008c\u00d8\f\u0081te\u00de\u0090\u0004m.\u00b2\u0010\u00fd\u0085\u00bbQr\ne?V\u00ee\u00f2g\u00bd\u0089#e\u00a2\u00b5\u00d3@\u00d0+N\u00a3\u00d0\u00ef\u00fe\u009a\u00bd\u0016J\u00fd\u0088\u0088o\u00ec\u009ex\u00fe\u0081\u00b7";
                        var4_3 = "a9\u008a\u00fb\u00e4\u00d8C\u009a\u00e4$\u0006\u0082\u0093[J\u00b1Ly\u00a8~\u0003P\u000f\u00bb\u000er%x\u001bR\u00e6\u00e1\u007f6\u00fdE@\u00ec\u0005\u008c\u00d8\f\u0081te\u00de\u0090\u0004m.\u00b2\u0010\u00fd\u0085\u00bbQr\ne?V\u00ee\u00f2g\u00bd\u0089#e\u00a2\u00b5\u00d3@\u00d0+N\u00a3\u00d0\u00ef\u00fe\u009a\u00bd\u0016J\u00fd\u0088\u0088o\u00ec\u009ex\u00fe\u0081\u00b7".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 53;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 39;
                                break;
                            }
                            case 1: {
                                v15 = 37;
                                break;
                            }
                            case 2: {
                                v15 = 46;
                                break;
                            }
                            case 3: {
                                v15 = 107;
                                break;
                            }
                            case 4: {
                                v15 = 119;
                                break;
                            }
                            case 5: {
                                v15 = 74;
                                break;
                            }
                            default: {
                                v15 = 117;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x62C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 125;
                    case 1 -> 88;
                    case 2 -> 143;
                    case 3 -> 222;
                    case 4 -> 50;
                    case 5 -> 28;
                    case 6 -> 168;
                    case 7 -> 138;
                    case 8 -> 126;
                    case 9 -> 201;
                    case 10 -> 214;
                    case 11 -> 146;
                    case 12 -> 54;
                    case 13 -> 81;
                    case 14 -> 154;
                    case 15 -> 30;
                    case 16 -> 220;
                    case 17 -> 206;
                    case 18 -> 119;
                    case 19 -> 100;
                    case 20 -> 35;
                    case 21 -> 106;
                    case 22 -> 84;
                    case 23 -> 180;
                    case 24 -> 226;
                    case 25 -> 186;
                    case 26 -> 221;
                    case 27 -> 111;
                    case 28 -> 233;
                    case 29 -> 44;
                    case 30 -> 187;
                    case 31 -> 67;
                    case 32 -> 161;
                    case 33 -> 38;
                    case 34 -> 3;
                    case 35 -> 68;
                    case 36 -> 33;
                    case 37 -> 210;
                    case 38 -> 205;
                    case 39 -> 108;
                    case 40 -> 32;
                    case 41 -> 189;
                    case 42 -> 31;
                    case 43 -> 112;
                    case 44 -> 73;
                    case 45 -> 7;
                    case 46 -> 86;
                    case 47 -> 46;
                    case 48 -> 195;
                    case 49 -> 51;
                    case 50 -> 208;
                    case 51 -> 71;
                    case 52 -> 174;
                    case 53 -> 216;
                    case 54 -> 57;
                    case 55 -> 148;
                    case 56 -> 18;
                    case 57 -> 92;
                    case 58 -> 96;
                    case 59 -> 155;
                    case 60 -> 115;
                    case 61 -> 234;
                    case 62 -> 107;
                    case 63 -> 8;
                    case 64 -> 23;
                    case 65 -> 135;
                    case 66 -> 77;
                    case 67 -> 236;
                    case 68 -> 36;
                    case 69 -> 114;
                    case 70 -> 22;
                    case 71 -> 248;
                    case 72 -> 199;
                    case 73 -> 237;
                    case 74 -> 159;
                    case 75 -> 25;
                    case 76 -> 225;
                    case 77 -> 60;
                    case 78 -> 164;
                    case 79 -> 173;
                    case 80 -> 93;
                    case 81 -> 6;
                    case 82 -> 104;
                    case 83 -> 109;
                    case 84 -> 175;
                    case 85 -> 158;
                    case 86 -> 141;
                    case 87 -> 95;
                    case 88 -> 59;
                    case 89 -> 13;
                    case 90 -> 239;
                    case 91 -> 124;
                    case 92 -> 85;
                    case 93 -> 144;
                    case 94 -> 69;
                    case 95 -> 39;
                    case 96 -> 70;
                    case 97 -> 249;
                    case 98 -> 163;
                    case 99 -> 76;
                    case 100 -> 40;
                    case 101 -> 181;
                    case 102 -> 12;
                    case 103 -> 254;
                    case 104 -> 136;
                    case 105 -> 162;
                    case 106 -> 166;
                    case 107 -> 4;
                    case 108 -> 224;
                    case 109 -> 188;
                    case 110 -> 251;
                    case 111 -> 79;
                    case 112 -> 131;
                    case 113 -> 105;
                    case 114 -> 63;
                    case 115 -> 240;
                    case 116 -> 196;
                    case 117 -> 116;
                    case 118 -> 255;
                    case 119 -> 230;
                    case 120 -> 122;
                    case 121 -> 49;
                    case 122 -> 231;
                    case 123 -> 14;
                    case 124 -> 167;
                    case 125 -> 229;
                    case 126 -> 177;
                    case 127 -> 118;
                    case 128 -> 149;
                    case 129 -> 37;
                    case 130 -> 29;
                    case 131 -> 156;
                    case 132 -> 245;
                    case 133 -> 127;
                    case 134 -> 184;
                    case 135 -> 26;
                    case 136 -> 74;
                    case 137 -> 213;
                    case 138 -> 140;
                    case 139 -> 83;
                    case 140 -> 147;
                    case 141 -> 129;
                    case 142 -> 200;
                    case 143 -> 52;
                    case 144 -> 165;
                    case 145 -> 78;
                    case 146 -> 217;
                    case 147 -> 45;
                    case 148 -> 203;
                    case 149 -> 16;
                    case 150 -> 97;
                    case 151 -> 209;
                    case 152 -> 152;
                    case 153 -> 90;
                    case 154 -> 102;
                    case 155 -> 176;
                    case 156 -> 47;
                    case 157 -> 202;
                    case 158 -> 120;
                    case 159 -> 169;
                    case 160 -> 91;
                    case 161 -> 53;
                    case 162 -> 227;
                    case 163 -> 190;
                    case 164 -> 80;
                    case 165 -> 123;
                    case 166 -> 99;
                    case 167 -> 133;
                    case 168 -> 211;
                    case 169 -> 212;
                    case 170 -> 242;
                    case 171 -> 247;
                    case 172 -> 215;
                    case 173 -> 197;
                    case 174 -> 41;
                    case 175 -> 11;
                    case 176 -> 9;
                    case 177 -> 151;
                    case 178 -> 65;
                    case 179 -> 110;
                    case 180 -> 128;
                    case 181 -> 117;
                    case 182 -> 160;
                    case 183 -> 153;
                    case 184 -> 228;
                    case 185 -> 183;
                    case 186 -> 130;
                    case 187 -> 185;
                    case 188 -> 10;
                    case 189 -> 192;
                    case 190 -> 121;
                    case 191 -> 87;
                    case 192 -> 182;
                    case 193 -> 157;
                    case 194 -> 62;
                    case 195 -> 72;
                    case 196 -> 0;
                    case 197 -> 178;
                    case 198 -> 171;
                    case 199 -> 64;
                    case 200 -> 94;
                    case 201 -> 24;
                    case 202 -> 132;
                    case 203 -> 170;
                    case 204 -> 48;
                    case 205 -> 142;
                    case 206 -> 223;
                    case 207 -> 241;
                    case 208 -> 56;
                    case 209 -> 21;
                    case 210 -> 113;
                    case 211 -> 235;
                    case 212 -> 15;
                    case 213 -> 218;
                    case 214 -> 244;
                    case 215 -> 66;
                    case 216 -> 137;
                    case 217 -> 101;
                    case 218 -> 75;
                    case 219 -> 55;
                    case 220 -> 246;
                    case 221 -> 238;
                    case 222 -> 43;
                    case 223 -> 219;
                    case 224 -> 82;
                    case 225 -> 89;
                    case 226 -> 134;
                    case 227 -> 139;
                    case 228 -> 252;
                    case 229 -> 232;
                    case 230 -> 19;
                    case 231 -> 191;
                    case 232 -> 172;
                    case 233 -> 150;
                    case 234 -> 193;
                    case 235 -> 34;
                    case 236 -> 253;
                    case 237 -> 58;
                    case 238 -> 250;
                    case 239 -> 179;
                    case 240 -> 194;
                    case 241 -> 2;
                    case 242 -> 198;
                    case 243 -> 27;
                    case 244 -> 20;
                    case 245 -> 207;
                    case 246 -> 61;
                    case 247 -> 5;
                    case 248 -> 243;
                    case 249 -> 103;
                    case 250 -> 204;
                    case 251 -> 17;
                    case 252 -> 145;
                    case 253 -> 42;
                    case 254 -> 98;
                    default -> 1;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 132412268722942L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1572971070 + (char)-13156, 1572971070 + (char)-29627, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 122954014427696L;
                    int[] nArray = SshAgentIpcService.W();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1985710500 - -((char)-6215), 1985710500 - (char)-14665, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 113262927866055L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "eMG\u0001\"\u0003\u001d\u00b6\u001e";
                var4_3 = "eMG\u0001\"\u0003\u001d\u00b6\u001e".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 106;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 55;
                                break;
                            }
                            case 1: {
                                v11 = 48;
                                break;
                            }
                            case 2: {
                                v11 = 2;
                                break;
                            }
                            case 3: {
                                v11 = 108;
                                break;
                            }
                            case 4: {
                                v11 = 16;
                                break;
                            }
                            case 5: {
                                v11 = 31;
                                break;
                            }
                            default: {
                                v11 = 97;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD424) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 143;
                    case 1 -> 161;
                    case 2 -> 236;
                    case 3 -> 154;
                    case 4 -> 118;
                    case 5 -> 10;
                    case 6 -> 168;
                    case 7 -> 192;
                    case 8 -> 144;
                    case 9 -> 95;
                    case 10 -> 93;
                    case 11 -> 128;
                    case 12 -> 185;
                    case 13 -> 202;
                    case 14 -> 159;
                    case 15 -> 223;
                    case 16 -> 140;
                    case 17 -> 241;
                    case 18 -> 30;
                    case 19 -> 33;
                    case 20 -> 24;
                    case 21 -> 127;
                    case 22 -> 25;
                    case 23 -> 237;
                    case 24 -> 97;
                    case 25 -> 182;
                    case 26 -> 155;
                    case 27 -> 178;
                    case 28 -> 148;
                    case 29 -> 103;
                    case 30 -> 194;
                    case 31 -> 72;
                    case 32 -> 214;
                    case 33 -> 106;
                    case 34 -> 51;
                    case 35 -> 131;
                    case 36 -> 244;
                    case 37 -> 31;
                    case 38 -> 240;
                    case 39 -> 53;
                    case 40 -> 224;
                    case 41 -> 96;
                    case 42 -> 135;
                    case 43 -> 2;
                    case 44 -> 69;
                    case 45 -> 156;
                    case 46 -> 252;
                    case 47 -> 5;
                    case 48 -> 172;
                    case 49 -> 22;
                    case 50 -> 1;
                    case 51 -> 215;
                    case 52 -> 177;
                    case 53 -> 59;
                    case 54 -> 212;
                    case 55 -> 167;
                    case 56 -> 36;
                    case 57 -> 253;
                    case 58 -> 249;
                    case 59 -> 132;
                    case 60 -> 197;
                    case 61 -> 12;
                    case 62 -> 6;
                    case 63 -> 188;
                    case 64 -> 170;
                    case 65 -> 136;
                    case 66 -> 227;
                    case 67 -> 111;
                    case 68 -> 82;
                    case 69 -> 91;
                    case 70 -> 66;
                    case 71 -> 58;
                    case 72 -> 174;
                    case 73 -> 100;
                    case 74 -> 73;
                    case 75 -> 250;
                    case 76 -> 186;
                    case 77 -> 133;
                    case 78 -> 160;
                    case 79 -> 35;
                    case 80 -> 52;
                    case 81 -> 209;
                    case 82 -> 108;
                    case 83 -> 23;
                    case 84 -> 134;
                    case 85 -> 74;
                    case 86 -> 15;
                    case 87 -> 65;
                    case 88 -> 218;
                    case 89 -> 60;
                    case 90 -> 152;
                    case 91 -> 191;
                    case 92 -> 245;
                    case 93 -> 54;
                    case 94 -> 239;
                    case 95 -> 141;
                    case 96 -> 62;
                    case 97 -> 150;
                    case 98 -> 139;
                    case 99 -> 9;
                    case 100 -> 49;
                    case 101 -> 86;
                    case 102 -> 247;
                    case 103 -> 175;
                    case 104 -> 157;
                    case 105 -> 125;
                    case 106 -> 102;
                    case 107 -> 13;
                    case 108 -> 99;
                    case 109 -> 32;
                    case 110 -> 207;
                    case 111 -> 3;
                    case 112 -> 63;
                    case 113 -> 114;
                    case 114 -> 123;
                    case 115 -> 83;
                    case 116 -> 235;
                    case 117 -> 171;
                    case 118 -> 228;
                    case 119 -> 251;
                    case 120 -> 216;
                    case 121 -> 16;
                    case 122 -> 166;
                    case 123 -> 20;
                    case 124 -> 107;
                    case 125 -> 94;
                    case 126 -> 213;
                    case 127 -> 87;
                    case 128 -> 187;
                    case 129 -> 129;
                    case 130 -> 147;
                    case 131 -> 193;
                    case 132 -> 233;
                    case 133 -> 243;
                    case 134 -> 195;
                    case 135 -> 77;
                    case 136 -> 230;
                    case 137 -> 101;
                    case 138 -> 117;
                    case 139 -> 48;
                    case 140 -> 254;
                    case 141 -> 189;
                    case 142 -> 211;
                    case 143 -> 221;
                    case 144 -> 68;
                    case 145 -> 121;
                    case 146 -> 138;
                    case 147 -> 76;
                    case 148 -> 88;
                    case 149 -> 7;
                    case 150 -> 163;
                    case 151 -> 232;
                    case 152 -> 142;
                    case 153 -> 203;
                    case 154 -> 151;
                    case 155 -> 39;
                    case 156 -> 198;
                    case 157 -> 248;
                    case 158 -> 219;
                    case 159 -> 217;
                    case 160 -> 38;
                    case 161 -> 46;
                    case 162 -> 110;
                    case 163 -> 40;
                    case 164 -> 176;
                    case 165 -> 79;
                    case 166 -> 231;
                    case 167 -> 145;
                    case 168 -> 153;
                    case 169 -> 89;
                    case 170 -> 71;
                    case 171 -> 119;
                    case 172 -> 179;
                    case 173 -> 81;
                    case 174 -> 34;
                    case 175 -> 122;
                    case 176 -> 225;
                    case 177 -> 246;
                    case 178 -> 162;
                    case 179 -> 28;
                    case 180 -> 115;
                    case 181 -> 43;
                    case 182 -> 105;
                    case 183 -> 130;
                    case 184 -> 14;
                    case 185 -> 238;
                    case 186 -> 234;
                    case 187 -> 184;
                    case 188 -> 84;
                    case 189 -> 204;
                    case 190 -> 98;
                    case 191 -> 29;
                    case 192 -> 67;
                    case 193 -> 181;
                    case 194 -> 47;
                    case 195 -> 113;
                    case 196 -> 222;
                    case 197 -> 85;
                    case 198 -> 112;
                    case 199 -> 21;
                    case 200 -> 190;
                    case 201 -> 104;
                    case 202 -> 0;
                    case 203 -> 196;
                    case 204 -> 206;
                    case 205 -> 137;
                    case 206 -> 61;
                    case 207 -> 201;
                    case 208 -> 229;
                    case 209 -> 27;
                    case 210 -> 120;
                    case 211 -> 205;
                    case 212 -> 180;
                    case 213 -> 210;
                    case 214 -> 8;
                    case 215 -> 56;
                    case 216 -> 220;
                    case 217 -> 41;
                    case 218 -> 124;
                    case 219 -> 109;
                    case 220 -> 200;
                    case 221 -> 17;
                    case 222 -> 75;
                    case 223 -> 149;
                    case 224 -> 42;
                    case 225 -> 116;
                    case 226 -> 37;
                    case 227 -> 226;
                    case 228 -> 45;
                    case 229 -> 255;
                    case 230 -> 173;
                    case 231 -> 92;
                    case 232 -> 208;
                    case 233 -> 19;
                    case 234 -> 90;
                    case 235 -> 4;
                    case 236 -> 169;
                    case 237 -> 44;
                    case 238 -> 183;
                    case 239 -> 26;
                    case 240 -> 158;
                    case 241 -> 80;
                    case 242 -> 199;
                    case 243 -> 165;
                    case 244 -> 164;
                    case 245 -> 70;
                    case 246 -> 146;
                    case 247 -> 55;
                    case 248 -> 126;
                    case 249 -> 242;
                    case 250 -> 64;
                    case 251 -> 11;
                    case 252 -> 57;
                    case 253 -> 50;
                    case 254 -> 78;
                    default -> 18;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

