/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.completion.PhpUsageContextArrayIndexCompletionProviderBase;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionScalarArgumentLookupElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PhpSqlSelectedFieldsCompletionContributor
extends CompletionContributor {
    public PhpSqlSelectedFieldsCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, ArrayIndex.class), (CompletionProvider)new PhpSqlSelectedFieldsCompletionProvider());
    }

    private static Collection<SqlSelectStatement> tryFetchSqlStatements(PsiElement element, int assignmentJumpsLeft) {
        Collection<SqlSelectStatement> sqlSelectStatements;
        if (element instanceof StringLiteralExpression || element instanceof ConcatenationExpression) {
            return PhpSqlSelectedFieldsCompletionContributor.getSqlSelectStatements(element);
        }
        while (element instanceof MethodReference) {
            Collection<SqlSelectStatement> statements = PhpSqlSelectedFieldsCompletionContributor.tryFetchSqlStatements((FunctionReference)element, assignmentJumpsLeft);
            if (!statements.isEmpty()) {
                return statements;
            }
            element = ((MethodReference)element).getClassReference();
        }
        if (element instanceof FunctionReference && !(sqlSelectStatements = PhpSqlSelectedFieldsCompletionContributor.tryFetchSqlStatements((FunctionReference)element, assignmentJumpsLeft)).isEmpty()) {
            return sqlSelectStatements;
        }
        if (assignmentJumpsLeft > 0 && element instanceof Variable) {
            for (PsiElement value : PhpSqlSelectedFieldsCompletionContributor.getAssignedValues((Variable)element)) {
                Collection<SqlSelectStatement> statements = PhpSqlSelectedFieldsCompletionContributor.tryFetchSqlStatements(value, assignmentJumpsLeft - 1);
                if (statements.isEmpty()) continue;
                return statements;
            }
        }
        return Collections.emptySet();
    }

    private static Collection<SqlSelectStatement> tryFetchSqlStatements(FunctionReference element, int assignmentJumps) {
        for (PsiElement parameter : element.getParameters()) {
            Collection<SqlSelectStatement> sqlSelectStatements = PhpSqlSelectedFieldsCompletionContributor.tryFetchSqlStatements(parameter, assignmentJumps);
            if (sqlSelectStatements.isEmpty()) continue;
            return sqlSelectStatements;
        }
        return Collections.emptySet();
    }

    private static LookupElement remapLookupElement(LookupElement e) {
        return e instanceof PhpExpectedFunctionScalarArgumentLookupElement && ((PhpExpectedFunctionScalarArgumentLookupElement)e).isInsideStringLiteral() ? LookupElementBuilder.create((String)e.getLookupString()) : e;
    }

    private static Collection<String> getSelectedColumnNames(SqlSelectStatement statement) {
        Collection<String> collection;
        DasType dasType;
        SqlQueryExpression expression = statement.getQueryExpression();
        if (expression != null && (dasType = expression.getDasType()) instanceof DasTableType) {
            DasTableType tableType = (DasTableType)dasType;
            collection = PhpSqlSelectedFieldsCompletionContributor.getColumnNames(tableType);
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getColumnNames(DasTableType t) {
        Collection collection = IntStream.range(0, t.getColumnCount()).mapToObj(i -> t.getColumnName(i)).collect(Collectors.toSet());
        if (collection == null) {
            PhpSqlSelectedFieldsCompletionContributor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static Collection<SqlSelectStatement> getSqlSelectStatements(PsiElement parameter) {
        HashSet<SqlSelectStatement> res = new HashSet<SqlSelectStatement>();
        for (StringLiteralExpression expression : PhpPsiUtil.findChildrenNonStrict((PsiElement)parameter, StringLiteralExpression.class)) {
            List files = InjectedLanguageManager.getInstance((Project)parameter.getProject()).getInjectedPsiFiles((PsiElement)expression);
            if (files == null) continue;
            for (Pair file : files) {
                if (!(file.first instanceof SqlFile)) continue;
                res.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)file.first), SqlSelectStatement.class));
            }
        }
        return res;
    }

    private static Collection<PsiElement> getAssignedValues(Variable target) {
        PhpAccessVariableInstruction instruction = (PhpAccessVariableInstruction)PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)target, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return Collections.emptyList();
        }
        final HashSet<PsiElement> res = new HashSet<PsiElement>();
        PhpControlFlowUtil.processPreviousVariableAccesses((PhpAccessVariableInstruction)instruction, (boolean)false, (PhpInstructionProcessor)new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.getAccess().isWrite()) {
                    PsiElement assignedValue = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                    if (assignedValue != null) {
                        res.add(assignedValue);
                    } else {
                        ForeachStatement foreach;
                        PsiElement psiElement = instruction.getAnchor().getParent();
                        if (psiElement instanceof ForeachStatement && (foreach = (ForeachStatement)psiElement).getValue() == instruction.getAnchor()) {
                            ContainerUtil.addIfNotNull((Collection)res, (Object)foreach.getArray());
                        }
                    }
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/PhpSqlSelectedFieldsCompletionContributor", "getColumnNames"));
    }

    private static class PhpSqlSelectedFieldsCompletionProvider
    extends PhpUsageContextArrayIndexCompletionProviderBase {
        private PhpSqlSelectedFieldsCompletionProvider() {
        }

        protected Stream<LookupElement> getLookupElements(PhpPsiElement parent, Collection<String> arrayIndexKeysFromUsageContext) {
            return super.getLookupElements(parent, arrayIndexKeysFromUsageContext).map(PhpSqlSelectedFieldsCompletionContributor::remapLookupElement);
        }

        protected Collection<String> getArrayIndexKeysFromUsageContext(@NotNull PsiElement variable) {
            if (variable == null) {
                PhpSqlSelectedFieldsCompletionProvider.$$$reportNull$$$0(0);
            }
            return PhpSqlSelectedFieldsCompletionContributor.tryFetchSqlStatements(variable, AdvancedSettings.getInt((String)"php.sql.completion.recursive.jumps.limit")).stream().flatMap(statement -> PhpSqlSelectedFieldsCompletionContributor.getSelectedColumnNames(statement).stream()).collect(Collectors.toSet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/jetbrains/php/completion/PhpSqlSelectedFieldsCompletionContributor$PhpSqlSelectedFieldsCompletionProvider", "getArrayIndexKeysFromUsageContext"));
        }
    }
}

