/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.TargetResolver;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedImportTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class PhingBuildFileParsedData {
    private final PhingBuildFile myFile;
    private final CachedValue<List<PhingBuildTarget>> myTargets;

    public PhingBuildFileParsedData(PhingBuildFile file, Project project) {
        this.myFile = file;
        this.myTargets = new PsiCachedValueImpl.Soft(PsiManager.getInstance((Project)project), (CachedValueProvider)new BuildFileCachedProvider());
    }

    public List<PhingBuildTarget> getTargets() {
        return (List)this.myTargets.getValue();
    }

    private class BuildFileCachedProvider
    implements CachedValueProvider<List<PhingBuildTarget>> {
        private BuildFileCachedProvider() {
        }

        public CachedValueProvider.Result<List<PhingBuildTarget>> compute() {
            HashSet<Object> dependencies = new HashSet<Object>();
            XmlFile psiFile = PhingUtils.getPhingXmlFile(PhingBuildFileParsedData.this.myFile.getFile(), PhingBuildFileParsedData.this.myFile.getProject());
            dependencies.add(psiFile);
            PhingPredefinedProject domProject = PhingUtils.getPhingDomProject((PsiFile)psiFile);
            if (domProject == null) {
                if (psiFile != null) {
                    return new CachedValueProvider.Result(Collections.emptyList(), new Object[]{psiFile});
                }
                return new CachedValueProvider.Result(Collections.emptyList(), new Object[]{PhingBuildFileParsedData.this.myFile.getFile()});
            }
            ArrayList<PhingBuildTarget> result = new ArrayList<PhingBuildTarget>();
            PhingPredefinedTarget defaultTarget = null;
            GenericAttributeValue<TargetResolver.Result> defaultTargetValue = domProject.findDefaultTarget();
            TargetResolver.Result targetResolverResult = (TargetResolver.Result)defaultTargetValue.getValue();
            if (targetResolverResult != null) {
                Pair<PhingPredefinedTarget, String> targetWithName = targetResolverResult.getResolvedTarget(domProject.findDefaultTarget().getRawText());
                defaultTarget = (PhingPredefinedTarget)Pair.getFirst(targetWithName);
            }
            HashSet<PhingPredefinedProject> projects = new HashSet<PhingPredefinedProject>();
            projects.add(domProject);
            for (PhingPredefinedImportTask importTask : domProject.findImportTasks()) {
                PsiFile containingFile;
                PhingPredefinedProject domImportedProject;
                PsiFileSystemItem psiItem = (PsiFileSystemItem)importTask.findFile().getValue();
                if (psiItem == null || (domImportedProject = PhingUtils.getPhingDomProject(containingFile = psiItem.getContainingFile())) == null) continue;
                projects.add(domImportedProject);
                dependencies.add(containingFile);
            }
            for (PhingPredefinedProject project : projects) {
                for (PhingPredefinedTarget target : project.findTargets()) {
                    DomTarget domTarget = PhingUtils.getDomTarget(target);
                    int textOffset = domTarget != null ? domTarget.getTextOffset() : target.getXmlTag().getTextOffset();
                    Boolean hidden = (Boolean)target.findHidden().getValue();
                    result.add(new PhingBuildTarget((String)target.findName().getValue(), (String)target.findDescription().getValue(), target.equals(defaultTarget), target.ensureTagExists().getContainingFile().getVirtualFile(), textOffset, PhingBuildFileParsedData.this.myFile, hidden == null ? false : hidden));
                }
            }
            return CachedValueProvider.Result.create(result, dependencies);
        }
    }
}

