/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.php.phing.InvalidPhingFileException;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.ui.explorer.PhingToolWindowFactory;
import org.jetbrains.annotations.NotNull;

public class AddPhingBuildFileAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AddPhingBuildFileAction.class);

    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext dataContext;
        Project project;
        if (event == null) {
            AddPhingBuildFileAction.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((project = (Project)CommonDataKeys.PROJECT.getData(dataContext = event.getDataContext())) != null);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        LOG.assertTrue(file != null);
        PhingStateService phingState = PhingStateService.getInstance(project);
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        try {
            phingState.addBuildFile(file);
            toolWindowManager.getToolWindow(PhingToolWindowFactory.getWindowId()).activate(null);
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile != null) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
            }
        }
        catch (InvalidPhingFileException e) {
            String message = PhingBundle.message("can.t.add.0.as.phing.build.file.1", file.getPresentableUrl(), e.getMessage());
            if (message.length() == 0) {
                message = PhingBundle.message("cannot.add.build.files.from.excluded.directories.error.message", e.getFile().getPresentableUrl());
            }
            if (toolWindowManager.getToolWindow(PhingToolWindowFactory.getWindowId()) != null) {
                toolWindowManager.notifyByBalloon(PhingToolWindowFactory.getWindowId(), MessageType.ERROR, message);
            }
            Messages.showWarningDialog((Project)project, (String)message, (String)PhingBundle.message("cannot.add.build.file.dialog.title", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddPhingBuildFileAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddPhingBuildFileAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null || project.isDefault()) {
            AddPhingBuildFileAction.disable(presentation);
            return;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file == null) {
            AddPhingBuildFileAction.disable(presentation);
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            AddPhingBuildFileAction.disable(presentation);
            return;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            AddPhingBuildFileAction.disable(presentation);
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            AddPhingBuildFileAction.disable(presentation);
            return;
        }
        if (!"project".equals(rootTag.getName())) {
            AddPhingBuildFileAction.disable(presentation);
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || PhingStateService.getInstance(project).getBuildFile(virtualFile) != null) {
            AddPhingBuildFileAction.disable(presentation);
            return;
        }
        AddPhingBuildFileAction.enable(presentation);
    }

    private static void enable(Presentation presentation) {
        presentation.setEnabledAndVisible(true);
    }

    private static void disable(Presentation presentation) {
        presentation.setEnabledAndVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/actions/AddPhingBuildFileAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/actions/AddPhingBuildFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

