/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PhingCreateTargetQuickFix
implements LocalQuickFix {
    @NonNls
    private static final String TARGET_TAG_NAME = "target";
    @NonNls
    private static final String NAME_ATTRIBUTE_NAME = "name";
    @FileModifier.SafeFieldForPreview
    private final PhingPredefinedProject myProject;
    private final String myTargetName;

    public PhingCreateTargetQuickFix(PhingPredefinedProject element, String targetName) {
        this.myProject = element.findPhingProject();
        this.myTargetName = targetName;
    }

    @NotNull
    public String getName() {
        String string = PhingBundle.message("create.target.quickfix.name", this.myTargetName);
        if (string == null) {
            PhingCreateTargetQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhingBundle.message("phing.inspection.group.name", new Object[0]);
        if (string == null) {
            PhingCreateTargetQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhingCreateTargetQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhingCreateTargetQuickFix.$$$reportNull$$$0(3);
        }
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        template.addTextSegment("<target name=\"" + this.myTargetName + "\">\n");
        template.addEndVariable();
        template.addTextSegment("\n</target>\n");
        PhingCreateTargetQuickFix.insertTemplate(project, template, PhingCreateTargetQuickFix.getTemplateOffset(this.myProject.getXmlTag()), this.myProject);
    }

    static void insertTemplate(Project project, Template template, int offset, PhingPredefinedElement domElement) {
        template.setToReformat(true);
        VirtualFile vFile = domElement.getXmlTag().getContainingFile().getVirtualFile();
        assert (vFile != null);
        PsiNavigationSupport.getInstance().createNavigatable(project, vFile, offset).navigate(true);
        FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(vFile);
        TemplateManager.getInstance((Project)project).startTemplate(((TextEditor)editor).getEditor(), template);
    }

    private static int getTemplateOffset(XmlTag tag) {
        PsiElement lastChild;
        ASTNode projectEndTag = tag.getNode().findChildByType(XmlTokenType.XML_END_TAG_START);
        int offset = projectEndTag == null ? ((lastChild = tag.getLastChild()) == null ? tag.getTextOffset() : lastChild.getTextRange().getEndOffset()) : projectEndTag.getTextRange().getStartOffset();
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/PhingCreateTargetQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/PhingCreateTargetQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

