/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.phing.dom.PhingDomFileReference;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedImportTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedPhingTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhingDomFileReferenceSet
extends FileReferenceSet {
    private final GenericAttributeValue<?> myValue;

    public PhingDomFileReferenceSet(GenericAttributeValue<?> attribValue) {
        this(attribValue, attribValue.getRawText(), 0);
    }

    private PhingDomFileReferenceSet(GenericAttributeValue<?> attribValue, String pathSubstring, int beginOffset) {
        super(PhingDomFileReferenceSet.cutTrailingSlash(FileUtil.toSystemIndependentName((String)pathSubstring)), (PsiElement)attribValue.getXmlAttributeValue(), ElementManipulators.getOffsetInElement((PsiElement)attribValue.getXmlAttributeValue()) + beginOffset, null, attribValue.getXmlAttribute().getContainingFile().getViewProvider().getVirtualFile().isCaseSensitive());
        this.myValue = attribValue;
    }

    public GenericAttributeValue<?> getAttributeValue() {
        return this.myValue;
    }

    private static String cutTrailingSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected boolean isSoft() {
        return true;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new PhingDomFileReference(this, range, index, text);
    }

    @NotNull
    public XmlAttributeValue getElement() {
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)super.getElement();
        if (xmlAttributeValue == null) {
            PhingDomFileReferenceSet.$$$reportNull$$$0(0);
        }
        return xmlAttributeValue;
    }

    @NlsSafe
    @NotNull
    public String getPathString() {
        String string = this.myValue.getStringValue();
        if (string == null) {
            PhingDomFileReferenceSet.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAbsolutePathReference() {
        if (super.isAbsolutePathReference()) {
            return true;
        }
        String pathString = this.getPathString();
        return FileUtil.isAbsolute((String)pathString);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PhingPredefinedProject containingProject;
        PhingPredefinedElement element = (PhingPredefinedElement)this.myValue.getParentOfType(PhingPredefinedElement.class, false);
        PhingPredefinedProject phingPredefinedProject = containingProject = element != null ? element.findPhingProject() : null;
        if (containingProject != null) {
            String basedir;
            PsiFileSystemItem dirValue;
            if (this.isAbsolutePathReference()) {
                Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                if (collection == null) {
                    PhingDomFileReferenceSet.$$$reportNull$$$0(2);
                }
                return collection;
            }
            VirtualFile root = null;
            if (element instanceof PhingPredefinedPhingTask && (dirValue = (PsiFileSystemItem)((PhingPredefinedPhingTask)element).findDir().getValue()) instanceof PsiDirectory) {
                root = dirValue.getVirtualFile();
            }
            if (root == null && (basedir = element instanceof PhingPredefinedImportTask ? containingProject.getContainingFileDir() : containingProject.getProjectBasedirPath()) != null) {
                root = LocalFileSystem.getInstance().findFileByPath(basedir);
            }
            if (root != null) {
                Collection collection = this.toFileSystemItems(new VirtualFile[]{root});
                if (collection == null) {
                    PhingDomFileReferenceSet.$$$reportNull$$$0(3);
                }
                return collection;
            }
        }
        Collection collection = super.computeDefaultContexts();
        if (collection == null) {
            PhingDomFileReferenceSet.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/phing/dom/PhingDomFileReferenceSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

