/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.phing.dom.PhingDomFileDescription;
import com.jetbrains.php.phing.dom.PhingDomFileReferenceSet;
import com.jetbrains.php.phing.dom.PhingDomPropertyValueConverter;
import com.jetbrains.php.phing.dom.PhingPathConverter;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class PhingPathCompletionHandler
extends CompletionContributor
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(PhingPathCompletionHandler.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiFile file;
        if (parameters == null) {
            PhingPathCompletionHandler.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PhingPathCompletionHandler.$$$reportNull$$$0(1);
        }
        if (!((file = parameters.getOriginalFile()) instanceof XmlFile) || !PhingDomFileDescription.isPhingFile((XmlFile)file)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (position instanceof XmlToken && parent instanceof XmlAttributeValue) {
            XmlAttribute attribute = (XmlAttribute)PhpPsiUtil.getParentOfClass((PsiElement)parent, XmlAttribute.class);
            if (attribute == null) {
                return;
            }
            Project project = parent.getProject();
            GenericAttributeValue attributeValue = DomManager.getDomManager((Project)project).getDomElement(attribute);
            if (attributeValue == null) {
                return;
            }
            if (!(attributeValue.getConverter() instanceof PhingPathConverter) && !(attributeValue.getConverter() instanceof PhingDomPropertyValueConverter)) {
                return;
            }
            PhingDomFileReferenceSet referenceSet = new PhingDomFileReferenceSet(attributeValue);
            int offset = parameters.getOffset() - attributeValue.getXmlAttributeValue().getTextRange().getStartOffset();
            int prefixOffset = parameters.getOffset() - position.getTextOffset();
            String prefix = attributeValue.getRawText().substring(0, prefixOffset);
            if (prefix.startsWith("${")) {
                return;
            }
            String prefixToCheck = result.getPrefixMatcher().getPrefix();
            for (FileReference reference : referenceSet.getAllReferences()) {
                if (!reference.getRangeInElement().contains(offset)) continue;
                int prefixIndex = prefix.indexOf(prefixToCheck);
                if (prefixIndex == -1 || prefixIndex > reference.getRangeInElement().getStartOffset() - 1) {
                    LOG.warn("Prefix to check is larger than attribute's: in attribute value ''" + prefix + "'', but prefix to check is ''" + prefixToCheck + "''.");
                    continue;
                }
                String prefixForName = prefix.substring(prefixIndex, reference.getRangeInElement().getStartOffset() - 1);
                for (Object o : reference.getVariants()) {
                    Icon icon;
                    String itemText;
                    if (o instanceof PsiFileSystemItem) {
                        itemText = PsiUtilCore.getName((PsiElement)((PsiElement)o));
                        icon = ((PsiElement)o).getIcon(1);
                    } else if (o instanceof LookupElementBuilder) {
                        if (((LookupElementBuilder)o).getObject() instanceof PsiElement) {
                            icon = ((PsiElement)((LookupElementBuilder)o).getObject()).getIcon(1);
                            itemText = PsiUtilCore.getName((PsiElement)((PsiElement)((LookupElementBuilder)o).getObject()));
                        } else {
                            itemText = ((LookupElementBuilder)o).getLookupString();
                            icon = null;
                        }
                    } else {
                        LOG.error("Unexpected completion variant: " + o);
                        continue;
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((Object)o, (String)(prefixForName + itemText)).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

                        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                            presentation.setItemText(itemText);
                            if (icon != null) {
                                presentation.setIcon(icon);
                            }
                        }
                    }));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/phing/dom/PhingPathCompletionHandler";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

