/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.jetbrains.php.phing.dom.PhingDomFileReferenceSet;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingPathConverter
extends Converter<PsiFileSystemItem>
implements CustomReferenceConverter<PsiFileSystemItem> {
    public PsiFileSystemItem fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        VirtualFile vFile;
        GenericAttributeValue attribValue;
        if (context == null) {
            PhingPathConverter.$$$reportNull$$$0(0);
        }
        if ((attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false)) == null) {
            return null;
        }
        String path = attribValue.getStringValue();
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            PhingPredefinedProject bfProject = PhingPathConverter.getEffectiveBFProject(attribValue);
            if (bfProject == null) {
                return null;
            }
            file = new File(PhingPathConverter.getPathResolveRoot(bfProject), path);
        }
        if ((vFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)file.getAbsolutePath()))) == null) {
            return null;
        }
        PsiManager psiManager = context.getPsiManager();
        return vFile.isDirectory() ? psiManager.findDirectory(vFile) : psiManager.findFile(vFile);
    }

    @Nullable
    private static PhingPredefinedProject getEffectiveBFProject(GenericAttributeValue attribValue) {
        return (PhingPredefinedProject)attribValue.getParentOfType(PhingPredefinedProject.class, false);
    }

    @Nullable
    private static String getPathResolveRoot(PhingPredefinedProject PhingDomProject) {
        return PhingDomProject.getProjectBasedirPath();
    }

    public String toString(@Nullable PsiFileSystemItem file, @NotNull ConvertContext context) {
        GenericAttributeValue attribValue;
        if (context == null) {
            PhingPathConverter.$$$reportNull$$$0(1);
        }
        if ((attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false)) == null) {
            return null;
        }
        return attribValue.getRawText();
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<PsiFileSystemItem> genericDomValue, PsiElement element, ConvertContext context) {
        GenericAttributeValue attrib;
        if (genericDomValue instanceof GenericAttributeValue && (attrib = (GenericAttributeValue)genericDomValue).getRawText() != null) {
            PhingDomFileReferenceSet refSet = new PhingDomFileReferenceSet(attrib);
            ArrayList<FileReference> result = new ArrayList<FileReference>();
            for (FileReference reference : refSet.getAllReferences()) {
                if (reference.resolve() == null) break;
                result.add(reference);
            }
            PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                PhingPathConverter.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PhingPathConverter.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            PhingPathConverter.$$$reportNull$$$0(4);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/PhingPathConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/PhingPathConverter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

