/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.Stack;
import com.intellij.util.xml.DomElement;
import com.jetbrains.php.phing.dom.PhingDomRecursiveVisitor;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.PropertiesProvider;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedImportTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhingPropertyProviderFinder
extends PhingDomRecursiveVisitor {
    private Stage myStage = Stage.RESOLVE_MAP_BUILDING_STAGE;
    private final Stack<String> myCurrentTargetEffectiveName = new Stack();
    private final PhingPredefinedElement myContextElement;
    private boolean myStopped;
    private final TargetsNameContext myNameContext = new TargetsNameContext();
    private final Map<String, PhingPredefinedTarget> myTargetsResolveMap = new HashMap<String, PhingPredefinedTarget>();
    private final Map<String, List<String>> myDependenciesMap = new HashMap<String, List<String>>();
    private final Set<String> myProcessedTargets = new HashSet<String>();
    private final Set<PhingPredefinedProject> myVisitedProjects = new HashSet<PhingPredefinedProject>();

    protected PhingPropertyProviderFinder(DomElement contextElement) {
        this.myContextElement = contextElement != null ? (PhingPredefinedElement)contextElement.getParentOfType(PhingPredefinedElement.class, false) : null;
    }

    public void execute(PhingPredefinedProject startProject, String initialTargetName) {
        this.myStage = Stage.RESOLVE_MAP_BUILDING_STAGE;
        startProject.accept(this);
        this.stageCompleted(Stage.RESOLVE_MAP_BUILDING_STAGE, Stage.TARGETS_WALKUP_STAGE);
        if (!this.myStopped) {
            PhingPredefinedTarget target;
            this.myStage = Stage.TARGETS_WALKUP_STAGE;
            PhingPredefinedTarget phingPredefinedTarget = target = initialTargetName != null ? this.getTargetByName(initialTargetName) : null;
            if (target != null) {
                this.processTarget(initialTargetName, target);
            }
            ArrayList<String> unprocessed = null;
            for (String s : this.myTargetsResolveMap.keySet()) {
                if (this.myProcessedTargets.contains(s)) continue;
                if (unprocessed == null) {
                    unprocessed = new ArrayList<String>();
                }
                unprocessed.add(s);
            }
            if (unprocessed != null) {
                for (String targetName : unprocessed) {
                    this.processTarget(targetName, this.myTargetsResolveMap.get(targetName));
                }
            }
        }
    }

    private void processTarget(String targetEffectiveName, PhingPredefinedTarget target) {
        this.myCurrentTargetEffectiveName.push((Object)targetEffectiveName);
        try {
            target.accept(this);
        }
        finally {
            this.myCurrentTargetEffectiveName.pop();
        }
    }

    @Override
    public void visitTarget(PhingPredefinedTarget target) {
        if (this.myStage == Stage.TARGETS_WALKUP_STAGE) {
            String targetEffectiveName = (String)this.myCurrentTargetEffectiveName.peek();
            if (!this.myProcessedTargets.contains(targetEffectiveName)) {
                this.myProcessedTargets.add(targetEffectiveName);
                List<String> depsList = this.myDependenciesMap.get(targetEffectiveName);
                if (depsList != null) {
                    for (String dependencyName : depsList) {
                        PhingPredefinedTarget dependency = this.getTargetByName(dependencyName);
                        if (dependency == null) continue;
                        this.processTarget(dependencyName, dependency);
                    }
                }
                super.visitTarget(target);
            }
        } else if (this.myStage == Stage.RESOLVE_MAP_BUILDING_STAGE) {
            Object effectiveTargetName;
            String declaredTargetName = target.findName().getRawText();
            InclusionKind inclusionKind = this.myNameContext.getCurrentInclusionKind();
            if (inclusionKind == InclusionKind.IMPORT) {
                String alias = this.myNameContext.getShortPrefix() + declaredTargetName;
                if (!this.myTargetsResolveMap.containsKey(declaredTargetName)) {
                    effectiveTargetName = declaredTargetName;
                    this.myTargetsResolveMap.put(alias, target);
                } else {
                    effectiveTargetName = alias;
                }
            } else {
                effectiveTargetName = declaredTargetName;
            }
            if (effectiveTargetName != null) {
                PhingPredefinedTarget existingTarget = this.myTargetsResolveMap.get(effectiveTargetName);
                if (existingTarget != null && Comparing.equal((Object)existingTarget.findPhingProject(), (Object)target.findPhingProject())) {
                    this.duplicateTargetFound(existingTarget, target, (String)effectiveTargetName);
                } else {
                    this.myTargetsResolveMap.put((String)effectiveTargetName, target);
                    String dependsStr = target.findDependsList().getRawText();
                    Map<String, Pair<PhingPredefinedTarget, String>> depsMap = Collections.emptyMap();
                    if (dependsStr != null) {
                        depsMap = new HashMap();
                        StringTokenizer tokenizer = new StringTokenizer(dependsStr, ",", false);
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken().trim();
                            String dependentTargetEffectiveName = token;
                            PhingPredefinedTarget dependent = this.getTargetByName(dependentTargetEffectiveName);
                            if (dependent != null) {
                                depsMap.put(token, (Pair<PhingPredefinedTarget, String>)Pair.create((Object)dependent, (Object)dependentTargetEffectiveName));
                            }
                            this.addDependency((String)effectiveTargetName, dependentTargetEffectiveName);
                        }
                    }
                    this.targetDefined(target, (String)effectiveTargetName, depsMap);
                }
            }
        }
    }

    @Override
    public void visitPhingDomElement(PhingPredefinedElement element) {
        if (this.myStopped) {
            return;
        }
        if (!element.equals(this.myContextElement) && element instanceof PropertiesProvider) {
            this.propertyProviderFound((PropertiesProvider)((Object)element));
        }
        if (!this.myStopped) {
            Iterator<PhingPredefinedElement> iterator = element.getBFChildrenIterator();
            while (iterator.hasNext()) {
                PhingPredefinedElement child = iterator.next();
                child.accept(this);
                if (this.myStage != Stage.TARGETS_WALKUP_STAGE || !this.myStopped) continue;
                break;
            }
        }
    }

    @Nullable
    protected PhingPredefinedTarget getTargetByName(String effectiveName) {
        return this.myTargetsResolveMap.get(effectiveName);
    }

    @NotNull
    public final Map<String, PhingPredefinedTarget> getDiscoveredTargets() {
        Map<String, PhingPredefinedTarget> map = Collections.unmodifiableMap(this.myTargetsResolveMap);
        if (map == null) {
            PhingPropertyProviderFinder.$$$reportNull$$$0(0);
        }
        return map;
    }

    public PhingPredefinedElement getContextElement() {
        return this.myContextElement;
    }

    protected void stop() {
        this.myStopped = true;
    }

    protected PropertiesProvider checkPropertyProvider(PropertiesProvider propertiesProvider) {
        PhingPredefinedProject parentProject;
        if (propertiesProvider instanceof PhingPredefinedProject && !propertiesProvider.equals(parentProject = (PhingPredefinedProject)this.myContextElement.getParentOfType(PhingPredefinedProject.class, false))) {
            propertiesProvider = ((PhingPredefinedProject)propertiesProvider).getInnerProvider();
        }
        return propertiesProvider;
    }

    protected abstract void propertyProviderFound(PropertiesProvider var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitImport(PhingPredefinedImportTask importTag) {
        if (importTag.equals(this.myContextElement)) {
            this.stop();
        }
        if (this.myStopped) {
            return;
        }
        PsiFileSystemItem item = (PsiFileSystemItem)importTag.findFile().getValue();
        if (item instanceof PsiFile) {
            PhingPredefinedProject slaveProject;
            PhingPredefinedProject phingPredefinedProject = slaveProject = item instanceof XmlFile ? PhingUtils.getPhingDomProjectForcePhingFile((PsiFile)((XmlFile)item)) : null;
            if (slaveProject != null) {
                this.myNameContext.pushPrefix(slaveProject);
                try {
                    slaveProject.accept(this);
                }
                finally {
                    this.myNameContext.popPrefix();
                }
            }
        }
    }

    @Override
    public void visitProject(PhingPredefinedProject project) {
        if (!this.myVisitedProjects.contains(project)) {
            this.myVisitedProjects.add(project);
            try {
                super.visitProject(project);
            }
            finally {
                this.myVisitedProjects.remove(project);
            }
        }
    }

    private void addDependency(String effectiveTargetName, String dependentTargetEffectiveName) {
        List<String> list = this.myDependenciesMap.get(effectiveTargetName);
        if (list == null) {
            list = new ArrayList<String>();
            this.myDependenciesMap.put(effectiveTargetName, list);
        }
        list.add(dependentTargetEffectiveName);
    }

    protected void targetDefined(PhingPredefinedTarget target, String taregetEffectiveName, Map<String, Pair<PhingPredefinedTarget, String>> dependenciesMap) {
    }

    protected void duplicateTargetFound(PhingPredefinedTarget existingTarget, PhingPredefinedTarget duplicatingTarget, String targetEffectiveName) {
    }

    protected void stageCompleted(Stage completedStage, Stage startingStage) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/PhingPropertyProviderFinder", "getDiscoveredTargets"));
    }

    public static enum Stage {
        RESOLVE_MAP_BUILDING_STAGE,
        TARGETS_WALKUP_STAGE;

    }

    protected static class TargetsNameContext {
        private int myDefaultPrefixCounter = 0;
        private final LinkedList<String> myPrefixes = new LinkedList();

        protected TargetsNameContext() {
        }

        @NotNull
        public InclusionKind getCurrentInclusionKind() {
            if (this.myPrefixes.isEmpty()) {
                InclusionKind inclusionKind = InclusionKind.TOPLEVEL;
                if (inclusionKind == null) {
                    TargetsNameContext.$$$reportNull$$$0(0);
                }
                return inclusionKind;
            }
            InclusionKind inclusionKind = InclusionKind.IMPORT;
            if (inclusionKind == null) {
                TargetsNameContext.$$$reportNull$$$0(1);
            }
            return inclusionKind;
        }

        @NotNull
        public String getShortPrefix() {
            String string = this.myPrefixes.isEmpty() ? "" : this.myPrefixes.getLast();
            if (string == null) {
                TargetsNameContext.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void pushPrefix(@NotNull PhingPredefinedProject slaveProject) {
            if (slaveProject == null) {
                TargetsNameContext.$$$reportNull$$$0(3);
            }
            String separator = ".";
            @NonNls Object prefix = slaveProject.findName().getRawText();
            if (prefix == null) {
                prefix = "anonymous" + this.myDefaultPrefixCounter++;
            }
            this.pushPrefix((String)(((String)prefix).endsWith(".") ? prefix : (String)prefix + "."));
        }

        public void pushPrefix(String prefix) {
            this.myPrefixes.addLast(prefix);
        }

        public void popPrefix() {
            this.myPrefixes.removeLast();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/dom/PhingPropertyProviderFinder$TargetsNameContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slaveProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentInclusionKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortPrefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/dom/PhingPropertyProviderFinder$TargetsNameContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "pushPrefix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3 -> new IllegalArgumentException(string);
            };
        }
    }

    protected static enum InclusionKind {
        IMPORT("imported"),
        TOPLEVEL("toplevel");

        private final String myDisplayName;

        private InclusionKind(String displayName) {
            this.myDisplayName = displayName;
        }

        public String toString() {
            return this.myDisplayName;
        }
    }
}

