/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.buildfiles.ForcedBuildFileAttribute;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.jetbrains.php.phing.dom.PhingDomFileDescription;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.schema.PhingAttributeInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhingUtils {
    @NonNls
    public static final String DOWNLOAD_URL = "https://www.phing.info/get/phing-latest.phar";
    @NonNls
    private static final String PHING_ID = "Phing";
    @NonNls
    public static final String NOTIFICATION_GROUP_ID = "Phing";

    private PhingUtils() {
    }

    @Nullable
    public static XmlFile getPhingXmlFile(VirtualFile virtualFile, Project project) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = virtualFile.isValid() ? PsiManager.getInstance((Project)project).findFile(virtualFile) : null;
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        return PhingDomFileDescription.isPhingFile(xmlFile) ? xmlFile : null;
    }

    @Nullable
    public static PhingPredefinedProject getPhingDomProject(PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            DomManager domManager = DomManager.getDomManager((Project)psiFile.getProject());
            DomFileElement fileElement = domManager.getFileElement((XmlFile)psiFile, PhingPredefinedProject.class);
            return fileElement != null ? (PhingPredefinedProject)fileElement.getRootElement() : null;
        }
        return null;
    }

    public static void markFileAsPhingFile(VirtualFile file, Project project, boolean value) {
        if (file.isValid() && ForcedBuildFileAttribute.belongsToFramework((VirtualFile)file, (String)"Phing") != value) {
            ForcedBuildFileAttribute.forceFileToFramework((VirtualFile)file, (String)"Phing", (boolean)value);
            PsiManager.getInstance((Project)project).dropPsiCaches();
        }
    }

    public static boolean isPhingMarkedFile(VirtualFile file) {
        return ForcedBuildFileAttribute.belongsToFramework((VirtualFile)file, (String)"Phing");
    }

    public static boolean belongsToOtherFramework(VirtualFile file) {
        String frameworkId = ForcedBuildFileAttribute.getFrameworkIdOfBuildFile((VirtualFile)file);
        return !StringUtil.isEmpty((String)frameworkId) && !"Phing".equals(frameworkId);
    }

    @Nullable
    public static PhingPredefinedProject getPhingDomProjectForcePhingFile(PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            DomManager domManager = DomManager.getDomManager((Project)psiFile.getProject());
            DomFileElement fileElement = domManager.getFileElement((XmlFile)psiFile, PhingPredefinedProject.class);
            if (fileElement == null) {
                ForcedBuildFileAttribute.forceFileToFramework((VirtualFile)psiFile.getVirtualFile(), (String)"Phing", (boolean)true);
                fileElement = domManager.getFileElement((XmlFile)psiFile, PhingPredefinedProject.class);
            }
            return fileElement != null ? (PhingPredefinedProject)fileElement.getRootElement() : null;
        }
        return null;
    }

    @Nullable
    public static PhingPredefinedElement getInvocationBFDomElement(ConvertContext context) {
        return (PhingPredefinedElement)context.getInvocationElement().getParentOfType(PhingPredefinedElement.class, false);
    }

    @Nullable
    public static DomTarget getDomTarget(@NotNull DomElement element) {
        GenericDomValue nameElement;
        if (element == null) {
            PhingUtils.$$$reportNull$$$0(0);
        }
        if ((nameElement = PhingUtils.getNameDomElement(element)) == null) {
            return null;
        }
        return PhingUtils.getDomTarget(element, nameElement);
    }

    @Nullable
    private static GenericDomValue getNameDomElement(DomElement element) {
        DomGenericInfo info = element.getGenericInfo();
        GenericDomValue nameElement = info.getNameDomElement(element);
        if (nameElement != null) {
            return nameElement;
        }
        DomAttributeChildDescription nameAttributeDescription = null;
        for (DomAttributeChildDescription attributeChildDescription : info.getAttributeChildrenDescriptions()) {
            if (!PhingAttributeInfo.isNameValue(attributeChildDescription)) continue;
            if (nameAttributeDescription == null) {
                nameAttributeDescription = attributeChildDescription;
                continue;
            }
            throw new IllegalStateException("Multiple NameValue attributes in element " + element.getXmlTag().getText());
        }
        if (nameAttributeDescription == null) {
            return null;
        }
        return nameAttributeDescription.getDomAttributeValue(element);
    }

    @Nullable
    public static DomTarget getDomTarget(DomElement element, @Nullable GenericDomValue nameElement) {
        if (nameElement == null) {
            return null;
        }
        return DomTarget.getTarget((DomElement)element, (GenericDomValue)nameElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/phing/dom/PhingUtils", "getDomTarget"));
    }
}

