/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.phing.dom.PropertiesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PropertyExpander {
    private static final Pattern $$_PATTERN = Pattern.compile("\\$\\$");
    private final List<PropertiesProvider> myProviders;
    private final Resolver myResolver;

    public PropertyExpander(@NotNull String str) {
        if (str == null) {
            PropertyExpander.$$$reportNull$$$0(0);
        }
        this.myProviders = new ArrayList<PropertiesProvider>();
        this.myResolver = new Resolver(str);
    }

    public boolean hasPropertiesToExpand() {
        return this.myResolver.hasNext();
    }

    public void acceptProvider(PropertiesProvider provider) {
        while (this.myResolver.hasNext()) {
            String propName = this.myResolver.next();
            String value = provider.getPropertyValue(propName);
            if (value == null) continue;
            PropertyExpander propertyValueExpander = new PropertyExpander(value);
            if (propertyValueExpander.hasPropertiesToExpand()) {
                for (PropertiesProvider p : this.myProviders) {
                    propertyValueExpander.acceptProvider(p);
                    if (propertyValueExpander.hasPropertiesToExpand()) continue;
                    break;
                }
            }
            this.myResolver.replace(propertyValueExpander.getResult());
        }
        this.myProviders.add(provider);
        this.myResolver.restart();
    }

    @NotNull
    public String getResult() {
        String string = this.myResolver.getResult();
        if (string == null) {
            PropertyExpander.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/PropertyExpander";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/PropertyExpander";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class Resolver
    implements Iterator<String> {
        private int myCurrentIndex = -1;
        private List<Pair<String, Integer>> myPropertyNames;
        private final StringBuilder myBuilder;

        private Resolver(String str) {
            this.myBuilder = new StringBuilder(str);
            int startProp = 0;
            while ((startProp = str.indexOf("${", startProp)) >= 0) {
                if (startProp > 0 && str.charAt(startProp - 1) == '$') {
                    startProp += 2;
                    continue;
                }
                int endProp = str.indexOf(125, startProp + 2);
                if (endProp <= startProp + 2) {
                    startProp += 2;
                    continue;
                }
                String prop = str.substring(startProp + 2, endProp);
                if (this.myPropertyNames == null) {
                    this.myPropertyNames = new ArrayList<Pair<String, Integer>>();
                }
                this.myPropertyNames.add((Pair<String, Integer>)new Pair((Object)prop, (Object)startProp));
                startProp += 2;
            }
            if (this.myPropertyNames == null) {
                this.myPropertyNames = Collections.emptyList();
            }
        }

        void restart() {
            this.myCurrentIndex = -1;
        }

        void replace(String newValue) {
            String name = this.getPropertyName(this.myCurrentIndex);
            int shift = newValue.length() - name.length() - 3;
            for (int idx = this.myCurrentIndex + 1; idx < this.myPropertyNames.size(); ++idx) {
                int currentOffset = this.getPropertyOffset(idx);
                this.setPropertyOffset(idx, currentOffset + shift);
            }
            int offset = this.getPropertyOffset(this.myCurrentIndex);
            this.myBuilder.replace(offset, offset + name.length() + 3, newValue);
            this.myPropertyNames.remove(this.myCurrentIndex);
            --this.myCurrentIndex;
        }

        private String getPropertyName(int index) {
            return (String)this.myPropertyNames.get(index).getFirst();
        }

        private int getPropertyOffset(int index) {
            return (Integer)this.myPropertyNames.get(index).getSecond();
        }

        private void setPropertyOffset(int index, int value) {
            Pair<String, Integer> pair = this.myPropertyNames.get(index);
            this.myPropertyNames.set(index, (Pair<String, Integer>)new Pair((Object)((String)pair.getFirst()), (Object)value));
        }

        String getResult() {
            String value = this.myBuilder.toString();
            if (value.contains("$$")) {
                try {
                    return $$_PATTERN.matcher(StringUtil.newBombedCharSequence((CharSequence)value, (long)100L)).replaceAll("\\$");
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
            return value;
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentIndex + 1 < this.myPropertyNames.size();
        }

        @Override
        public String next() {
            return this.getPropertyName(++this.myCurrentIndex);
        }

        @Override
        public void remove() {
            this.replace("");
        }
    }
}

