/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.util.Pair;
import com.jetbrains.php.phing.dom.PhingPropertyProviderFinder;
import com.jetbrains.php.phing.dom.PropertiesProvider;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TargetResolver
extends PhingPropertyProviderFinder {
    private final List<String> myDeclaredTargetRefs;
    @Nullable
    private final PhingPredefinedTarget myContextTarget;
    private final Result myResult;

    private TargetResolver(@NotNull Collection<String> declaredDependencyRefs, @Nullable PhingPredefinedTarget contextElement) {
        if (declaredDependencyRefs == null) {
            TargetResolver.$$$reportNull$$$0(0);
        }
        super(contextElement);
        this.myResult = new Result();
        this.myDeclaredTargetRefs = new ArrayList<String>(declaredDependencyRefs);
        this.myContextTarget = contextElement;
    }

    @NotNull
    public static Result resolve(@NotNull PhingPredefinedProject project, @Nullable PhingPredefinedTarget contextTarget, @NotNull String declaredTargetRef) {
        if (project == null) {
            TargetResolver.$$$reportNull$$$0(1);
        }
        if (declaredTargetRef == null) {
            TargetResolver.$$$reportNull$$$0(2);
        }
        Result result = TargetResolver.resolve(project, contextTarget, Collections.singletonList(declaredTargetRef));
        if (result == null) {
            TargetResolver.$$$reportNull$$$0(3);
        }
        return result;
    }

    public static Result resolve(PhingPredefinedProject project, PhingPredefinedTarget contextTarget, @NotNull Collection<String> declaredTargetRefs) {
        if (declaredTargetRefs == null) {
            TargetResolver.$$$reportNull$$$0(4);
        }
        TargetResolver resolver = new TargetResolver(declaredTargetRefs, contextTarget);
        resolver.execute(project, null);
        Result result = resolver.getResult();
        result.setVariants(resolver.getDiscoveredTargets());
        return result;
    }

    @Override
    protected void targetDefined(PhingPredefinedTarget target, String targetEffectiveName, Map<String, Pair<PhingPredefinedTarget, String>> dependenciesMap) {
        if (this.myContextTarget != null && this.myDeclaredTargetRefs.size() > 0 && target.equals(this.myContextTarget)) {
            Iterator<String> it = this.myDeclaredTargetRefs.iterator();
            while (it.hasNext()) {
                String declaredRef = it.next();
                Pair<PhingPredefinedTarget, String> result = dependenciesMap.get(declaredRef);
                if (result == null) continue;
                this.myResult.add(declaredRef, result);
                it.remove();
            }
            this.stop();
        }
    }

    @Override
    protected void stageCompleted(PhingPropertyProviderFinder.Stage completedStage, PhingPropertyProviderFinder.Stage startingStage) {
        if (completedStage == PhingPropertyProviderFinder.Stage.RESOLVE_MAP_BUILDING_STAGE) {
            if (this.myDeclaredTargetRefs.size() > 0) {
                Iterator<String> it = this.myDeclaredTargetRefs.iterator();
                while (it.hasNext()) {
                    String declaredRef = it.next();
                    PhingPredefinedTarget result = this.getTargetByName(declaredRef);
                    if (result == null) continue;
                    this.myResult.add(declaredRef, (Pair<PhingPredefinedTarget, String>)Pair.create((Object)result, (Object)declaredRef));
                    it.remove();
                }
            }
            this.stop();
        }
    }

    @NotNull
    public Result getResult() {
        Result result = this.myResult;
        if (result == null) {
            TargetResolver.$$$reportNull$$$0(5);
        }
        return result;
    }

    @Override
    protected void propertyProviderFound(PropertiesProvider propertiesProvider) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredDependencyRefs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredTargetRef";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/TargetResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredTargetRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/TargetResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    public static class Result {
        private String myRefsString;
        private final Map<String, Pair<PhingPredefinedTarget, String>> myMap = new HashMap<String, Pair<PhingPredefinedTarget, String>>();
        private Map<String, PhingPredefinedTarget> myVariants;

        void add(String declaredTargetRef, Pair<PhingPredefinedTarget, String> pair) {
            this.myMap.put(declaredTargetRef, pair);
        }

        void setVariants(Map<String, PhingPredefinedTarget> variants) {
            this.myVariants = variants;
        }

        public String getRefsString() {
            return this.myRefsString;
        }

        public void setRefsString(String refsString) {
            this.myRefsString = refsString;
        }

        @Nullable
        public Pair<PhingPredefinedTarget, String> getResolvedTarget(String declaredTargetRef) {
            return this.myMap.get(declaredTargetRef);
        }

        @NotNull
        public Map<String, PhingPredefinedTarget> getVariants() {
            Map<String, PhingPredefinedTarget> map = this.myVariants != null ? this.myVariants : Collections.emptyMap();
            if (map == null) {
                Result.$$$reportNull$$$0(0);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/TargetResolver$Result", "getVariants"));
        }
    }
}

