/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.predefined;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.schema.PhingSchemaService;
import com.jetbrains.php.phing.dom.schema.PhingTagInfo;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public abstract class PhingPredefinedElement
implements DomElement {
    private static final Key<PhingTagInfo> KEY = Key.create((String)"phingTagSchemaInfo");

    @Nullable
    public GenericDomValue<String> findId() {
        return this.findAttributeValue("id");
    }

    public final Iterator<PhingPredefinedElement> getBFChildrenIterator() {
        List children = DomUtil.getDefinedChildren((DomElement)this, (boolean)true, (boolean)false);
        if (children.isEmpty()) {
            return Collections.emptyIterator();
        }
        final Iterator it = children.iterator();
        return new Iterator<PhingPredefinedElement>(){
            private DomElement myUnprocessedElement;

            @Override
            public boolean hasNext() {
                this.findNextPhingElement();
                return this.myUnprocessedElement != null;
            }

            @Override
            public PhingPredefinedElement next() {
                this.findNextPhingElement();
                if (this.myUnprocessedElement == null) {
                    throw new NoSuchElementException();
                }
                PhingPredefinedElement phingElement = (PhingPredefinedElement)this.myUnprocessedElement;
                this.myUnprocessedElement = null;
                return phingElement;
            }

            private void findNextPhingElement() {
                if (this.myUnprocessedElement != null) {
                    return;
                }
                while (it.hasNext()) {
                    this.myUnprocessedElement = (DomElement)it.next();
                    if (!(this.myUnprocessedElement instanceof PhingPredefinedElement)) continue;
                }
            }
        };
    }

    @Nullable
    public final PhingPredefinedProject findPhingProject() {
        return (PhingPredefinedProject)this.getParentOfType(PhingPredefinedProject.class, false);
    }

    @Nullable
    protected GenericAttributeValue findAttributeValue(String attributeName) {
        DomAttributeChildDescription description = this.getGenericInfo().getAttributeChildDescription(attributeName);
        if (description == null) {
            return null;
        }
        return description.getDomAttributeValue((DomElement)this);
    }

    @Nullable
    protected List<? extends PhingPredefinedElement> findChildren(String tagName) {
        DomCollectionChildDescription description = this.getGenericInfo().getCollectionChildDescription(tagName);
        if (description == null) {
            return null;
        }
        return description.getValues((DomElement)this);
    }

    @Nullable
    protected PhingPredefinedElement findChild(String tagName) {
        DomFixedChildDescription description = this.getGenericInfo().getFixedChildDescription(tagName);
        if (description == null) {
            return null;
        }
        List values = description.getValues((DomElement)this);
        return values.isEmpty() ? null : (PhingPredefinedElement)values.get(0);
    }

    @Nullable
    public PhingTagInfo getPhingInfo() {
        PhingTagInfo attached = (PhingTagInfo)this.getChildDescription().getUserData(KEY);
        if (attached == null && this instanceof PhingPredefinedProject) {
            Project project = this.getXmlTag().getProject();
            PhingSchemaService service = PhingSchemaService.getInstance(project);
            return service.getSchema().getProjectTagInfo();
        }
        return attached;
    }

    public static void registerTagInfo(DomExtension extension, PhingTagInfo tagInfo) {
        extension.putUserData(KEY, (Object)tagInfo);
    }
}

