/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.predefined;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DefinesXml;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileProperty;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.PropertiesProvider;
import com.jetbrains.php.phing.dom.TargetResolver;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedImportTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTarget;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DefinesXml
public abstract class PhingPredefinedProject
extends PhingPredefinedElement
implements PropertiesProvider {
    private static final Logger LOG = Logger.getInstance(PhingPredefinedProject.class);
    @NonNls
    private static final String ENVIRONMENT_PROPERTIES_PREFIX = "env.";
    private volatile Map<String, String> myProperties;
    private PropertiesProvider myInnerPropertiesProvider;

    public GenericAttributeValue<@NlsSafe String> findName() {
        return this.findAttributeValue("name");
    }

    public GenericAttributeValue<@NlsSafe String> findBasedir() {
        return this.findAttributeValue("basedir");
    }

    public GenericAttributeValue<TargetResolver.Result> findDefaultTarget() {
        return this.findAttributeValue("default");
    }

    public List<PhingPredefinedTarget> findTargets() {
        return this.findChildren("target");
    }

    public List<PhingPredefinedImportTask> findImportTasks() {
        return this.findChildren("import");
    }

    @Nullable
    public String getProjectBasedirPath() {
        File file;
        String basedir = this.findBasedir().getStringValue();
        if (basedir != null && (file = new File(basedir)).isAbsolute()) {
            try {
                return FileUtil.toSystemIndependentName((String)file.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        String selfDir = this.getContainingFileDir();
        if (basedir == null) {
            return selfDir;
        }
        try {
            return FileUtil.toSystemIndependentName((String)new File(selfDir, basedir).getCanonicalPath());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    public final String getContainingFileDir() {
        VirtualFile containingFile = this.getXmlTag().getContainingFile().getOriginalFile().getVirtualFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile parent = containingFile.getParent();
        return parent != null ? parent.getPath() : null;
    }

    @Override
    @NotNull
    public Iterator<String> getNamesIterator() {
        Iterator<String> iterator = this.getProjectProperties().keySet().iterator();
        if (iterator == null) {
            PhingPredefinedProject.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    @Nullable
    public String getPropertyValue(String propertyName) {
        if (propertyName.startsWith(ENVIRONMENT_PROPERTIES_PREFIX)) {
            return "";
        }
        return this.getProjectProperties().get(propertyName);
    }

    @Override
    @Nullable
    public PsiElement getNavigationElement(String propertyName) {
        PsiElement nameElementPsi;
        DomTarget target = PhingUtils.getDomTarget(this);
        PsiElement psiElement = nameElementPsi = target != null ? PomService.convertToPsi((PsiTarget)target) : null;
        if (nameElementPsi != null) {
            return nameElementPsi;
        }
        XmlElement xmlElement = this.getXmlElement();
        return xmlElement != null ? xmlElement.getNavigationElement() : null;
    }

    public PropertiesProvider getInnerProvider() {
        if (this.myInnerPropertiesProvider == null) {
            this.myInnerPropertiesProvider = new PropertiesProvider(){

                @Override
                @NotNull
                public Iterator<String> getNamesIterator() {
                    Iterator<String> iterator = PhingPredefinedProject.this.getInnerProjectProperties().keySet().iterator();
                    if (iterator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }

                @Override
                @Nullable
                public String getPropertyValue(String propertyName) {
                    return PhingPredefinedProject.this.getInnerProjectProperties().get(propertyName);
                }

                @Override
                @Nullable
                public PsiElement getNavigationElement(String propertyName) {
                    return PhingPredefinedProject.this.getNavigationElement(propertyName);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/predefined/PhingPredefinedProject$1", "getNamesIterator"));
                }
            };
        }
        return this.myInnerPropertiesProvider;
    }

    private Map<String, String> getProjectProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(this.getInnerProjectProperties());
        PsiFile containingFile = this.getXmlTag().getContainingFile();
        if (containingFile != null) {
            PhingBuildFile buildFile;
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                virtualFile = containingFile.getOriginalFile().getVirtualFile();
            }
            if (virtualFile != null && (buildFile = PhingStateService.getInstance(containingFile.getProject()).getBuildFile(virtualFile)) != null) {
                for (PhingBuildFileProperty property : buildFile.getCommandLineProperties()) {
                    properties.put(property.getName(), property.getValue());
                }
            }
        }
        return properties;
    }

    private Map<String, String> getInnerProjectProperties() {
        if (this.myProperties == null) {
            this.myProperties = this.loadPredefinedProperties();
        }
        return this.myProperties;
    }

    private Map<String, String> loadPredefinedProperties() {
        String containigFileDir;
        HashMap<String, String> destination = new HashMap<String, String>();
        String basedir = this.getProjectBasedirPath();
        if (basedir == null) {
            basedir = ".";
        }
        if (!FileUtil.isAbsolute((String)basedir) && (containigFileDir = this.getContainingFileDir()) != null) {
            try {
                basedir = new File(containigFileDir, basedir).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PhingPredefinedProject.appendProperty(destination, "application.startdir", FileUtil.toSystemIndependentName((String)basedir));
        if (!SystemInfo.isWindows) {
            PhingPredefinedProject.appendProperty(destination, "host.arch", SystemInfo.OS_ARCH);
            PhingPredefinedProject.appendProperty(destination, "host.domain", "");
            PhingPredefinedProject.appendProperty(destination, "host.name", SystemInfo.OS_VERSION);
            PhingPredefinedProject.appendProperty(destination, "host.os.release", "");
            PhingPredefinedProject.appendProperty(destination, "host.os.version", SystemInfo.OS_VERSION);
        }
        PhingPredefinedProject.appendProperty(destination, "host.fstype", "");
        PhingPredefinedProject.appendProperty(destination, "host.os", "");
        PhingPredefinedProject.appendProperty(destination, "line.separator", System.getProperty("line.separator"));
        PhingPredefinedProject.appendProperty(destination, "os.name", (String)destination.get("host.os"));
        VirtualFile containingFile = this.getXmlTag().getContainingFile().getOriginalFile().getVirtualFile();
        if (containingFile != null) {
            String antFilePath = containingFile.getPath();
            PhingPredefinedProject.appendProperty(destination, "phing.file", antFilePath);
            VirtualFile parent = containingFile.getParent();
            PhingPredefinedProject.appendProperty(destination, "phing.dir", parent == null ? "" : parent.getPath());
        }
        PhingPredefinedProject.appendProperty(destination, "phing.home", PhingStateService.getInstance(this.getXmlTag().getProject()).getPhingPath());
        PhingPredefinedProject.appendProperty(destination, "phing.version", "");
        String projectName = this.findName().getRawText();
        PhingPredefinedProject.appendProperty(destination, "phing.project.name", projectName == null ? "" : projectName);
        PhingPredefinedProject.appendProperty(destination, "php.classpath", "");
        PhingPredefinedProject.appendProperty(destination, "php.version", "");
        PhingPredefinedProject.appendProperty(destination, "project.basedir", FileUtil.toSystemIndependentName((String)basedir));
        PhingPredefinedProject.appendProperty(destination, "user.home", System.getProperty("user.home"));
        return destination;
    }

    private static void appendProperty(Map<String, String> map, @NonNls String name, String value) {
        String previous = map.put(name, value);
        if (previous != null) {
            map.put(name, previous);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/predefined/PhingPredefinedProject", "getNamesIterator"));
    }
}

