/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.predefined;

import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.PropertiesProvider;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.schema.PhingTagInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PhingPredefinedPropertyDefiningElement
extends PhingPredefinedElement
implements PropertiesProvider {
    @Override
    @NotNull
    public final Iterator<String> getNamesIterator() {
        List<GenericAttributeValue<String>> attribs = this.getPropertyDefiningAttributes();
        ArrayList<String> result = new ArrayList<String>(attribs.size());
        for (GenericAttributeValue<String> attribValue : attribs) {
            String name = attribValue.getStringValue();
            if (name == null || name.length() <= 0) continue;
            result.add(name);
        }
        result.addAll(this.getImplicitPropertyNames());
        Iterator<String> iterator = result.iterator();
        if (iterator == null) {
            PhingPredefinedPropertyDefiningElement.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    public final PsiElement getNavigationElement(String propertyName) {
        for (GenericAttributeValue<String> value : this.getPropertyDefiningAttributes()) {
            if (!propertyName.equals(value.getStringValue())) continue;
            DomTarget domTarget = PhingUtils.getDomTarget(this, value);
            return domTarget != null ? PomService.convertToPsi((PsiTarget)domTarget) : null;
        }
        for (String propName : this.getImplicitPropertyNames()) {
            if (!propertyName.equals(propName)) continue;
            DomTarget domTarget = PhingUtils.getDomTarget(this);
            if (domTarget != null) {
                return PomService.convertToPsi((PsiTarget)domTarget);
            }
            XmlElement xmlElement = this.getXmlElement();
            return xmlElement != null ? xmlElement.getNavigationElement() : null;
        }
        return null;
    }

    @Override
    public final String getPropertyValue(String propertyName) {
        for (GenericAttributeValue<String> value : this.getPropertyDefiningAttributes()) {
            if (!propertyName.equals(value.getStringValue())) continue;
            return this.calcPropertyValue(propertyName);
        }
        for (String name : this.getImplicitPropertyNames()) {
            if (!propertyName.equals(name)) continue;
            return this.calcPropertyValue(propertyName);
        }
        return null;
    }

    protected final List<GenericAttributeValue<String>> getPropertyDefiningAttributes() {
        PhingTagInfo info = this.getPhingInfo();
        if (info == null) {
            return Collections.emptyList();
        }
        Function attributeValueFunction = s -> this.findAttributeValue((String)s);
        return ContainerUtil.map(info.getPropertyNames(), (Function)attributeValueFunction);
    }

    protected List<String> getImplicitPropertyNames() {
        return Collections.emptyList();
    }

    protected String calcPropertyValue(String propertyName) {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/predefined/PhingPredefinedPropertyDefiningElement", "getNamesIterator"));
    }
}

