/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.schema;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.phing.dom.schema.PhingTagInfo;
import com.jetbrains.php.phing.dom.schema.TagDescription;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PhingSchema {
    private static final Logger LOG = Logger.getInstance(PhingSchema.class);
    private static final Comparator<String> IGNORE_CASE_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1, (String)o2, (boolean)true);
    @NonNls
    private static final String TAGS_TAG = "tags";
    @NonNls
    private static final String PROJECT_SCHEMA_TAG = "project";
    private final Map<String, PhingTagInfo> myIdToTags;
    private final Map<String, TagDescription> myTaskNameToId;
    private final Map<String, TagDescription> myTypesNameToId;
    private final Map<String, TagDescription> mySelectorsNameToId;
    private final Map<String, TagDescription> myConditionsNameToId;
    private final PhingTagInfo myProjectInfo;

    public PhingSchema(PhingTagInfo projectInfo, Map<String, PhingTagInfo> idToTags, Map<Containers, Map<String, TagDescription>> nameToIds) {
        this.myProjectInfo = projectInfo;
        this.myIdToTags = PhingSchema.copySortedUnmodifiable(idToTags);
        this.myTaskNameToId = PhingSchema.copySortedUnmodifiable(nameToIds.get((Object)Containers.TASKS));
        this.myTypesNameToId = PhingSchema.copySortedUnmodifiable(nameToIds.get((Object)Containers.TYPES));
        this.mySelectorsNameToId = PhingSchema.copySortedUnmodifiable(nameToIds.get((Object)Containers.SELECTORS));
        this.myConditionsNameToId = PhingSchema.copySortedUnmodifiable(nameToIds.get((Object)Containers.CONDITIONS));
    }

    public static <T> Map<String, T> copySortedUnmodifiable(Map<String, T> map) {
        TreeMap<String, T> tagToNameMap = new TreeMap<String, T>(IGNORE_CASE_COMPARATOR);
        tagToNameMap.putAll(map);
        return Collections.unmodifiableMap(tagToNameMap);
    }

    public PhingTagInfo getProjectTagInfo() {
        return this.myProjectInfo;
    }

    @Nullable
    public PhingTagInfo getTagInfo(String id) {
        return this.myIdToTags.get(id);
    }

    public Map<String, TagDescription> getTaskNameToDescription() {
        return this.myTaskNameToId;
    }

    public Map<String, TagDescription> getTypesNameToDescription() {
        return this.myTypesNameToId;
    }

    public Map<String, TagDescription> getSelectorsNameToDescription() {
        return this.mySelectorsNameToId;
    }

    public Map<String, TagDescription> getConditionsNameToDescription() {
        return this.myConditionsNameToId;
    }

    public static PhingSchema read(Element element) {
        Element others = element.getChild(TAGS_TAG);
        LOG.assertTrue(others != null, (Object)"Schema should contain `tags` tag");
        HashMap<String, PhingTagInfo> idToTag = new HashMap<String, PhingTagInfo>();
        for (Containers[] tagDescription : others.getChildren()) {
            String id = tagDescription.getName();
            PhingTagInfo info = PhingTagInfo.read((Element)tagDescription);
            idToTag.put(id, info);
        }
        HashMap<Containers, Map<String, TagDescription>> idToMaps = new HashMap<Containers, Map<String, TagDescription>>();
        for (Containers container : Containers.values()) {
            Element tasks = element.getChild(container.getTagName());
            HashMap<String, TagDescription> nameToId = new HashMap<String, TagDescription>();
            LOG.assertTrue(tasks != null, (Object)"Tag should have tasks");
            for (Attribute attribute : tasks.getAttributes()) {
                nameToId.put(attribute.getName(), TagDescription.getFromStringPresentation(attribute.getValue()));
            }
            idToMaps.put(container, nameToId);
        }
        Element projectElement = element.getChild(PROJECT_SCHEMA_TAG);
        LOG.assertTrue(projectElement != null, (Object)"Schema should contain `project` tag");
        PhingTagInfo projectInfo = PhingTagInfo.read(projectElement);
        return new PhingSchema(projectInfo, idToTag, idToMaps);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Containers {
        TASKS("tasks", "task"){

            @Override
            public Map<String, TagDescription> getNameToIdMap(PhingSchema schema) {
                return schema.getTaskNameToDescription();
            }
        }
        ,
        TYPES("types", "type"){

            @Override
            public Map<String, TagDescription> getNameToIdMap(PhingSchema schema) {
                return schema.getTypesNameToDescription();
            }
        }
        ,
        SELECTORS("selectors", "selector"){

            @Override
            public Map<String, TagDescription> getNameToIdMap(PhingSchema schema) {
                return schema.getSelectorsNameToDescription();
            }
        }
        ,
        CONDITIONS("conditions", "condition"){

            @Override
            public Map<String, TagDescription> getNameToIdMap(PhingSchema schema) {
                return schema.getConditionsNameToDescription();
            }
        };

        private final String myTagName;
        private final String myAttributeValue;

        private Containers(String name, String value) {
            this.myTagName = name;
            this.myAttributeValue = value;
        }

        public String getTagName() {
            return this.myTagName;
        }

        public String getAttributeValue() {
            return this.myAttributeValue;
        }

        public abstract Map<String, TagDescription> getNameToIdMap(PhingSchema var1);
    }
}

