/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.phpDependent;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DummyEvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.dom.PhingDomRecursiveVisitor;
import com.jetbrains.php.phing.dom.PhingPhpClassConverter;
import com.jetbrains.php.phing.dom.PhingPhpFileReferenceSet;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.PropertyFilesManager;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedAdhocTaskdefTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedAdhocTypedefTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedCustomElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedCustomUnknownElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedImportTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTagDefiningNamedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTaskdefTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTypedefTask;
import com.jetbrains.php.phing.phpDependent.PhingCustomElementsRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhingPhpDependentCustomElementsRegistry
extends PhingCustomElementsRegistry {
    private static final Logger LOG = Logger.getInstance(PhingPhpDependentCustomElementsRegistry.class);
    @NonNls
    private static final String PHP_FILE_BEGINNING = "<?php\n";
    private final Map<XmlName, PhingCustomClassDescription> myCustomElements = new HashMap<XmlName, PhingCustomClassDescription>();
    private final Map<PhingPredefinedTagDefiningNamedElement, @Nls String> myTypeDefErrors = new HashMap<PhingPredefinedTagDefiningNamedElement, String>();
    private final Map<XmlName, PhingPredefinedTagDefiningNamedElement> myDeclarations = new HashMap<XmlName, PhingPredefinedTagDefiningNamedElement>();

    protected PhingPhpDependentCustomElementsRegistry(PhingPredefinedProject phingProject) {
        phingProject.accept(new CustomTagDefinitionFinder());
    }

    @Override
    public Map<XmlName, PhingPredefinedTagDefiningNamedElement> getDeclarations() {
        return this.myDeclarations;
    }

    @Override
    @Nullable
    public String lookupTypeDefError(PhingPredefinedTagDefiningNamedElement definition) {
        return this.myTypeDefErrors.get(definition);
    }

    @Override
    public void registerCustomElements(PhingPredefinedElement element, @NotNull DomExtensionsRegistrar registrar) {
        XmlName xmlName;
        PhingCustomClassDescription description;
        if (registrar == null) {
            PhingPhpDependentCustomElementsRegistry.$$$reportNull$$$0(0);
        }
        if ((description = this.myCustomElements.get(xmlName = ((PhingPredefinedCustomElement)element).getXmlName())) == null) {
            return;
        }
        for (String attribute : description.getAttributes()) {
            registrar.registerGenericAttributeValueChildExtension(new XmlName(attribute, xmlName.getNamespaceKey()), String.class);
        }
        for (String subTag : description.getSubTags()) {
            registrar.registerFixedNumberChildExtension(new XmlName(subTag, xmlName.getNamespaceKey()), PhingPredefinedCustomElement.class);
        }
        for (String subTagList : description.getSubTagLists()) {
            registrar.registerCollectionChildrenExtension(new XmlName(subTagList, xmlName.getNamespaceKey()), PhingPredefinedCustomUnknownElement.class);
        }
    }

    @Override
    public Set<EvaluatedXmlName> getCompletionVariantsForCustomTag(@NotNull DomElement parent, boolean addTypes, boolean addTasks) {
        if (parent == null) {
            PhingPhpDependentCustomElementsRegistry.$$$reportNull$$$0(1);
        }
        HashSet<EvaluatedXmlName> result = new HashSet<EvaluatedXmlName>();
        for (Map.Entry<XmlName, PhingCustomClassDescription> entry : this.myCustomElements.entrySet()) {
            if ((!addTypes || !entry.getValue().isType()) && (!addTasks || !entry.getValue().isTask())) continue;
            result.add((EvaluatedXmlName)new DummyEvaluatedXmlName(entry.getKey(), parent.getXmlElementNamespace()));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phing/phpDependent/PhingPhpDependentCustomElementsRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCustomElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompletionVariantsForCustomTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CustomTagDefinitionFinder
    extends PhingDomRecursiveVisitor {
        @NonNls
        private static final String ATTRIBUTE_METHOD_BEGINNING = "set";
        @NonNls
        private static final String SUB_TAG_METHOD_BEGINNING = "add";
        @NonNls
        private static final String SUB_TAG_LIST_METHOD_BEGINNING = "create";
        @NonNls
        private static final String TASK_BASE_CLASS_NAME = "Task";
        @NonNls
        private static final String TYPE_BASE_CLASS_NAME = "DataType";
        private final Set<PhingPredefinedElement> myElementsOnThePath = new HashSet<PhingPredefinedElement>();

        private CustomTagDefinitionFinder() {
        }

        @Override
        public void visitPhingDomElement(PhingPredefinedElement element) {
            if (element instanceof PhingPredefinedCustomElement || this.myElementsOnThePath.contains(element)) {
                return;
            }
            this.myElementsOnThePath.add(element);
            try {
                super.visitPhingDomElement(element);
            }
            finally {
                this.myElementsOnThePath.remove(element);
            }
        }

        @Override
        public void visitAdHocTaskDef(PhingPredefinedAdhocTaskdefTask taskDefTask) {
            this.getAdHocData(taskDefTask);
        }

        @Override
        public void visitAdHocTypeDef(PhingPredefinedAdhocTypedefTask typeDefTask) {
            this.getAdHocData(typeDefTask);
        }

        private void getAdHocData(PhingPredefinedTagDefiningNamedElement adHocDef) {
            String name = (String)adHocDef.findName().getValue();
            if (StringUtil.isEmpty((String)name)) {
                return;
            }
            XmlTag xmlTag = adHocDef.getXmlTag();
            if (xmlTag == null) {
                return;
            }
            assert (name != null);
            XmlName xmlName = new XmlName(name, xmlTag.getNamespace());
            String typeDescription = this.getClassDescriptionTextAntOffset(adHocDef);
            if (typeDescription == null) {
                return;
            }
            PhpFile phpfile = CustomTagDefinitionFinder.loadContentAsFile(xmlTag.getProject(), typeDescription);
            PhpClass phpClass = (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)phpfile, PhpClass.class, (boolean)false);
            if (phpClass != null) {
                this.getDataOfPhpClass(xmlName, phpClass, adHocDef);
            } else {
                PhingPhpDependentCustomElementsRegistry.this.myTypeDefErrors.put(adHocDef, PhingBundle.message("framework.php.class.not.found.in.description", new Object[0]));
            }
        }

        @Override
        public void visitTypeDef(PhingPredefinedTypedefTask typeDef) {
            this.getDefData(typeDef);
        }

        @Override
        public void visitTaskDef(PhingPredefinedTaskdefTask taskDef) {
            this.getDefData(taskDef);
        }

        private void getDefData(PhingPredefinedTagDefiningNamedElement def) {
            String name;
            if (def instanceof PhingPredefinedTaskdefTask) {
                this.tryLoadTaskDefsFromFile((PhingPredefinedTaskdefTask)def);
            }
            if (StringUtil.isEmpty((String)(name = (String)def.findName().getValue()))) {
                return;
            }
            XmlTag xmlTag = def.getXmlTag();
            if (xmlTag == null) {
                return;
            }
            assert (name != null);
            XmlName xmlName = new XmlName(name, xmlTag.getNamespace());
            XmlAttribute attribute = def.getXmlTag().getAttribute("classname");
            if (attribute == null) {
                return;
            }
            String className = attribute.getValue();
            if (className == null) {
                return;
            }
            this.registerDefinitionNameAndClassName(def, xmlName, className, xmlTag.getProject(), xmlTag.getManager(), xmlTag.getContainingFile());
        }

        private void tryLoadTaskDefsFromFile(PhingPredefinedTaskdefTask def) {
            PsiFileSystemItem file = (PsiFileSystemItem)def.findFile().getValue();
            if (file == null || file.getContainingFile() == null) {
                return;
            }
            PropertyFilesManager[] extensions = (PropertyFilesManager[])PropertyFilesManager.EP.getExtensions();
            if (extensions.length == 0) {
                return;
            }
            HashMap<String, String> nameAndClassname = new HashMap<String, String>();
            extensions[0].collectProperties((PsiFileSystemItem)file.getContainingFile(), nameAndClassname);
            XmlTag xmlTag = def.getXmlTag();
            for (Map.Entry entry : nameAndClassname.entrySet()) {
                XmlName xmlName = new XmlName((String)entry.getKey(), xmlTag.getNamespace());
                this.registerDefinitionNameAndClassName(def, xmlName, (String)entry.getValue(), xmlTag.getProject(), xmlTag.getManager(), xmlTag.getContainingFile());
            }
        }

        private void registerDefinitionNameAndClassName(PhingPredefinedTagDefiningNamedElement def, XmlName xmlName, String className, Project project, PsiManager psiManager, PsiFile psiFile) {
            PsiFileSystemItem phpFile = PhingPhpClassConverter.findPhpClass(className = PhingPhpFileReferenceSet.convertAttributeValueToPath(className), project, psiManager, psiFile);
            if (phpFile == null) {
                PhingPhpDependentCustomElementsRegistry.this.myTypeDefErrors.put(def, PhingBundle.message("framework.php.file.0.not.found", className));
                return;
            }
            PhpClass phpClass = CustomTagDefinitionFinder.findClassInsideDefiningFile(project, phpFile.getVirtualFile());
            if (phpClass == null) {
                int pointIndex = className.lastIndexOf("\\.");
                PhingPhpDependentCustomElementsRegistry.this.myTypeDefErrors.put(def, PhingBundle.message("framework.php.file.0.does.not.contain.class.1", className, pointIndex == -1 ? className : className.substring(pointIndex + 1)));
                return;
            }
            this.getDataOfPhpClass(xmlName, phpClass, def);
        }

        @Nullable
        private static PhpClass findClassInsideDefiningFile(Project project, VirtualFile file) {
            Collection classes;
            String nameOfClass = file.getNameWithoutExtension();
            GlobalSearchScope scope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)file);
            if (DumbService.isDumb((Project)project)) {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile == null) {
                    return null;
                }
                classes = PsiTreeUtil.collectElementsOfType((PsiElement)psiFile, (Class[])new Class[]{PhpClass.class});
            } else {
                classes = PhpIndex.getInstance((Project)project).getClassesByNameInScope(nameOfClass, scope);
            }
            if (!classes.isEmpty()) {
                return (PhpClass)classes.iterator().next();
            }
            return null;
        }

        private void getDataOfPhpClass(@NotNull XmlName xmlName, @NotNull PhpClass phpClass, @Nullable PhingPredefinedTagDefiningNamedElement elementDef) {
            int type;
            if (xmlName == null) {
                CustomTagDefinitionFinder.$$$reportNull$$$0(0);
            }
            if (phpClass == null) {
                CustomTagDefinitionFinder.$$$reportNull$$$0(1);
            }
            if (elementDef == null) {
                type = 2;
            } else {
                int n = type = elementDef.isTaskDefining() ? 0 : 1;
            }
            if (PhingPhpDependentCustomElementsRegistry.this.myCustomElements.containsKey(xmlName)) {
                LOG.debug("Duplicated xml name ''" + xmlName + "'' of class " + phpClass.getNamespaceName() + phpClass.getName() + " ignored.");
                return;
            }
            PhpClassType classType = CustomTagDefinitionFinder.getClassType(phpClass);
            ArrayList<Pair> innerClassDeclarations = new ArrayList<Pair>();
            PhingCustomClassDescription description = new PhingCustomClassDescription(type);
            for (Method method : phpClass.getMethods()) {
                String propertyName;
                String methodName = method.getName();
                if (StringUtil.isEmpty((String)methodName)) continue;
                assert (methodName != null);
                if (methodName.startsWith(ATTRIBUTE_METHOD_BEGINNING)) {
                    if (method.getParameters().length != 1) continue;
                    propertyName = StringUtil.decapitalize((String)methodName.substring(ATTRIBUTE_METHOD_BEGINNING.length()));
                    if (classType.getProhibitedAttributeNames().contains(propertyName)) continue;
                    description.getAttributes().add(propertyName);
                    continue;
                }
                if (methodName.startsWith(SUB_TAG_METHOD_BEGINNING)) {
                    if (method.getParameters().length != 1 || "text".equals(propertyName = StringUtil.toLowerCase((String)methodName.substring(SUB_TAG_METHOD_BEGINNING.length())))) continue;
                    description.getSubTags().add(propertyName);
                    Parameter parameter = method.getParameters()[0];
                    ClassReference parameterClassReference = (ClassReference)PsiTreeUtil.findChildOfType((PsiElement)parameter, ClassReference.class, (boolean)false);
                    if (parameterClassReference == null) {
                        if (elementDef == null) continue;
                        PhingPhpDependentCustomElementsRegistry.this.myTypeDefErrors.put(elementDef, PhingBundle.message("framework.php.class.hint.not.found.for.parameter.of.method.0", method.getName()));
                        continue;
                    }
                    PhpClass paramClass = (PhpClass)parameterClassReference.resolve();
                    if (paramClass == null) {
                        if (elementDef == null) continue;
                        PhingPhpDependentCustomElementsRegistry.this.myTypeDefErrors.put(elementDef, PhingBundle.message("framework.php.class.hint.0.not.resolved", parameterClassReference.getName()));
                        continue;
                    }
                    innerClassDeclarations.add(Pair.create((Object)new XmlName(propertyName, ""), (Object)paramClass));
                    continue;
                }
                if (!methodName.startsWith(SUB_TAG_LIST_METHOD_BEGINNING) || method.getParameters().length != 0) continue;
                propertyName = StringUtil.toLowerCase((String)methodName.substring(SUB_TAG_LIST_METHOD_BEGINNING.length()));
                description.getSubTagLists().add(propertyName);
            }
            PhingPhpDependentCustomElementsRegistry.this.myCustomElements.put(xmlName, description);
            if (elementDef != null) {
                PhingPhpDependentCustomElementsRegistry.this.myDeclarations.put(xmlName, elementDef);
            }
            for (Pair declaration : innerClassDeclarations) {
                this.getDataOfPhpClass((XmlName)declaration.getFirst(), (PhpClass)declaration.getSecond(), null);
            }
        }

        private static PhpClassType getClassType(PhpClass phpClass) {
            while (phpClass != null) {
                if (TASK_BASE_CLASS_NAME.equals(phpClass.getName())) {
                    return PhpClassType.TASK;
                }
                if (TYPE_BASE_CLASS_NAME.equals(phpClass.getName())) {
                    return PhpClassType.TYPE;
                }
                phpClass = phpClass.getSuperClass();
            }
            return PhpClassType.UNKNOWN;
        }

        @Nullable
        private String getClassDescriptionTextAntOffset(PhingPredefinedTagDefiningNamedElement taskDefTask) {
            XmlTag tag = taskDefTask.getXmlTag();
            for (PsiElement psiElement : tag.getChildren()) {
                if (!(psiElement instanceof XmlText)) continue;
                ASTNode cdata = psiElement.getNode().findChildByType(XmlElementType.XML_CDATA);
                if (cdata == null) {
                    PhingPhpDependentCustomElementsRegistry.this.myTypeDefErrors.put(taskDefTask, PhingBundle.message("framework.no.nested.cdata.found", new Object[0]));
                    return null;
                }
                ASTNode textNode = cdata.findChildByType(XmlTokenType.XML_DATA_CHARACTERS);
                if (textNode != null && !StringUtil.isEmpty((String)textNode.getText())) {
                    return textNode.getText();
                }
                PhingPhpDependentCustomElementsRegistry.this.myTypeDefErrors.put(taskDefTask, PhingBundle.message("framework.php.class.not.found.in.description", new Object[0]));
                return null;
            }
            PhingPhpDependentCustomElementsRegistry.this.myTypeDefErrors.put(taskDefTask, PhingBundle.message("framework.no.nested.cdata.found", new Object[0]));
            return null;
        }

        @Override
        public void visitImport(PhingPredefinedImportTask importTag) {
            PhingPredefinedProject slaveProject;
            PsiFileSystemItem item = (PsiFileSystemItem)importTag.findFile().getValue();
            if (item instanceof PsiFile && (slaveProject = PhingUtils.getPhingDomProject((PsiFile)item)) != null) {
                slaveProject.accept(this);
            }
        }

        private static PhpFile loadContentAsFile(Project project, String text) {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
            return (PhpFile)factory.createFileFromText("_phing_dummy__." + PhpFileType.INSTANCE.getDefaultExtension(), (FileType)PhpFileType.INSTANCE, (CharSequence)(PhingPhpDependentCustomElementsRegistry.PHP_FILE_BEGINNING + text), LocalTimeCounter.currentTime(), false, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "xmlName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClass";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/phing/phpDependent/PhingPhpDependentCustomElementsRegistry$CustomTagDefinitionFinder";
            objectArray[2] = "getDataOfPhpClass";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PhingCustomClassDescription {
        private static final int TASK = 0;
        private static final int TYPE = 1;
        private static final int CHILD_OF_CUSTOM = 2;
        private final List<String> myAttributes;
        private final List<String> mySubTags;
        private final List<String> mySubTagLists;
        private final int myType;

        private PhingCustomClassDescription(int type) {
            this.myType = type;
            this.myAttributes = new ArrayList<String>();
            this.mySubTags = new ArrayList<String>();
            this.mySubTagLists = new ArrayList<String>();
        }

        public List<String> getAttributes() {
            return this.myAttributes;
        }

        public List<String> getSubTags() {
            return this.mySubTags;
        }

        public List<String> getSubTagLists() {
            return this.mySubTagLists;
        }

        public boolean isTask() {
            return this.myType == 0;
        }

        public boolean isType() {
            return this.myType == 1;
        }

        public boolean isChildOfCustom() {
            return this.myType == 2;
        }
    }

    public static class MyRequired
    implements Required {
        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return true;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum PhpClassType {
        TYPE{
            @NonNls
            private final List<String> PROHIBITED_TYPE_ATTRIBUTE_NAMES = Arrays.asList("listeningValue", "project");

            @Override
            public List<String> getProhibitedAttributeNames() {
                return this.PROHIBITED_TYPE_ATTRIBUTE_NAMES;
            }
        }
        ,
        TASK{
            @NonNls
            private final List<String> PROHIBITED_TASK_ATTRIBUTE_NAMES = Arrays.asList("owningTarget", "taskName", "taskType", "location", "runtimeConfigurableWrapper", "project");

            @Override
            public List<String> getProhibitedAttributeNames() {
                return this.PROHIBITED_TASK_ATTRIBUTE_NAMES;
            }
        }
        ,
        UNKNOWN{

            @Override
            public List<String> getProhibitedAttributeNames() {
                return Collections.emptyList();
            }
        };


        public abstract List<String> getProhibitedAttributeNames();
    }
}

