/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileParsedData;
import com.jetbrains.php.phing.PhingBuildListener;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingExecutionHandler;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.ui.PhingRunAction;
import com.jetbrains.php.phing.ui.explorer.PhingBeforeRunTask;
import com.jetbrains.php.phing.ui.explorer.PhingTargetChooserDialog;
import icons.PhingIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhingBeforeRunTaskProvider
extends BeforeRunTaskProvider<PhingBeforeRunTask> {
    public static final Key<PhingBeforeRunTask> ID = Key.create((String)"PhingTarget");
    @NonNls
    private static final List<String> USELESS_CONFIGURATIONS = Arrays.asList("LocalJavaScriptDebugConfiguration", "RemoteJavaScriptDebugConfiguration", "RemoteConfiguration");
    private final Project myProject;

    public PhingBeforeRunTaskProvider(Project project) {
        this.myProject = project;
    }

    public Key<PhingBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return PhingBundle.message("phing.target.before.run.description.empty", new Object[0]);
    }

    public Icon getIcon() {
        return PhingIcons.Target;
    }

    public String getDescription(PhingBeforeRunTask task) {
        String targetName = task.getTargetName();
        return PhingBundle.message("phing.target.before.run.description", targetName != null ? targetName : PhingBundle.message("phing.not.selected", new Object[0]));
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull PhingBeforeRunTask task) {
        PhingBuildTarget buildTarget;
        PhingTargetChooserDialog dialog;
        if (runConfiguration == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        if (task == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if ((dialog = new PhingTargetChooserDialog(this.myProject, buildTarget = this.findTargetToExecute(task))).showAndGet()) {
            VirtualFile vFile;
            task.setTargetName(null);
            task.setPhingFileUrl(null);
            buildTarget = dialog.getSelectedTarget();
            if (buildTarget != null && (vFile = buildTarget.getContextFile()) != null) {
                task.setPhingFileUrl(vFile.getUrl());
                task.setTargetName(buildTarget.getName());
            }
            return true;
        }
        return false;
    }

    public PhingBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (USELESS_CONFIGURATIONS.contains(runConfiguration.getClass().getSimpleName())) {
            return null;
        }
        return new PhingBeforeRunTask();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull PhingBeforeRunTask task) {
        if (configuration == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (task == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        return task.getPhingFileUrl() != null && task.getTargetName() != null;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull PhingBeforeRunTask task) {
        if (context == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (env == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (task == null) {
            PhingBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        final Ref isExecuted = Ref.create();
        final Ref errorMessage = Ref.create();
        Project project = env.getProject();
        final Semaphore targetDone = new Semaphore();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            final PhingBuildTarget target = this.findTargetToExecute(task);
            if (target == null) {
                isExecuted.set((Object)Boolean.FALSE);
                errorMessage.set((Object)PhingBundle.message("failed.to.find.phing.target.0", task.getTargetName()));
                return;
            }
            if (project.isDisposed()) {
                isExecuted.set((Object)Boolean.FALSE);
                errorMessage.set((Object)PhingBundle.message("failed.to.run.phing.target.0", target.getName()));
                return;
            }
            PhingStateService stateService = PhingStateService.getInstance(project);
            PhingBuildFile buildFile = stateService.getBuildFile(target.getContextFile());
            if (!PhingRunAction.requestValidPhingPath(buildFile, project, stateService)) {
                isExecuted.set((Object)Boolean.FALSE);
                return;
            }
            PhingBuildListener listener = new PhingBuildListener(){

                @Override
                public void buildFinished(int state) {
                    if (0 == state) {
                        isExecuted.set((Object)Boolean.TRUE);
                    } else {
                        errorMessage.set((Object)PhingBundle.message("phing.target.0.execution.failed", target.getName()));
                        isExecuted.set((Object)Boolean.FALSE);
                    }
                    targetDone.up();
                }
            };
            targetDone.down();
            PhingExecutionHandler.runBuild(buildFile, task.getTargetName(), null, listener, context);
        }, ModalityState.nonModal());
        targetDone.waitFor();
        if (!((Boolean)isExecuted.get()).booleanValue() && !errorMessage.isNull()) {
            String message = PhingBundle.message("0.run.configuration.was.stopped", StringUtil.decapitalize((String)((String)errorMessage.get())), configuration.getName());
            Notification info = new Notification("Phing", PhingBundle.message("phing.configurable.display.name", new Object[0]), message, NotificationType.WARNING);
            Notifications.Bus.notify((Notification)info, (Project)project);
        }
        return (Boolean)isExecuted.get();
    }

    @Nullable
    private PhingBuildTarget findTargetToExecute(PhingBeforeRunTask task) {
        String fileUrl = task.getPhingFileUrl();
        String targetName = task.getTargetName();
        if (fileUrl == null || targetName == null) {
            return null;
        }
        VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        if (vFile == null) {
            return null;
        }
        PhingStateService phingStateService = PhingStateService.getInstance(this.myProject);
        PhingBuildFile buildFile = phingStateService.getBuildFile(vFile);
        if (buildFile == null) {
            return null;
        }
        PhingBuildFileParsedData parsedData = phingStateService.getParsedData(buildFile);
        if (parsedData == null) {
            return null;
        }
        List<PhingBuildTarget> targets = parsedData.getTargets();
        for (PhingBuildTarget target : targets) {
            if (!targetName.equals(target.getName())) continue;
            return target;
        }
        return null;
    }

    public void handleTargetRename(String oldName, String newName) {
        for (PhingBeforeRunTask task : RunManagerEx.getInstanceEx((Project)this.myProject).getBeforeRunTasks(ID)) {
            if (!oldName.equals(task.getTargetName())) continue;
            task.setTargetName(newName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canExecuteTask";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

