/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.ui.explorer.PhingNodeDescriptor;
import icons.PhingIcons;
import org.jetbrains.annotations.NotNull;

public class PhingBuildFileNodeDescriptor
extends PhingNodeDescriptor {
    private final PhingBuildFile myBuildFile;
    private CompositeAppearance myAppearance;

    public PhingBuildFileNodeDescriptor(Project project, NodeDescriptor parentDescriptor, PhingBuildFile buildFile) {
        super(project, parentDescriptor);
        this.myBuildFile = buildFile;
    }

    public Object getElement() {
        return this.myBuildFile;
    }

    public PhingBuildFile getBuildFile() {
        return this.myBuildFile;
    }

    public boolean update() {
        GenericAttributeValue<String> projectName;
        PhingPredefinedProject project;
        PsiFile psiFile;
        CompositeAppearance oldAppearance = this.myAppearance;
        this.myAppearance = new CompositeAppearance();
        this.myAppearance.getEnding().addText(this.myBuildFile.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        VirtualFile file = this.myBuildFile.getFile();
        PsiFile psiFile2 = psiFile = file.isValid() ? PsiManager.getInstance((Project)this.myBuildFile.getProject()).findFile(file) : null;
        if (psiFile != null && (project = PhingUtils.getPhingDomProject(psiFile)) != null && (projectName = project.findName()).exists()) {
            this.myAppearance.getEnding().addText(" <" + (String)projectName.getValue() + ">", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        this.setIcon(PhingIcons.Phing);
        this.myName = this.myBuildFile.getPresentableName();
        return !Comparing.equal((Object)this.myAppearance, (Object)oldAppearance);
    }

    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            PhingBuildFileNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (this.myAppearance != null) {
            this.myAppearance.customize(component);
        } else {
            super.customize(component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/php/phing/ui/explorer/PhingBuildFileNodeDescriptor", "customize"));
    }
}

