/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.RunManagerListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import com.jetbrains.php.phing.InvalidPhingFileException;
import com.jetbrains.php.phing.PhingActionIdUtils;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildListener;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingExecutionHandler;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.ui.PhingConfigurable;
import com.jetbrains.php.phing.ui.PhingRunAction;
import com.jetbrains.php.phing.ui.explorer.PhingBuildFileNodeDescriptor;
import com.jetbrains.php.phing.ui.explorer.PhingExecuteBeforeRunDialog;
import com.jetbrains.php.phing.ui.explorer.PhingExplorerTreeStructure;
import com.jetbrains.php.phing.ui.explorer.PhingNodeDescriptor;
import com.jetbrains.php.phing.ui.explorer.PhingPropertiesDialog;
import com.jetbrains.php.phing.ui.explorer.PhingStateListener;
import com.jetbrains.php.phing.ui.explorer.PhingTargetNodeDescriptor;
import icons.PhingIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhingExplorer
extends SimpleToolWindowPanel
implements DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(PhingExplorer.class);
    private static final Icon ICON_REMOVE = IconUtil.getRemoveIcon();
    private static final Icon ICON_ADD = IconUtil.getAddIcon();
    @NonNls
    public static final String HELP_ID = "reference.phing.tool.window";
    public static final DataKey<PhingExplorer> PHING_EXPLORER_KEY = DataKey.create((String)"phingExplorerKey");
    private StructureTreeModel myModel;
    private DefaultActionGroup myPopupActionGroup;
    private Project myProject;
    private Tree myTree;
    private final PhingBuildFilePropertiesAction myPhingBuildFilePropertiesAction;
    private PhingStateListener myPhingBuildListener;
    private PhingStateService myPhingState;
    private final TreeExpander myTreeExpander = new DefaultTreeExpander(() -> this.myTree){

        protected void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
            if (tree == null) {
                1.$$$reportNull$$$0(0);
            }
            super.collapseAll(tree, 2);
        }

        protected boolean isEnabled(@NotNull JTree tree) {
            if (tree == null) {
                1.$$$reportNull$$$0(1);
            }
            return !PhingExplorer.this.myPhingState.getBuildFiles().isEmpty() && super.isEnabled(tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collapseAll";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public PhingExplorer(Project project) {
        super(true, true);
        this.myProject = project;
        this.myPhingState = PhingStateService.getInstance(this.myProject);
        this.myModel = new StructureTreeModel((AbstractTreeStructure)new PhingExplorerTreeStructure(project), (Comparator)IndexComparator.getInstance(), (Disposable)this);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)this.myModel, (Disposable)this);
        this.myTree = new Tree((TreeModel)asyncTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new NodeRenderer()));
        DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
        this.myTree.setSelectionModel((TreeSelectionModel)selModel);
        selModel.setSelectionMode(4);
        TreeUtil.installActions((JTree)this.myTree);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTree);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                PhingExplorer.this.popupInvoked(comp, x, y);
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                TreePath path;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((path = PhingExplorer.this.myTree.getPathForLocation(e.getX(), e.getY())) != null) {
                    PhingExplorer.this.runSelection();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phing/ui/explorer/PhingExplorer$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myTree);
        this.myTree.registerKeyboardAction((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhingExplorer.this.runSelection();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.myPhingBuildFilePropertiesAction = new PhingBuildFilePropertiesAction();
        this.setToolbar(this.createToolbarPanel());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        DomManager.getDomManager((Project)project).addDomEventListener(new DomEventListener(){

            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                PhingExplorer.this.myModel.invalidateAsync();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phing/ui/explorer/PhingExplorer$5", "eventOccured"));
            }
        }, (Disposable)this);
        this.myProject.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void beforeRunTasksChanged() {
                PhingExplorer.this.myModel.invalidateAsync();
            }
        });
        this.myPhingBuildListener = new PhingStateListener(){

            @Override
            public void buildFileChanged(PhingBuildFile buildFile) {
                PhingExplorer.this.invalidateForFile(buildFile);
            }

            @Override
            public void buildFileAdded(PhingBuildFile buildFile) {
                PhingExplorer.this.myModel.invalidateAsync();
            }

            @Override
            public void buildFileRemoved(PhingBuildFile buildFile) {
                if (PhingExplorer.this.myModel != null) {
                    PhingExplorer.this.myModel.invalidateAsync();
                }
            }
        };
        PhingStateService.getInstance(this.myProject).addPhingStateListener(this.myPhingBuildListener);
    }

    public void dispose() {
        if (this.myProject != null && this.myPhingBuildListener != null) {
            PhingStateService.getInstance(this.myProject).removePhingStateListener(this.myPhingBuildListener);
        }
        this.myProject = null;
        this.myPhingState = null;
        this.myPhingBuildListener = null;
        this.myModel = null;
        if (this.myTree != null) {
            KeyStroke[] strokes;
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)this.myTree);
            for (KeyStroke keyStroke : strokes = this.myTree.getRegisteredKeyStrokes()) {
                this.myTree.unregisterKeyboardAction(keyStroke);
            }
            this.myTree = null;
        }
    }

    private JPanel createToolbarPanel() {
        if (this.myPopupActionGroup == null) {
            this.myPopupActionGroup = new DefaultActionGroup();
            this.myPopupActionGroup.add((AnAction)new AddAction());
            this.myPopupActionGroup.add((AnAction)new RemoveAction());
            this.myPopupActionGroup.add(ActionManager.getInstance().getAction("RunPhingBuild"));
            this.myPopupActionGroup.add((AnAction)new ShowAllTargetsAction());
            CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
            AnAction action = commonActionsManager.createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this));
            action.getTemplatePresentation().setDescription(PhingBundle.messagePointer("phing.explorer.expand.all.nodes.action.description", new Object[0]));
            this.myPopupActionGroup.add(action);
            action = commonActionsManager.createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this));
            action.getTemplatePresentation().setDescription(PhingBundle.messagePointer("phing.explorer.collapse.all.nodes.action.description", new Object[0]));
            this.myPopupActionGroup.add(action);
            this.myPopupActionGroup.add((AnAction)this.myPhingBuildFilePropertiesAction);
        }
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar("PhingExplorerToolbar", (ActionGroup)this.myPopupActionGroup, true);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)actionToolBar.getComponent(), "Center");
        return buttonsPanel;
    }

    private void addBuildFile() {
        FileChooserDescriptor descriptor = PhingExplorer.createXmlDescriptor();
        descriptor.setTitle(PhingBundle.message("select.phing.build.file.dialog.title", new Object[0]));
        descriptor.setDescription(PhingBundle.message("select.phing.build.file.dialog.description", new Object[0]));
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, null);
        if (files.length == 0) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            PhingStateService phingState = this.myPhingState;
            ArrayList<VirtualFile> ignoredFiles = new ArrayList<VirtualFile>();
            for (VirtualFile file : files) {
                try {
                    phingState.addBuildFile(file);
                }
                catch (InvalidPhingFileException e) {
                    ignoredFiles.add(file);
                }
            }
            if (ignoredFiles.size() != 0) {
                Messages.showWarningDialog((Project)this.myProject, (String)StringUtil.join(ignoredFiles, VirtualFile::getPresentableUrl, (String)"\n"), (String)PhingBundle.message("cannot.phing.phing.files.dialog.title", new Object[0]));
            }
        });
    }

    private void runSelection() {
        if (!this.canRunSelection()) {
            return;
        }
        if (PhingStateService.isPhingPathInvalid(this.myPhingState.getPhingPath())) {
            this.askForPhingConfiguration(false);
            if (PhingStateService.isPhingPathInvalid(this.myPhingState.getPhingPath())) {
                return;
            }
        }
        PhingBuildFile buildFile = this.getCurrentBuildFile();
        TreePath[] paths = this.myTree.getSelectionPaths();
        String target = PhingExplorer.getTargetNameFromPath(paths);
        PhingExecutionHandler.runBuild(buildFile, target, null, PhingBuildListener.NULL, DataManager.getInstance().getDataContext((Component)this.myTree));
    }

    private boolean isSingleFileSelected() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return false;
        }
        PhingBuildFile file = this.getCurrentBuildFile();
        return file != null && file.exists();
    }

    private boolean canRunSelection() {
        if (this.myTree == null) {
            return false;
        }
        if (!this.isSingleFileSelected()) {
            return false;
        }
        PhingBuildFile buildFile = this.getCurrentBuildFile();
        if (buildFile == null || !buildFile.exists()) {
            return false;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            PhingBuildFileNodeDescriptor buildFileNodeDescriptor = userObject instanceof PhingTargetNodeDescriptor ? (PhingBuildFileNodeDescriptor)((Object)((DefaultMutableTreeNode)node.getParent()).getUserObject()) : (userObject instanceof PhingBuildFileNodeDescriptor ? (PhingBuildFileNodeDescriptor)((Object)userObject) : null);
            if (buildFileNodeDescriptor != null && buildFileNodeDescriptor.getBuildFile() == buildFile) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getTargetNameFromPath(TreePath[] paths) {
        Object userObject;
        LOG.assertTrue(paths.length < 2);
        if (paths.length == 1 && (userObject = ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject()) instanceof PhingTargetNodeDescriptor) {
            PhingBuildTarget target = ((PhingTargetNodeDescriptor)((Object)userObject)).getTarget();
            return target.getName();
        }
        return null;
    }

    @Nullable
    private PhingBuildFile getCurrentBuildFile() {
        Iterator<PhingBuildFile> iterator = this.getCurrentBuildFiles(true).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    @NotNull
    private Set<PhingBuildFile> getCurrentBuildFiles(boolean single) {
        TreePath[] paths;
        if (this.myTree == null) {
            Set<PhingBuildFile> set = Collections.emptySet();
            if (set == null) {
                PhingExplorer.$$$reportNull$$$0(0);
            }
            return set;
        }
        if (single) {
            TreePath path = this.myTree.getSelectionPath();
            if (path == null) {
                Set<PhingBuildFile> set = Collections.emptySet();
                if (set == null) {
                    PhingExplorer.$$$reportNull$$$0(1);
                }
                return set;
            }
            paths = new TreePath[]{path};
        } else {
            paths = this.myTree.getSelectionPaths();
            if (paths == null) {
                Set<PhingBuildFile> set = Collections.emptySet();
                if (set == null) {
                    PhingExplorer.$$$reportNull$$$0(2);
                }
                return set;
            }
        }
        HashSet<PhingBuildFile> files = new HashSet<PhingBuildFile>(paths.length);
        for (TreePath path : paths) {
            for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof PhingBuildFileNodeDescriptor)) continue;
                files.add(((PhingBuildFileNodeDescriptor)((Object)userObject)).getBuildFile());
            }
        }
        HashSet<PhingBuildFile> hashSet = files;
        if (hashSet == null) {
            PhingExplorer.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private void popupInvoked(Component comp, int x, int y) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("RunPhingBuild"));
        group.add(ActionManager.getInstance().getAction("EditSource"));
        group.add((AnAction)new RemoveAction());
        group.add((AnAction)new ExecuteBeforeRunAction());
        group.add((AnAction)new AssignShortcutAction());
        group.add((AnAction)new HideAction());
        group.add((AnAction)this.myPhingBuildFilePropertiesAction);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("PhingExplorerPopup", (ActionGroup)group);
        popupMenu.getComponent().show(comp, x, y);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            PhingExplorer.$$$reportNull$$$0(4);
        }
        super.uiDataSnapshot(sink);
        TreePath[] paths = this.myTree.getSelectionPaths();
        Object selection = TreeUtil.getLastUserObject((TreePath)this.myTree.getLeadSelectionPath());
        PhingBuildFile buildFile = this.getCurrentBuildFile();
        sink.set(PHING_EXPLORER_KEY, (Object)this);
        sink.set(PlatformDataKeys.TREE_EXPANDER, (Object)this.myTreeExpander);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)HELP_ID);
        if (paths == null || buildFile == null) {
            return;
        }
        if (this.canRunSelection()) {
            sink.set(PhingRunAction.SELECTED_BUILD_FILE, (Object)buildFile);
            sink.set(PhingRunAction.SELECTED_TARGET, (Object)PhingExplorer.getTargetNameFromPath(paths));
        }
        if (this.isSingleFileSelected() && selection instanceof PhingTargetNodeDescriptor) {
            PhingTargetNodeDescriptor desc = (PhingTargetNodeDescriptor)((Object)selection);
            sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
                PhingBuildTarget buildTarget = desc.getTarget();
                Navigatable descriptor = buildTarget.getOpenFileDescriptor();
                if (descriptor != null && descriptor.canNavigate()) {
                    return descriptor;
                }
                return null;
            });
        }
        sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> {
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            block0: for (TreePath path : paths) {
                for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
                    VirtualFile virtualFile;
                    Object userObject = node.getUserObject();
                    if (!(userObject instanceof PhingBuildFileNodeDescriptor)) continue;
                    PhingBuildFileNodeDescriptor desc = (PhingBuildFileNodeDescriptor)((Object)((Object)userObject));
                    PhingBuildFile file = desc.getBuildFile();
                    if (file == null || (virtualFile = file.getFile()) == null || !virtualFile.isValid()) continue block0;
                    result.add(virtualFile);
                    continue block0;
                }
            }
            return result.isEmpty() ? null : VfsUtilCore.toVirtualFileArray(result);
        });
    }

    private static FileChooserDescriptor createXmlDescriptor() {
        return FileChooserDescriptorFactory.createMultipleFilesNoJarsDescriptor().withExtensionFilter((FileType)XmlFileType.INSTANCE);
    }

    private void invalidateForFile(PhingBuildFile buildFile) {
        TreeNode node = TreeUtil.findNodeWithObject((Object)buildFile, (TreeModel)this.myModel, (Object)this.myModel.getRoot());
        if (node != null) {
            TreePath pathFromRoot = TreeUtil.getPathFromRoot((TreeNode)node);
            this.myModel.invalidate(pathFromRoot, true);
        }
    }

    @NlsActions.ActionText
    private static String getShowTargetsActionText(boolean isSelected) {
        if (isSelected) {
            return PhingBundle.message("show.all.targets.action.text.show", new Object[0]);
        }
        return PhingBundle.message("show.all.targets.action.text.hide", new Object[0]);
    }

    @NlsActions.ActionDescription
    private static String getShowTargetsActionDescription(boolean isSelected) {
        if (isSelected) {
            return PhingBundle.message("show.all.targets.action.description.show", new Object[0]);
        }
        return PhingBundle.message("show.all.targets.action.description.hide", new Object[0]);
    }

    @Nullable
    private PhingBuildTarget getSelectedTarget() {
        DefaultMutableTreeNode node;
        Object userObject = null;
        TreePath path = this.myTree.getSelectionPath();
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()) != null) {
            userObject = node.getUserObject();
        }
        if (userObject instanceof PhingTargetNodeDescriptor) {
            return ((PhingTargetNodeDescriptor)((Object)userObject)).getTarget();
        }
        return null;
    }

    private void askForPhingConfiguration(boolean full) {
        boolean isOk;
        PhingBuildFile currentBuildFile = this.getCurrentBuildFile();
        if (currentBuildFile == null) {
            return;
        }
        if (full) {
            PhingPropertiesDialog dialog = new PhingPropertiesDialog(currentBuildFile);
            isOk = dialog.showAndGet();
        } else {
            isOk = ShowSettingsUtil.getInstance().editConfigurable(currentBuildFile.getProject(), (Configurable)new PhingConfigurable(currentBuildFile.getProject()));
        }
        if (isOk) {
            this.myModel.invalidateAsync();
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(currentBuildFile.getFile());
            if (psiFile != null) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBuildFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class NodeRenderer
    extends ColoredTreeCellRenderer {
        private NodeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (tree == null) {
                NodeRenderer.$$$reportNull$$$0(0);
            }
            if ((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof PhingNodeDescriptor) {
                PhingNodeDescriptor descriptor = (PhingNodeDescriptor)((Object)userObject);
                descriptor.customize((SimpleColoredComponent)this);
            } else {
                @NlsSafe String fragment = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
                this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/php/phing/ui/explorer/PhingExplorer$NodeRenderer", "customizeCellRenderer"));
        }
    }

    private final class PhingBuildFilePropertiesAction
    extends AnAction {
        private PhingBuildFilePropertiesAction() {
            super(PhingBundle.message("build.file.properties.action.name", new Object[0]), PhingBundle.message("build.file.properties.action.description", new Object[0]), AllIcons.Actions.Properties);
            this.registerCustomShortcutSet(CommonShortcuts.ALT_ENTER, (JComponent)((Object)PhingExplorer.this));
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                PhingBuildFilePropertiesAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(PhingExplorer.this.isSingleFileSelected());
            if ("PhingExplorerPopup".equals(event.getPlace())) {
                presentation.setVisible(presentation.isEnabled());
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                PhingBuildFilePropertiesAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PhingBuildFilePropertiesAction.$$$reportNull$$$0(2);
            }
            PhingExplorer.this.askForPhingConfiguration(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$PhingBuildFilePropertiesAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$PhingBuildFilePropertiesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class AddAction
    extends AnAction {
        private AddAction() {
            super(PhingBundle.messagePointer("add.phing.file.action.name", new Object[0]), PhingBundle.messagePointer("add.phing.file.action.description", new Object[0]), ICON_ADD);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            PhingExplorer.this.addBuildFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phing/ui/explorer/PhingExplorer$AddAction", "actionPerformed"));
        }
    }

    private final class RemoveAction
    extends AnAction {
        private RemoveAction() {
            super(PhingBundle.message("remove.phing.file.action.name", new Object[0]), PhingBundle.message("remove.phing.file.action.description", new Object[0]), ICON_REMOVE);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)PhingExplorer.this.myTree);
            Disposer.register((Disposable)PhingExplorer.this, (Disposable)new Disposable(){

                public void dispose() {
                    RemoveAction.this.unregisterCustomShortcutSet((JComponent)PhingExplorer.this.myTree);
                }
            });
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Set<PhingBuildFile> buildFilesSet;
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(0);
            }
            if ((buildFilesSet = PhingExplorer.this.getCurrentBuildFiles(false)).isEmpty()) {
                return;
            }
            int size = buildFilesSet.size();
            String text = size == 1 ? buildFilesSet.iterator().next().getPresentableUrl() : PhingBundle.message("remove.0.files", size);
            int result = Messages.showYesNoDialog((Project)PhingExplorer.this.myProject, (String)PhingBundle.message("remove.the.reference.to.file.confirmation.text", size, text), (String)PhingBundle.message("confirm.remove.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result != 0) {
                return;
            }
            for (PhingBuildFile phingBuildFile : buildFilesSet) {
                PhingExplorer.this.myPhingState.removeBuildFile(phingBuildFile);
            }
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                RemoveAction.$$$reportNull$$$0(1);
            }
            if ("PhingExplorerToolbar".equals(event.getPlace())) {
                event.getPresentation().setEnabled(PhingExplorer.this.getCurrentBuildFile() != null);
            } else {
                event.getPresentation().setEnabled(true);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RemoveAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$RemoveAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$RemoveAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ShowAllTargetsAction
    extends ToggleAction {
        private ShowAllTargetsAction() {
            super(PhingExplorer.getShowTargetsActionText(PhingExplorer.this.myPhingState.isHideTargets()), PhingExplorer.getShowTargetsActionDescription(PhingExplorer.this.myPhingState.isHideTargets()), PhingIcons.Target_hiding);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowAllTargetsAction.$$$reportNull$$$0(0);
            }
            return PhingExplorer.this.myPhingState.isHideTargets();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ShowAllTargetsAction.$$$reportNull$$$0(1);
            }
            event.getPresentation().setText(PhingExplorer.getShowTargetsActionText(flag));
            event.getPresentation().setDescription(PhingExplorer.getShowTargetsActionDescription(flag));
            PhingExplorer.this.myModel.invalidateAsync();
            PhingExplorer.this.myPhingState.setHideTargets(flag);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowAllTargetsAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$ShowAllTargetsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$ShowAllTargetsAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ExecuteBeforeRunAction
    extends AnAction {
        private ExecuteBeforeRunAction() {
            super(PhingBundle.messagePointer("phing.executes.before.run.debug.acton.name", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteBeforeRunAction.$$$reportNull$$$0(0);
            }
            PhingExecuteBeforeRunDialog dialog = new PhingExecuteBeforeRunDialog(PhingExplorer.this.myProject, PhingExplorer.this.getSelectedTarget());
            dialog.show();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteBeforeRunAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            PhingBuildTarget target = PhingExplorer.this.getSelectedTarget();
            TreePath[] paths = PhingExplorer.this.myTree.getSelectionPaths();
            presentation.setEnabled(target != null && paths != null && paths.length == 1 && target.getContextFile().exists());
            if (e.isFromContextMenu()) {
                presentation.setVisible(presentation.isEnabled());
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ExecuteBeforeRunAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$ExecuteBeforeRunAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$ExecuteBeforeRunAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class AssignShortcutAction
    extends AnAction {
        private AssignShortcutAction() {
            super(PhingBundle.messagePointer("phing.explorer.assign.shortcut.action.name", new Object[0]), PhingBundle.messagePointer("phing.explorer.assign.shortcut.action.description", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AssignShortcutAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            PhingBuildTarget target = PhingExplorer.this.getSelectedTarget();
            TreePath[] paths = PhingExplorer.this.myTree.getSelectionPaths();
            presentation.setEnabled(target != null && paths != null && paths.length == 1 && target.getContextFile().exists() && ActionManager.getInstance().getAction(PhingActionIdUtils.getActionId(target)) != null);
            if (e.isFromContextMenu()) {
                presentation.setVisible(presentation.isEnabled());
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AssignShortcutAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PhingBuildTarget target;
            if (e == null) {
                AssignShortcutAction.$$$reportNull$$$0(2);
            }
            if ((target = PhingExplorer.this.getSelectedTarget()) == null) {
                return;
            }
            new EditKeymapsDialog(PhingExplorer.this.myProject, PhingActionIdUtils.getActionId(target)).show();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$AssignShortcutAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$AssignShortcutAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class HideAction
    extends AnAction {
        private HideAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<PhingBuildTarget> targets;
            if (e == null) {
                HideAction.$$$reportNull$$$0(0);
            }
            if ((targets = this.getSelectedTargets()).isEmpty()) {
                return;
            }
            boolean targetsAreHidden = PhingExplorer.this.myPhingState.isHideTargets();
            boolean unmark = !targetsAreHidden && HideAction.unmarkToHideSelectedTargets(targets);
            boolean localUpdate = targetsAreHidden || unmark;
            for (PhingBuildTarget target : targets) {
                if (unmark) {
                    target.getContextBuildFile().getTargetsToHide().remove(target.getName());
                } else {
                    target.getContextBuildFile().addTargetToHide(target.getName());
                }
                if (!localUpdate) continue;
                PhingExplorer.this.invalidateForFile(target.getContextBuildFile());
            }
            if (!localUpdate) {
                PhingExplorer.this.myPhingState.setHideTargets(true);
                PhingExplorer.this.myModel.invalidateAsync();
            }
        }

        @NotNull
        private List<PhingBuildTarget> getSelectedTargets() {
            TreePath[] paths = PhingExplorer.this.myTree.getSelectionPaths();
            if (paths == null) {
                List<PhingBuildTarget> list = Collections.emptyList();
                if (list == null) {
                    HideAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            ArrayList<PhingBuildTarget> targets = new ArrayList<PhingBuildTarget>();
            for (TreePath path : paths) {
                for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
                    Object userObject = node.getUserObject();
                    if (!(userObject instanceof PhingTargetNodeDescriptor)) continue;
                    targets.add(((PhingTargetNodeDescriptor)((Object)userObject)).getTarget());
                }
            }
            ArrayList<PhingBuildTarget> arrayList = targets;
            if (arrayList == null) {
                HideAction.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                HideAction.$$$reportNull$$$0(3);
            }
            List<PhingBuildTarget> selectedTargets = this.getSelectedTargets();
            Presentation presentation = event.getPresentation();
            if (selectedTargets.isEmpty()) {
                presentation.setVisible(false);
            } else {
                presentation.setVisible(true);
                if (HideAction.unmarkToHideSelectedTargets(selectedTargets)) {
                    presentation.setText(PhingBundle.messagePointer("hide.action.text.unmark", new Object[0]));
                } else {
                    presentation.setText(PhingBundle.messagePointer("hide.action.text.mark", new Object[0]));
                }
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                HideAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        private static boolean unmarkToHideSelectedTargets(List<PhingBuildTarget> selectedTargets) {
            PhingBuildTarget firstTarget = selectedTargets.get(0);
            return firstTarget.getContextBuildFile().getTargetsToHide().contains(firstTarget.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$HideAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorer$HideAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedTargets";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

