/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileParsedData;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.ui.PhingConfigurable;
import com.jetbrains.php.phing.ui.explorer.PhingPropertiesTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PhingPropertiesDialog
extends DialogWrapper {
    private static final int MAX_FILE_PATH_LENGTH = 50;
    private JPanel myMainPanel;
    private final PhingConfigurable myPhingConfigurable;
    private RawCommandLineEditor myRunningOptionsEditor;
    private JPanel myPanelForTabs;
    private JPanel myPathPanel;
    private final TableView<HidingTargetSetting> myHiddenTargetsTable;
    private final ListTableModel<HidingTargetSetting> myHiddenTargetsModel;
    private final PhingPropertiesTab myPropertiesTab;
    private final PhingBuildFile myBuildFile;
    private final ColumnInfo<HidingTargetSetting, Boolean> HIDDEN_COLUMN_INFO;
    private static final ColumnInfo<HidingTargetSetting, String> TARGET_COLUMN_INFO = new ColumnInfo<HidingTargetSetting, String>(PhingBundle.message("target.column.name", new Object[0])){

        public String valueOf(HidingTargetSetting setting) {
            return setting.getTargetName();
        }
    };

    protected PhingPropertiesDialog(PhingBuildFile buildFile) {
        super(buildFile.getProject(), false);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.HIDDEN_COLUMN_INFO = new ColumnInfo<HidingTargetSetting, Boolean>(PhingBundle.message("hide.column.name", objectArray)){
            private int NAME_LENGTH;
            {
                this.NAME_LENGTH = 0;
            }

            public Boolean valueOf(HidingTargetSetting setting) {
                return setting.getHide() != false || setting.isHiddenByAttribute();
            }

            public boolean isCellEditable(HidingTargetSetting setting) {
                return !setting.isHiddenByAttribute();
            }

            public void setValue(HidingTargetSetting setting, Boolean value) {
                if (!setting.isHiddenByAttribute()) {
                    setting.setHide(value);
                }
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public TableCellRenderer getRenderer(HidingTargetSetting setting) {
                if (!setting.isHiddenByAttribute()) {
                    return new BooleanTableCellRenderer();
                }
                return new BooleanTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
                        Component component = super.getTableCellRendererComponent(table, value, isSel, hasFocus, row, column);
                        if (component instanceof JCheckBox) {
                            component.setEnabled(false);
                        }
                        return component;
                    }
                };
            }

            public int getWidth(JTable table) {
                if (this.NAME_LENGTH == 0) {
                    this.NAME_LENGTH = PhingPropertiesDialog.getWordLength(this.getName(), PhingPropertiesDialog.this.myHiddenTargetsTable);
                }
                return this.NAME_LENGTH;
            }
        };
        this.myBuildFile = buildFile;
        this.myPhingConfigurable = new PhingConfigurable(buildFile.getProject());
        this.myPhingConfigurable.setPathLabelTextMoreDescriptive();
        this.myPathPanel.add((Component)this.myPhingConfigurable.getComponent(), "Center");
        JBTabs tabs = JBTabsFactory.createTabs((Project)buildFile.getProject());
        this.myPropertiesTab = new PhingPropertiesTab();
        TabInfo propertiesInfo = new TabInfo((JComponent)this.myPropertiesTab.getComponent());
        propertiesInfo.setText(PhingBundle.message("properties.border.title", new Object[0]));
        tabs.addTab(propertiesInfo);
        this.myHiddenTargetsTable = new TableView();
        this.myHiddenTargetsModel = new ListTableModel(new ColumnInfo[]{this.HIDDEN_COLUMN_INFO, TARGET_COLUMN_INFO});
        this.myHiddenTargetsTable.setModelAndUpdateColumns(this.myHiddenTargetsModel);
        JBScrollPane scrollPane = new JBScrollPane();
        scrollPane.getViewport().add((Component)this.myHiddenTargetsTable);
        TabInfo targetsInfo = new TabInfo((JComponent)scrollPane);
        targetsInfo.setText(PhingBundle.message("targets.hiding.tab.name", new Object[0]));
        tabs.addTab(targetsInfo);
        this.myPanelForTabs.add((Component)tabs.getComponent(), "Center");
        PhingStateService phingState = PhingStateService.getInstance(buildFile.getProject());
        this.initializeWithBuildFile(buildFile, phingState);
        this.init();
        this.pack();
    }

    private void initializeWithBuildFile(PhingBuildFile buildFile, PhingStateService service) {
        String filePath = PhingPropertiesDialog.getPresentableShortFilePath(buildFile);
        this.setTitle(PhingBundle.message("phing.properties.title.phing.properties", filePath));
        this.myRunningOptionsEditor.setText(buildFile.getCommandLineOptions());
        this.myRunningOptionsEditor.setDialogCaption(PhingBundle.message("phing.properties.dialog.title.command.line.options", new Object[0]));
        this.myPropertiesTab.initializeWithBuildFile(buildFile);
        List<String> targetsToHide = buildFile.getTargetsToHide();
        PhingBuildFileParsedData parsedData = service.getParsedData(buildFile);
        if (parsedData != null) {
            for (PhingBuildTarget target : parsedData.getTargets()) {
                this.myHiddenTargetsModel.addRow((Object)new HidingTargetSetting(target.getName(), targetsToHide.contains(target.getName()), target.isHiddenByAttribute()));
            }
        }
    }

    private static String getPresentableShortFilePath(PhingBuildFile buildFile) {
        VirtualFile projectFile = buildFile.getProject().getBaseDir();
        Object filePath = null;
        if (projectFile != null) {
            filePath = VfsUtilCore.getRelativePath((VirtualFile)buildFile.getFile(), (VirtualFile)projectFile, (char)File.separatorChar);
        }
        if (filePath == null) {
            filePath = buildFile.getFile().getPath();
        }
        if (((String)filePath).length() > 50) {
            String[] fileElements = ((String)filePath).split(Matcher.quoteReplacement(File.separator));
            StringBuilder sb = new StringBuilder();
            for (int i = fileElements.length - 1; i > -1 && sb.length() + fileElements[i].length() < 50; --i) {
                sb.insert(0, fileElements[i]);
                sb.insert(0, File.separator);
            }
            filePath = sb.toString();
            if (((String)filePath).isEmpty()) {
                filePath = File.separator + fileElements[fileElements.length - 1];
            }
        }
        return filePath;
    }

    protected void doOKAction() {
        this.myBuildFile.setCommandLineOptions(this.myRunningOptionsEditor.getText());
        this.myPropertiesTab.writeToBuildFile(this.myBuildFile);
        ArrayList<String> targetsToHide = new ArrayList<String>();
        for (HidingTargetSetting setting : this.myHiddenTargetsModel.getItems()) {
            if (!setting.getHide().booleanValue()) continue;
            targetsToHide.add(setting.getTargetName());
        }
        boolean setHiding = false;
        PhingStateService stateService = PhingStateService.getInstance(this.myBuildFile.getProject());
        if (!stateService.isHideTargets()) {
            List<String> oldTargetsToHide = this.myBuildFile.getTargetsToHide();
            for (String s : targetsToHide) {
                if (oldTargetsToHide.contains(s)) continue;
                setHiding = true;
                break;
            }
        }
        this.myBuildFile.setTargetsToHide(targetsToHide);
        if (setHiding) {
            stateService.setHideTargets(true);
        }
        this.myPhingConfigurable.apply();
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName() + "DimensionServiceKey";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPhingConfigurable.getPreferredFocusedComponent();
    }

    private static int getWordLength(String word, TableView table) {
        return table.getFontMetrics(table.getFont()).stringWidth(" " + word + " ") + 10;
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return "phing.settings.dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRunningOptionsEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhingBundle", PhingPropertiesDialog.class).getString("running.options"));
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPanelForTabs = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPathPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class HidingTargetSetting {
        private final String targetName;
        private Boolean hide;
        private final boolean hiddenByAttribute;

        private HidingTargetSetting(String targetName, Boolean hide, boolean hiddenByAttribute) {
            this.targetName = targetName;
            this.hide = hide;
            this.hiddenByAttribute = hiddenByAttribute;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public Boolean getHide() {
            return this.hide;
        }

        public void setHide(Boolean hide) {
            this.hide = hide;
        }

        public boolean isHiddenByAttribute() {
            return this.hiddenByAttribute;
        }
    }
}

