/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileParsedData;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import icons.PhingIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingTargetChooserDialog
extends DialogWrapper {
    private final Project myProject;
    private PhingBuildTarget mySelectedTarget;
    private Tree myTree;

    public PhingTargetChooserDialog(Project project, PhingBuildTarget selectedTarget) {
        super(project, false);
        this.myProject = project;
        this.mySelectedTarget = selectedTarget;
        this.setTitle(PhingBundle.message("phing.target.chooser.title", new Object[0]));
        this.setOKActionEnabled(this.mySelectedTarget != null);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myTree = this.initTree();
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    PhingTargetChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (PhingTargetChooserDialog.this.mySelectedTarget != null) {
                    PhingTargetChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phing/ui/explorer/PhingTargetChooserDialog$2", "onDoubleClick"));
            }
        }.installOn((Component)this.myTree);
        return panel;
    }

    private Tree initTree() {
        @NonNls DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        final Tree tree = new Tree((TreeNode)root);
        tree.getSelectionModel().setSelectionMode(1);
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = tree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    Object userObject = node.getUserObject();
                    if (userObject instanceof PhingTargetNodeDescriptor) {
                        PhingTargetNodeDescriptor phingTargetNodeDescriptor = (PhingTargetNodeDescriptor)userObject;
                        PhingTargetChooserDialog.this.mySelectedTarget = phingTargetNodeDescriptor.getPhingTarget();
                    } else {
                        PhingTargetChooserDialog.this.mySelectedTarget = null;
                    }
                } else {
                    PhingTargetChooserDialog.this.mySelectedTarget = null;
                }
                PhingTargetChooserDialog.this.setOKActionEnabled(PhingTargetChooserDialog.this.mySelectedTarget != null);
            }
        });
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        TreeSpeedSearch.installOn((JTree)tree, (boolean)false, path -> {
            @NonNls Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (userObject instanceof PhingTargetNodeDescriptor) {
                PhingBuildTarget target = ((PhingTargetNodeDescriptor)userObject).getPhingTarget();
                return target.getName();
            }
            return null;
        });
        DefaultMutableTreeNode selectedNode = null;
        PhingStateService stateService = PhingStateService.getInstance(this.myProject);
        List<PhingBuildFile> phingBuildFiles = stateService.getBuildFiles();
        for (PhingBuildFile buildFile : phingBuildFiles) {
            List<PhingBuildTarget> targets;
            DefaultMutableTreeNode buildFileNode = new DefaultMutableTreeNode(buildFile);
            PhingBuildFileParsedData parsedData = stateService.getParsedData(buildFile);
            if (parsedData == null || (targets = parsedData.getTargets()) == null || targets.isEmpty()) continue;
            DefaultMutableTreeNode selection = this.processFileTargets(targets, buildFile, buildFileNode);
            if (selection != null) {
                selectedNode = selection;
            }
            root.add(buildFileNode);
        }
        TreeUtil.expandAll((JTree)tree);
        TreeUtil.selectInTree(selectedNode, (boolean)true, (JTree)tree);
        return tree;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    private DefaultMutableTreeNode processFileTargets(List<PhingBuildTarget> targets, PhingBuildFile buildFile, DefaultMutableTreeNode buildFileNode) {
        DefaultMutableTreeNode result = null;
        for (PhingBuildTarget target : targets) {
            if (target.getName() == null) continue;
            PhingTargetNodeDescriptor descriptor = new PhingTargetNodeDescriptor(target, buildFile);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(descriptor);
            if (this.isSelected(descriptor)) {
                result = node;
            }
            buildFileNode.add(node);
        }
        return result;
    }

    private boolean isSelected(PhingTargetNodeDescriptor descriptor) {
        return this.mySelectedTarget != null && Comparing.strEqual((String)this.mySelectedTarget.getName(), (String)descriptor.getPhingTarget().getName()) && this.mySelectedTarget.getContextFile().equals(descriptor.getBuildFile().getFile());
    }

    @Nullable
    public PhingBuildTarget getSelectedTarget() {
        return this.mySelectedTarget;
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
                Object userObject = treeNode.getUserObject();
                if (userObject instanceof PhingBuildFile) {
                    PhingBuildFile buildFile = (PhingBuildFile)userObject;
                    this.append(buildFile.getPresentableName(), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    Project project = buildFile.getProject();
                    if (project == null) {
                        return;
                    }
                    XmlFile psiFile = PhingUtils.getPhingXmlFile(buildFile.getFile(), project);
                    if (psiFile == null) {
                        return;
                    }
                    PhingPredefinedProject domProject = PhingUtils.getPhingDomProject((PsiFile)psiFile);
                    if (domProject == null) {
                        return;
                    }
                    GenericAttributeValue<@NlsSafe String> name = domProject.findName();
                    String fragment = StringUtil.notNullize((String)((String)name.getValue()));
                    if (StringUtil.isEmptyOrSpaces((String)fragment)) {
                        return;
                    }
                    this.append(" <" + fragment + ">", SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else if (userObject instanceof PhingTargetNodeDescriptor) {
                    PhingTargetNodeDescriptor descriptor = (PhingTargetNodeDescriptor)userObject;
                    PhingBuildTarget phingTarget = descriptor.getPhingTarget();
                    String phingTargetName = phingTarget.getName();
                    this.append(phingTargetName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(PhingIcons.Target);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/php/phing/ui/explorer/PhingTargetChooserDialog$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static final class PhingTargetNodeDescriptor {
        private final PhingBuildTarget myPhingTarget;
        private final PhingBuildFile myBuildFile;

        private PhingTargetNodeDescriptor(PhingBuildTarget phingTarget, PhingBuildFile buildFile) {
            this.myPhingTarget = phingTarget;
            this.myBuildFile = buildFile;
        }

        public PhingBuildTarget getPhingTarget() {
            return this.myPhingTarget;
        }

        public PhingBuildFile getBuildFile() {
            return this.myBuildFile;
        }
    }
}

