/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.ui.explorer.PhingExplorer;
import com.jetbrains.php.phing.ui.explorer.PhingStateListener;
import icons.PhingIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class PhingToolWindowFactory
implements ToolWindowFactory {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            PhingToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            PhingToolWindowFactory.$$$reportNull$$$0(1);
        }
        PhingExplorer explorer = new PhingExplorer(project);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)((Object)explorer), null, false);
        content.setHelpId("reference.phing.tool.window");
        contentManager.addContent(content);
        Disposer.register((Disposable)PhingStateService.getInstance(project), (Disposable)explorer);
    }

    public void initToolWindowListener(final PhingStateService stateService) {
        stateService.addPhingStateListener(new PhingStateListener(){

            @Override
            public void buildFileChanged(PhingBuildFile buildFile) {
            }

            @Override
            public void buildFileAdded(PhingBuildFile buildFile) {
                if (stateService.getBuildFiles().size() == 1) {
                    PhingToolWindowFactory.this.getOrCreateExplorerToolWindow(buildFile.getProject());
                }
            }

            @Override
            public void buildFileRemoved(PhingBuildFile buildFile) {
                if (stateService.getBuildFiles().size() == 0) {
                    ToolWindowManager.getInstance((Project)buildFile.getProject()).unregisterToolWindow(PhingToolWindowFactory.getWindowId());
                }
            }
        });
    }

    private void getOrCreateExplorerToolWindow(@NotNull Project project) {
        ToolWindowManager toolWindowManager;
        ToolWindow toolWindow;
        if (project == null) {
            PhingToolWindowFactory.$$$reportNull$$$0(2);
        }
        if ((toolWindow = (toolWindowManager = ToolWindowManager.getInstance((Project)project)).getToolWindow(PhingToolWindowFactory.getWindowId())) == null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.createToolWindow(project, toolWindowManager);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.createToolWindow(project, toolWindowManager));
            }
        }
    }

    private void createToolWindow(@NotNull Project project, @NotNull ToolWindowManager toolWindowManager) {
        if (project == null) {
            PhingToolWindowFactory.$$$reportNull$$$0(3);
        }
        if (toolWindowManager == null) {
            PhingToolWindowFactory.$$$reportNull$$$0(4);
        }
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(PhingToolWindowFactory.getWindowId(), false, ToolWindowAnchor.RIGHT);
        toolWindow.setIcon(PhingIcons.PhingToolWindow);
        this.createToolWindowContent(project, toolWindow);
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            PhingToolWindowFactory.$$$reportNull$$$0(5);
        }
        return PhingStateService.getInstance(project).getBuildFiles().size() > 0 && ToolWindowManager.getInstance((Project)project).getToolWindow(PhingToolWindowFactory.getWindowId()) == null;
    }

    public static String getWindowId() {
        return PhingBundle.message("phing.tool.window.id", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateExplorerToolWindow";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

