/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.output;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.ui.output.PhingTextOutputView;
import com.jetbrains.php.phing.ui.output.actions.PauseOutputAction;
import com.jetbrains.php.phing.ui.output.actions.RerunAction;
import com.jetbrains.php.phing.ui.output.actions.StopAction;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhingBuildMessageView
extends JPanel {
    private static final Key<PhingBuildMessageView> KEY = Key.create((String)"PhingBuildMessageViewKey");
    private static final long EXECUTION_TIMEOUT_IN_MILLISECONDS = 3000L;
    private final PhingTextOutputView myPlainTextView;
    private final Project myProject;
    private PhingBuildFile myBuildFile;
    private final String myTarget;
    private OSProcessHandler myProcessHandler;

    private PhingBuildMessageView(Project project, PhingBuildFile buildFile, @Nullable String target) {
        super(new BorderLayout(2, 0));
        this.myProject = project;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.myPlainTextView = new PhingTextOutputView(project);
        JPanel messagePanel = new JPanel(new BorderLayout());
        this.myBuildFile = buildFile;
        this.myTarget = target;
        this.add((Component)this.createToolbarPanel().getComponent(), "West");
        this.add((Component)messagePanel, "Center");
        messagePanel.add((Component)this.myPlainTextView.getComponent(), "Center");
    }

    private ActionToolbar createToolbarPanel() {
        RerunAction runAction = new RerunAction(this);
        runAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), this);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)runAction);
        actionGroup.add((AnAction)new PauseOutputAction(this));
        actionGroup.add((AnAction)new StopAction(this));
        actionGroup.add((AnAction)new CloseAction());
        actionGroup.add((AnAction)new MyPinTabAction());
        return ActionManager.getInstance().createActionToolbar("PhingMessagesToolbar", (ActionGroup)actionGroup, false);
    }

    public void emptyAll() {
        this.myPlainTextView.clearAllMessages();
    }

    public void buildFinished(boolean isCancelled, long buildTime, int exitCode) {
        String text;
        this.printSystemMessage("\n");
        if (isCancelled) {
            String buildTimeText = buildTime < 1000L ? PhingBundle.message("phing.0.milliseconds", buildTime) : (buildTime < 60000L ? PhingBundle.message("phing.0.seconds", (double)buildTime / 1000.0) : (buildTime < 3600000L ? PhingBundle.message("phing.0.minutes", buildTime / 60000L) : PhingBundle.message("phing.0.hours", (double)buildTime / 3600000.0)));
            text = PhingBundle.message("phing.build.was.aborted.in.0.at", buildTimeText, DateFormatUtil.formatDateTime((long)Clock.getTime()));
        } else {
            text = PhingBundle.message("phing.build.finished.at", DateFormatUtil.formatDateTime((long)Clock.getTime()), exitCode);
        }
        this.printSystemMessage(text);
    }

    public boolean isOutputPaused() {
        return this.myPlainTextView.isOutputPaused();
    }

    public void setOutputPaused(boolean outputPaused) {
        this.myPlainTextView.setOutputPaused(outputPaused);
    }

    @Nullable
    public String getTarget() {
        return this.myTarget;
    }

    @Nullable
    public static PhingBuildMessageView openBuildMessageView(Project project, PhingBuildFile buildFile, @Nullable String target) {
        VirtualFile phingFile = buildFile.getFile();
        MessageView ijMessageView = MessageView.getInstance((Project)project);
        Content[] contents = ijMessageView.getContentManager().getContents();
        int result = 1;
        for (Content content : contents) {
            PhingBuildMessageView buildMessageView;
            if (content.isPinned() || (buildMessageView = (PhingBuildMessageView)content.getUserData(KEY)) == null || !phingFile.equals(buildMessageView.getBuildFile().getFile())) continue;
            if (buildMessageView.isStopped()) {
                ijMessageView.getContentManager().removeContent(content, true);
                continue;
            }
            if (result == 0) {
                buildMessageView.stopProcess();
                ijMessageView.getContentManager().removeContent(content, true);
                continue;
            }
            result = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)PhingBundle.message("starting.phing.build.dialog.title", new Object[0]), (String)PhingBundle.message("phing.is.active.terminate.confirmation.text", new Object[0])).yesText(PhingBundle.message("phing.terminate.option", new Object[0]))).noText(PhingBundle.message("phing.run.simultaneously.option", new Object[0]))).cancelText(PhingBundle.message("phing.cancel.run.option", new Object[0])).show(project);
            if (result == 0) {
                buildMessageView.stopProcess();
                ijMessageView.getContentManager().removeContent(content, true);
                continue;
            }
            if (result == 1) break;
            return null;
        }
        PhingBuildMessageView messageView = new PhingBuildMessageView(project, buildFile, target);
        Object contentName = buildFile.getPresentableName();
        contentName = PhingBuildMessageView.getBuildContentName() + " (" + (String)contentName + ")";
        ContentImpl content = new ContentImpl(messageView.getComponent(), (String)contentName, true);
        content.setHelpId("reference.phing.tool.window");
        content.putUserData(KEY, (Object)messageView);
        ijMessageView.getContentManager().addContent((Content)content);
        ijMessageView.getContentManager().setSelectedContent((Content)content);
        ProjectManager.getInstance().addProjectManagerListener(project, (ProjectManagerListener)new CloseListener((Content)content, ijMessageView.getContentManager(), project, buildFile.getName(), target));
        ToolWindow messageToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages");
        messageToolWindow.activate(null);
        return messageView;
    }

    public void stopProcess() {
        if (this.myProcessHandler == null) {
            return;
        }
        OSProcessUtil.killProcessTree((Process)this.myProcessHandler.getProcess());
        if (!this.myProcessHandler.waitFor(3000L)) {
            this.myProcessHandler.destroyProcess();
            this.myProcessHandler = null;
        }
    }

    public boolean isStopped() {
        return this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated();
    }

    public PhingBuildFile getBuildFile() {
        return this.myBuildFile;
    }

    private JComponent getComponent() {
        return this;
    }

    public void printSystemMessage(String text) {
        this.myPlainTextView.addSystemMessage(text);
    }

    public void setProcessHandler(OSProcessHandler handler) {
        this.myProcessHandler = handler;
        this.myPlainTextView.attachProcessHandler(handler);
    }

    private void close() {
        Content[] contents;
        MessageView messageView = MessageView.getInstance((Project)this.myProject);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            if (content.getComponent() != this) continue;
            messageView.getContentManager().removeContent(content, true);
            return;
        }
    }

    @Nls
    private static String getBuildContentName() {
        return PhingBundle.message("phing.build.tab.content.title", new Object[0]);
    }

    private class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            PhingBuildMessageView.this.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phing/ui/output/PhingBuildMessageView$CloseAction", "actionPerformed"));
        }
    }

    private final class MyPinTabAction
    extends ToggleAction {
        private MyPinTabAction() {
            super(PhingBundle.message("action.pin.tab.text", new Object[0]), PhingBundle.message("action.pin.tool.window.tab.description", new Object[0]), AllIcons.General.Pin_tab);
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                MyPinTabAction.$$$reportNull$$$0(0);
            }
            super.update(event);
            Presentation presentation = event.getPresentation();
            Content content = this.getContent();
            presentation.setEnabledAndVisible(content != null && content.isPinnable());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyPinTabAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Content content;
            if (event == null) {
                MyPinTabAction.$$$reportNull$$$0(2);
            }
            return (content = this.getContent()) != null && content.isPinned();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            Content content;
            if (event == null) {
                MyPinTabAction.$$$reportNull$$$0(3);
            }
            if ((content = this.getContent()) != null) {
                content.setPinned(flag);
            }
        }

        @Nullable
        private Content getContent() {
            ToolWindow window = ToolWindowManager.getInstance((Project)PhingBuildMessageView.this.myProject).getToolWindow("Messages");
            if (window != null) {
                ContentManager contentManager = window.getContentManager();
                return contentManager.getSelectedContent();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/ui/output/PhingBuildMessageView$MyPinTabAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/ui/output/PhingBuildMessageView$MyPinTabAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CloseListener
    implements VetoableProjectManagerListener,
    ContentManagerListener {
        private Content myContent;
        private boolean myCloseAllowed;
        private final ContentManager myContentManager;
        private final Project myProject;
        private final String myBuildFileName;
        private final String myTargetName;

        private CloseListener(Content content, @NotNull ContentManager contentManager, Project project, String buildFileName, String targetName) {
            if (contentManager == null) {
                CloseListener.$$$reportNull$$$0(0);
            }
            this.myCloseAllowed = false;
            this.myContent = content;
            this.myContentManager = contentManager;
            this.myProject = project;
            this.myBuildFileName = buildFileName;
            this.myTargetName = targetName;
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event == null) {
                CloseListener.$$$reportNull$$$0(1);
            }
            if (event.getContent() == this.myContent) {
                PhingBuildMessageView buildMessageView = (PhingBuildMessageView)this.myContent.getUserData(KEY);
                assert (buildMessageView != null);
                if (!this.myCloseAllowed) {
                    buildMessageView.stopProcess();
                }
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)this);
                this.myContent.release();
                this.myContent = null;
                buildMessageView.myBuildFile = null;
                buildMessageView.myPlainTextView.dispose();
            }
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            boolean canClose;
            if (event == null) {
                CloseListener.$$$reportNull$$$0(2);
            }
            if (event.getContent() == this.myContent && !(canClose = this.closeQuery())) {
                event.consume();
            }
        }

        public void projectClosed(@NotNull Project project) {
            if (project == null) {
                CloseListener.$$$reportNull$$$0(3);
            }
            if (this.myContent != null) {
                this.myContentManager.removeContent(this.myContent, true);
            }
        }

        public boolean canClose(@NotNull Project project) {
            if (project == null) {
                CloseListener.$$$reportNull$$$0(4);
            }
            return this.closeQuery();
        }

        private boolean closeQuery() {
            if (this.myContent == null) {
                return true;
            }
            PhingBuildMessageView messageView = (PhingBuildMessageView)this.myContent.getUserData(KEY);
            assert (messageView != null);
            if (messageView.isStopped()) {
                return true;
            }
            if (this.myCloseAllowed) {
                return true;
            }
            int result = Messages.showYesNoCancelDialog((String)PhingBundle.message("phing.build.is.running.terminate.phing.process.before.closing.tab", this.myBuildFileName, this.myTargetName == null ? "" : " " + this.myTargetName), (String)PhingBundle.message("close.phing.output.messages.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                messageView.stopProcess();
                this.myCloseAllowed = true;
                return true;
            }
            if (result == 1) {
                this.myCloseAllowed = true;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentManager";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/phing/ui/output/PhingBuildMessageView$CloseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoveQuery";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

