/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.ideolog.highlighting.LogParsingUtils;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.ideolog.lex.LogToken;
import com.intellij.ideolog.psi.LogPsiFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ideolog/editorActions/ExtendsSelection;", "Lcom/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase;", "<init>", "()V", "canSelect", "", "e", "Lcom/intellij/psi/PsiElement;", "select", "", "Lcom/intellij/openapi/util/TextRange;", "editorText", "", "cursorOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ideolog"})
public final class ExtendsSelection
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e instanceof LogPsiFile || e.getParent() instanceof LogPsiFile;
    }

    @NotNull
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)editorText, (String)"editorText");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Pair<CharSequence, Integer> pair = LogParsingUtils.INSTANCE.getEvent(editor, editor.getSelectionModel().getSelectionStart());
        CharSequence evt = (CharSequence)pair.component1();
        int evtOffset = ((Number)pair.component2()).intValue();
        LogFileFormat fileType = LogFileFormatsKt.detectLogFileFormat(editor);
        ArrayList tokens = new ArrayList();
        fileType.tokenize(evt, tokens, true);
        Iterator iterator = tokens.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
            LogToken logToken = (LogToken)e2;
            int startOffset = logToken.component1();
            int endOffset = logToken.component2();
            if (evtOffset + startOffset >= editor.getSelectionModel().getSelectionStart() || evtOffset + endOffset <= editor.getSelectionModel().getSelectionEnd()) continue;
            return CollectionsKt.listOf((Object)new TextRange(evtOffset + startOffset, evtOffset + endOffset));
        }
        return CollectionsKt.listOf((Object)new TextRange(evtOffset, evtOffset + evt.length()));
    }
}

