/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.editorActions;

import com.intellij.ideolog.fileType.LogFileType;
import com.intellij.ideolog.highlighting.LogEvent;
import com.intellij.ideolog.util.GoToActionContext;
import com.intellij.ideolog.util.IdeologDocumentContextKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ideolog/editorActions/GoToPrevEntryAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.ideolog"})
public final class GoToPrevEntryAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiFile psiFile = (PsiFile)e.getDataContext().getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabled(Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getFileType() : null), (Object)((Object)LogFileType.INSTANCE)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GoToActionContext goToActionContext = IdeologDocumentContextKt.getGoToActionContext(e);
        if (goToActionContext == null) {
            return;
        }
        GoToActionContext ctx = goToActionContext;
        int prevPos = ctx.getEvent().getStartOffset() - 1;
        while (prevPos >= 0) {
            LogEvent prevEvent = LogEvent.Companion.fromEditor(ctx.getEditor(), prevPos);
            if (ctx.getFoldingModel().isOffsetCollapsed(prevEvent.getStartOffset())) {
                LogEvent event = LogEvent.Companion.fromEditor(ctx.getEditor(), prevPos);
                prevPos = event.getStartOffset() - 1;
                continue;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(ctx.getProject(), ctx.getPsiFile().getVirtualFile(), prevEvent.getStartOffset());
            OpenFileDescriptor openFileDescriptor = descriptor.setUseCurrentWindow(true);
            Intrinsics.checkNotNullExpressionValue((Object)openFileDescriptor, (String)"setUseCurrentWindow(...)");
            OpenFileDescriptor navigable = openFileDescriptor;
            if (navigable.canNavigate()) {
                navigable.navigate(true);
            }
            return;
        }
    }
}

